/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iSQC
 */

package {
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
        
            map = new BitmapData(32,32, false, 0);
            mat = new Matrix(cw,0,0,cw);
        
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMdown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMup);
            stage.addEventListener(Event.ENTER_FRAME, onEnter);    
        }//ctor
        
        public function onMdown(e:MouseEvent):void { mdown = 1; }
        public function onMup(e:MouseEvent):void { mdown = 0; }
        
        public var mdown:int = 0;
        public var cw:Number = 32;
        public var map:BitmapData;
        public var mat:Matrix;
        
        public function isWall(ax:Number, ay:Number):Boolean
        {
           var tx:int; var ty:int;
           tx = Math.floor(ax/cw);            ty = Math.floor(ay/cw);                      
           return map.getPixel(tx, ty) > 0;
        }//iswall
        
        public function onEnter(e:Event):void
        {
            graphics.clear();
            graphics.lineStyle(2, 0);
            
            var tx:int; var ty:int;
            var ax:Number; var ay:Number;
            ax = stage.mouseX; ay = stage.mouseY;
            tx = Math.floor(ax/cw);            ty = Math.floor(ay/cw);            
            ax = tx*cw;            ay = ty*cw;
            
            
            if (mdown > 0) { map.setPixel(tx, ty, 0x808080); }
            
            
            graphics.beginBitmapFill(map, mat, false, false);
            graphics.drawRect(0,0,465,465);
            graphics.endFill(); 
            

            graphics.lineStyle(1, 0xFF0000);
            var wx:Number; var wy:Number;  var f:int;           
            var i:int; var k:int;                      
            for (i = 0; i < 14; i++)
            {
                wy = i * cw;
                for (k = 0; k < 14; k++)
                {
                    wx = k * cw;
                    if (isWall(wx,wy)) { continue; }
                    f = 0;
                    
                    if (isWall(wx+cw,wy)) { f|=1; }
                    if (isWall(wx-cw,wy)) { f|=2; }
                    if (isWall(wx,wy+cw)) { f|=4; }
                    if (isWall(wx,wy-cw)) { f|=8; }
                    
                    if ((f & 3) == 0) { continue; }
                    if ((f & 12) == 0) { continue; }
                    
                    
                    //if (f != 3) { continue; }
                    
                    graphics.drawRect(wx,wy,cw,cw);
                }//nextk
            }//nexti

            graphics.lineStyle(2, 0x00FF00);
            graphics.drawRect(ax,ay,cw,cw);

            
        }//onenter
        
    }//classend
}