/**
 * Copyright djankey ( http://wonderfl.net/user/djankey )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iRS6
 */

//------------------------------------------------
// RGB Separater http://wonderfl.net/c/80tm
// CMYK Separater http://wonderfl.net/c/kI5G  


package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;    
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.IOErrorEvent;
    import flash.events.ProgressEvent;
    import flash.net.FileReference;    
    import flash.net.FileFilter;   
    import flash.net.URLRequest;        
    import flash.utils.ByteArray;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.PerspectiveProjection;
    
    import com.bit101.components.PushButton;
    import com.bit101.components.Label;
    import com.bit101.components.Slider;
    
    public class Main extends Sprite {
        
        private var uploadBtn:PushButton;
        private var lbl:Label;
        private var dzSlider:Slider;
        private var uploadFileRef:FileReference = new FileReference();   
        private var imagesFilter:FileFilter = new FileFilter("Images", "*.jpg;*.gif;*.png");  
        private var uploadLoader:Loader = new Loader();
        
        private var maxWidth:int = 200;
        private var maxHeight:int = 375;      
        private var dz:int = 10;  
       
        private var rgbHolder:Sprite;
        private var cmykHolder:Sprite;
        
        private var rgbSprites:Array;
        private var cmykSprites:Array;
        
        private var loaded:Boolean = false;
        
        public function Main() {
            // write as3 code here..
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);           
        }
        
        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
           
            //stage.scaleMode = StageScaleMode.NO_SCALE;
            //stage.align = StageAlign.TOP_LEFT;      
            
            // BKG
            var bgMatrix:Matrix = new Matrix();
            bgMatrix.rotate(90 * Math.PI / 180);
            graphics.beginGradientFill("linear", [0xFFFFFF, 0x999999], [1, 1], [127, 255], bgMatrix);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);                 
               
            /*  
            var pp:PerspectiveProjection = new PerspectiveProjection();
               pp.fieldOfView = 100;                        
               pp.projectionCenter = new Point(232, 210);               
            transform.perspectiveProjection = pp;
            */
            
            // RGB 
            rgbHolder = new Sprite();
            rgbHolder.x = 115;
            rgbHolder.y = 210;
            addChild(rgbHolder);
            
            // CMYK
            cmykHolder = new Sprite();
            cmykHolder.x = 350;
            cmykHolder.y = 210;
            addChild(cmykHolder);
            
            dzSlider = new Slider("horizontal", this, 350, 445, onSliderChange);
            dzSlider.value = dz * 2;         
            dzSlider.visible = false;
            
            uploadBtn = new PushButton(this, 200, 440, "Upload image", btnClick);
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMove);
        }
        
        private function onSliderChange(event:Event):void
        {
            dz = Math.round(event.target.value * 0.5);
            updateZ();            
        }
        
        private function mouseMove(event:MouseEvent):void
        {
            var rotX:Number = (mouseY - 210) * -0.2;
            var rotY:Number = (mouseX - 232) * 0.2;   
            
            rgbHolder.rotationX = rotX;
            rgbHolder.rotationY = rotY;  
                     
            cmykHolder.rotationX = rotX;
            cmykHolder.rotationY = rotY;
        }
        
        private function btnClick(event:MouseEvent):void
        {
            uploadFileRef.browse([imagesFilter]);            
            uploadFileRef.addEventListener(Event.SELECT, onSelectFile);    
        }
       
        private function onSelectFile(event:Event):void
       { 
           uploadFileRef.load();            
           uploadFileRef.addEventListener(Event.COMPLETE, uploadLoaded);
       }  
       
       private function uploadLoaded(event:Event):void
       {
            var rawBytes:ByteArray = uploadFileRef.data;
            uploadLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, getBitmapData);
            uploadLoader.loadBytes(rawBytes);
       }
       
       private function getBitmapData(event:Event):void
       {            
            var imageInfo:LoaderInfo = LoaderInfo(event.target);            
            var bd:BitmapData = new BitmapData(imageInfo.width, imageInfo.height);            
                bd.draw(imageInfo.loader);
                            
            var scale:Number = 1;
            var matrix:Matrix = new Matrix();
            var w:int = bd.width;
            var h:int = bd.height;
                        
            (maxWidth/maxHeight < w/h) ? scale = maxWidth/w : scale = maxHeight/h;  
            matrix.scale(scale, scale);
            var resizedBD:BitmapData = new BitmapData(w * scale, h * scale, true, 0x000000);
                resizedBD.draw(bd, matrix, null, null, null, true);

            processImage(resizedBD);            
       }
       
       //-----------------------------------------------------------------------
       private function processImage(bd:BitmapData):void
       {          
          // RGB
          while(rgbHolder.numChildren != 0) rgbHolder.removeChildAt(0); // clear
          rgbSprites = new Array();
          
          var rgbLayers:Array = RGB.separate(bd);
          var rgbSpr:Sprite = new Sprite();
          rgbSpr.x = -bd.width * 0.5;
          rgbSpr.y = -bd.height * 0.5;
          rgbHolder.addChild(rgbSpr);
                
          for (var i:int = 0; i < rgbLayers.length; i++)
          {                
                var spr:Sprite = new Sprite();              
                spr.graphics.beginBitmapFill( rgbLayers[i], null, false, true);                
                spr.graphics.drawRect(0, 0, rgbLayers[i].width, rgbLayers[i].height);
                spr.graphics.endFill();
                
                rgbSpr.addChild(spr);              
                rgbSprites[i] = spr;
                
                // background
                if (i != 0) spr.blendMode = BlendMode.SCREEN;
          }
          
          // CMYK
          while(cmykHolder.numChildren != 0) cmykHolder.removeChildAt(0); // clear
          cmykSprites = new Array();
          
          var cmykLayers:Array = new CMYK().separate(bd);
          var cmykSpr:Sprite = new Sprite();
          cmykSpr.x = -bd.width * 0.5;
          cmykSpr.y = -bd.height * 0.5;          
          cmykHolder.addChild(cmykSpr);
          
          for (var j:int = 0; j < cmykLayers.length; j++)
          {    
              var spr2:Sprite = new Sprite();            
              spr2.graphics.clear();
              spr2.graphics.beginBitmapFill( cmykLayers[j], null, false, true);            
              spr2.graphics.drawRect(0, 0, cmykLayers[j].width, cmykLayers[j].height);
              spr2.graphics.endFill();        
                
              if(j!=0) spr2.blendMode = BlendMode.MULTIPLY;       
              cmykSpr.addChild(spr2);             
              cmykSprites[j] = spr2;      
          }
          
          if(loaded==false) {
              loaded = true;
              dzSlider.visible = true;
          }
          
          updateZ();
       }
       
       private function updateZ():void
       {
          var i:int;
          var plus_z:int ;
          
          // RGB
          plus_z = (rgbSprites.length * dz) * 0.5;           
          for (i = 0; i < rgbSprites.length; i++) 
          { 
             rgbSprites[i].z = plus_z - i * dz;
          }
          
          // CMYK
          plus_z = (cmykSprites.length * dz) * 0.5;           
          for (i = 0; i < cmykSprites.length; i++) 
          { 
             cmykSprites[i].z = plus_z - i * dz;
          }
       }
      
    }
}


//-------------- RGB ----------------
// based on
// RGB Separater http://wonderfl.net/c/80tm
// by clockmaker http://wonderfl.net/user/clockmaker

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.BitmapDataChannel;
import flash.display.BlendMode;
import flash.geom.Point;
import flash.geom.Rectangle;

class RGB
{
    static public function separate(bmd:BitmapData):Array
    {
       var w:uint = bmd.width;
       var h:uint = bmd.height;    
       var rect:Rectangle = new Rectangle(0, 0, w, h);
       var point:Point = new Point(0, 0);

       // BitmapData
       var r:BitmapData = new BitmapData(w, h, true, 0xFF000000);
       var g:BitmapData = new BitmapData(w, h, true, 0xFF000000);
       var b:BitmapData = new BitmapData(w, h, true, 0xFF000000);
          
       var bkg:BitmapData = new BitmapData(w, h, true, 0xFF000000);
          
       // RGB
       r.copyChannel(bmd, rect, point, BitmapDataChannel.RED, BitmapDataChannel.RED);
       g.copyChannel(bmd, rect, point, BitmapDataChannel.GREEN, BitmapDataChannel.GREEN);
       b.copyChannel(bmd, rect, point, BitmapDataChannel.BLUE, BitmapDataChannel.BLUE);
             
       return [bkg, r, g, b];   
    }
}

//-------------- CMYK ----------------
// based on
// CMYK Separater http://wonderfl.net/c/kI5G  
// by zahir http://wonderfl.net/user/zahir

import flash.display.BitmapData;
import flash.display.BlendMode;
import flash.display.ShaderJob;

class CMYK
{
    public function separate(bd:BitmapData):Array
    {       
        var w:int = bd.width;
        var h:int = bd.height;
            
        var c:BitmapData = new BitmapData(w, h, true, 0x00000000);            
        var m:BitmapData = new BitmapData(w, h, true, 0x00000000);            
        var y:BitmapData = new BitmapData(w, h, true, 0x00000000);            
        var k:BitmapData = new BitmapData(w, h, true, 0x00000000);        
            
       shader( bd, c, CMYKChannel.C );
       shader( bd, m, CMYKChannel.M );
       shader( bd, y, CMYKChannel.Y );
       shader( bd, k, CMYKChannel.K );
       
       var bkg:BitmapData = new BitmapData(w, h, true, 0xFFFFFFFF);
        
       var layers:Array = [bkg, c, m, y, k];       
       return layers;
    }    
   
   private function shader( src:BitmapData, dst:BitmapData, channel:int = 0, alpha:Boolean = true ):void
   {
       var s:CMYKChannel = new CMYKChannel( src, channel, alpha );
       var sj:ShaderJob = new ShaderJob( s, dst, dst.width, dst.height );
       sj.start( true );
   }
}

// CMYKChannel
import flash.display.BitmapData;
import flash.display.Shader;
import flash.utils.ByteArray;
import mx.utils.Base64Decoder;

class CMYKChannel extends Shader{
    static private var code:ByteArray;
    
    // static initializer
    {
        private static var dec:Base64Decoder = new Base64Decoder() ;
        dec.decode(
            "pQEAAACkCwBjb3B5Q2hhbm5lbKAMbmFtZXNwYWNlAGpwLnphaGlyAKAMdmVuZG9yAHphaGlyAKAI" +
            "dmVyc2lvbgABAKEBAgAADF9PdXRDb29yZACjAARzcmMAoQIEAQAPZHN0AKEBCAGACGRzdENoYW5u" +
            "ZWwAoghtYXhWYWx1ZQADAKIIbWluVmFsdWUAAACiCGRlZmF1bHRWYWx1ZQAAAKIMZGVzY3JpcHRp" +
            "b24AMDpDIDE6TSAyOlkgMzpLAKEBDQGABGFscGhhAKINZGVmYXVsdFZhbHVlAAEAMAIA8QAAEAAd" +
            "AwDzAgAbADIAACAAAAAAMgGAIAAAAAAoAYCAAYCAAB0BgBAAgAAANAAAAAGAwAAyAAAQP4AAAB0C" +
            "AIAAAMAAAgIAgAMAAAAdAAAgAgAAADIDAIAAAAAAMgMAQAAAAAAyAwAgAAAAAB0DAEAAAIAAHQMA" +
            "IAAAgAA1AAAAAAAAADIBgCABAAAAKAGAgAGAgAAdAoCAAIAAADQAAAACgAAAMgAAED+AAAAdAgCA" +
            "AADAAAICAIADAEAAHQAAIAIAAAAyAwCAAAAAADIDAEAAAAAAMgMAIAAAAAAdAwCAAACAAB0DACAA" +
            "AIAANQAAAAAAAAAyAYAgAgAAACgBgIABgIAAHQKAQACAAAA0AAAAAoBAADIAABA/gAAAHQIAgAAA" +
            "wAACAgCAAwCAAB0AACACAAAAMgMAgAAAAAAyAwBAAAAAADIDACAAAAAAHQMAgAAAgAAdAwBAAACA" +
            "ADUAAAAAAAAAMgGAIAMAAAAoAYCAAYCAAB0CgCAAgAAANAAAAAKAgAAyAAAQP4AAAB0CAIAAAMAA" +
            "AgIAgAMAAAAdAAAQAgAAADICAIA/gAAAHQIAQAIAAAACAgBAAwBAAB0CAIACAEAAMgIAQD+AAAAd" +
            "AgAgAgBAAAICACADAIAAHQIAQAIAgAAdAgAgAgAAAAkCACACAEAAHQIAEAAAwAAJAgAQAgCAAB0A" +
            "ACACAMAAMgIAID+AAAAdAgAQAgCAAAICABAAAIAAHQQAgAIAwAAyAgAgP4AAAB0CABACAIAAAgIA" +
            "EAAAgAAdBABAAgDAADICACA/gAAAHQIAEAIAgAACAgAQAACAAB0EACACAMAAHQMA4gQAGAA2AAAA" +
            "AAAAADYAAAAAAAAANgAAAAAAAAA2AAAAAAAAADIBgCABAAAAKAGAQAGAgAAdAYAQAIAAADQAAAAB" +
            "gMAAHQMAEAAAgAA2AAAAAAAAAB0BAPMDABsA" );
        code = dec.toByteArray();
        dec = null;
    }
    public static const C:int = 0;
    public static const M:int = 1;
    public static const Y:int = 2;
    public static const K:int = 3;
    
    public function CMYKChannel( bitmapData:BitmapData, channel:int, alpha:Boolean = true ){
        super( code );
        src( bitmapData, bitmapData.width, bitmapData.height );
        dstChannel = [ channel ];
    }
    
    public function get alpha():Array{
        return data[ "alpha" ].value;
    }
    public function set alpha( value:Array ):void{
        data[ "alpha" ].value = value;
    }
    
    public function get dstChannel():Array{
        return data[ "dstChannel" ].value;
    }
    public function set dstChannel( value:Array ):void{
        data[ "dstChannel" ].value = value;
    }
    
    public function src( input:*,  width:int, height:int):void{
        data[ "src" ].input = input;
        data[ "src" ].width = width;
        data[ "src" ].height = height;
    }
    public function get srcChannels():int{
        return data[ "src" ].channels;
    }
}