/**
 * Copyright meemeer ( http://wonderfl.net/user/meemeer )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iROO
 */

/*
def get_wonderfl_code_rank
end

wonderfl code rank 一覧

http://5ivestar.org/blog/2008/12/wonderfl-webproxy/
proxy利用させて頂きました。
*/

package {
	
	import caurina.transitions.Tweener;
	import com.bit101.components.Label;
	import flash.system.Security;
	import flash.system.LoaderContext;
	import flash.display.Bitmap;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.net.URLRequest;
	import jp.progression.data.*;
	import jp.progression.commands.lists.SerialList;
	import jp.progression.commands.net.LoadBitmapData;
	
	[SWF(width="464", height="464",backgroundColor="#000000",frameRate="30")]
	
    public class FlashTest extends Sprite {
		
		private var model:Vector.<Model>;	
		private var label:Label;
		private var imgWidth:int = 77;
		private var imgHeight:int = 77;
		private var imgOffset:int = 2;
		
        public function FlashTest() {
            // write as3 code here..
            
            label = new Label(this, 220, 220, 'test');
            Security.loadPolicyFile("http://5ivestar.org/proxy/crossdomain.xml");
            
            new SerialList(null,
                new Amf('SampleController.get_wonderfl_code_rank',
                    function(res:Object):Vector.<Model> {
                    	    var modelV:Vector.<Model> = new Vector.<Model>(res.length);
        	    					res.forEach(function(o:Object, i:int, a:Array):void {
							var model:Model = new Model(o);
							modelV[i] = model;
						} );
						return modelV;
                    }, {
						onStart:function():void {
							trace('amf start');
							label.text = 'AMF start';
						},
						onComplete:function():void {
							trace('amf end');
							label.text = 'AMF end';
						}
					},
                    5
                ),
                function():void {
					var count:int = 0;
					var list:SerialList = new SerialList();
					model = this.latestData;
					model.forEach(function(m:Model, i:int, v:Vector.<Model>):void {
						var req:URLRequest = new URLRequest('http://5ivestar.org/proxy/' + m.src);
						var loader:LoadBitmapData = new LoadBitmapData(req, { context:new LoaderContext(true) } );
						loader.onComplete = function():void {
							var bm:Bitmap = new Bitmap(getResourceById('http://5ivestar.org/proxy/' + m.src).toBitmapData());
							bm.width = imgWidth - imgOffset;
							bm.height = imgHeight - imgOffset;
							addChild(bm);
							bm.x = imgWidth * (count % 6) + imgOffset,
							bm.y = imgHeight * Math.round(count / 6 - 0.5) + imgOffset
							count++;
						}
						loader.catchError = function():void {
							trace('error');
							this.executeComplete();
						}
						list.addCommand(loader);
					} );
					list.onStart = function():void {
						trace('load start');
						label.text = 'load start';
					}
					list.onPosition = function():void { trace(list.position / list.numCommands); }
					list.onComplete = function():void {
						trace('load end');
						label.text = 'load start';
					}
					list.execute();
                },
                function():void {
                		stage.addEventListener(MouseEvent.MOUSE_MOVE, move, false, 0, true);
                }
            ).execute();
        }
        
		private function move(e:MouseEvent):void 
		{
			var margin:Number = imgHeight,
				ay:Number,
				dy:Number;
			ay = this.stage.mouseY / this.stage.stageHeight;
			dy = margin - (this.height - this.stage.stageHeight + margin * 2) * ay;
			Tweener.addTween(this, { y:dy, time:2 } );
		}
    }
}

class Model
{
	private var _href:String;
	public function get href():String { return _href; }
	
	private var _src:String;
	public function get src():String { return _src; }
	
	public function Model(data:Object)
	{
		this._href = data.href;
		this._src = data.src;
	}
	
	public function destroy():void
	{
		this._href = null;
		this._src = null;
	}
}

import flash.events.Event;
import flash.net.Responder;
import jp.progression.casts.*;
import jp.progression.commands.display.*;
import jp.progression.commands.lists.*;
import jp.progression.commands.net.*;
import jp.progression.commands.tweens.*;
import jp.progression.commands.*;
import jp.progression.data.*;
import jp.progression.events.*;
import jp.progression.scenes.*;

/**
 * ...
 * @author m_emem
 */
class Amf extends Command 
{
	private var _amf:AmfConnect;
	private var _func:String;
	private var _args:Object;
	private var _callback:Function;
	
	/**
	 * 新しい AmfCommand インスタンスを作成します。
	 */
	public function Amf( func:String, callback:Function, initObject:Object = null, ... args:Array ) 
	{
		_func = func;
		_callback = callback;
		_args = args;
		
		// 親クラスを初期化します。
		super( _execute, _interrupt, initObject );
	}
	
	/**
	 * 実行されるコマンドの実装です。
	 */
	private function _execute():void 
	{
		_amf = AmfConnect.instance;
		_amf.dispatcher.addEventListener(Event.COMPLETE, _complete, false, 0, true);
		
		var params:Array = [_func, _callback];
		params.push.apply(params, _args);
		_amf.execute.apply(_amf, params);
		
		// 
		//executeComplete();
	}
	
	/**
	 * 中断されるコマンドの実装です。
	 */
	private function _interrupt():void 
	{
	}
	
	private function _complete(e:Event):void
	{
		_amf.dispatcher.removeEventListener(Event.COMPLETE, _complete);
		latestData = _amf.data;
		
		_amf.data = null;
		_func = null;
		_callback = null;
		_args = null;
		
		if (_amf.error != null) {
			super.throwError(this, new Error(_amf.error));
		} else {
			super.executeComplete();
		}
	}
	
	/**
	 * インスタンスのコピーを作成して、各プロパティの値を元のプロパティの値と一致するように設定します。
	 */
	public override function clone():Command 
	{
		return new Amf( _func, _callback, this, _args );
	}
}

import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.IEventDispatcher;
import flash.events.NetStatusEvent;
import flash.net.NetConnection;
import flash.net.ObjectEncoding;
import flash.net.Responder;

/**
 * ...
 * @author m_emem
 */
class AmfConnect
{
	private static var _instance:AmfConnect;
	public var dispatcher:IEventDispatcher;
	public var nc:NetConnection;
	public var error:Object;
	
	//private var gatewayUrl:String = 'http://localhost:13000/rubyamf/gateway';
	private var gatewayUrl:String = 'http://afternoon-spring-97.heroku.com/rubyamf/gateway';
	private var callback:Function;
	public var data:Object;
	
	public function AmfConnect() 
	{
		if (_instance === null) {
			_instance = this;
			init();
		} else {
			throw new Error('Singleton class');
		}
	}
	
	public static function get instance():AmfConnect
	{
		if (_instance === null) {
			_instance = new AmfConnect();
		}
		return _instance;
	}
	
	private function init():void
	{
		dispatcher = new EventDispatcher();
		error = null;
		
		nc = new NetConnection();
		nc.objectEncoding = ObjectEncoding.AMF3;
		nc.addEventListener(NetStatusEvent.NET_STATUS, onNetStatus);
		nc.connect(gatewayUrl);
	}
	
	private function onNetStatus(e:NetStatusEvent):void 
	{
		trace("Connection error, error code: (" +e.info.code + ")", "System message");
	}
	
	public function execute(_func:String, _callback:Function, ... _args:Array):void
	{
		callback = _callback;
		
		var params:Array = [_func, new Responder(onResultHandler, onFaultHandler)];
		params.push.apply(params, _args);
		nc.call.apply(nc, params);
	}
	
	private function onResultHandler(result:Object):void
	{
		if (callback != null) {
			data = callback.call(null, result);
		} else {
			data = result;
		}
		dispatcher.dispatchEvent(new Event(Event.COMPLETE));
	}
	
	private function onFaultHandler(fault:Object):void
	{
		data = fault;
		error = 'discription: ' + fault.description + ' code: ' + fault.code + ' details: ' + fault.details + ' level: ' + fault.level + ' line: ' + fault.line;
		dispatcher.dispatchEvent(new Event(Event.COMPLETE));
	}
	
}