/**
 * Copyright civet ( http://wonderfl.net/user/civet )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iR4F
 */

//2010-04-24 19:18:27
package {
    import flash.display.*;
    import flash.events.*;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.Quad;
    import org.libspark.betweenas3.events.TweenEvent;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.tweens.ITweenGroup;
    
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    
    public class Main extends Sprite
    {
            private var numSwords:int = 6;
            private var swords:Vector.<Sword>;
            private var tweens:ITweenGroup;
            private var mouseUp:Boolean;
            private var centerX:int;
            private var centerY:int;
            private var source:BitmapData;
        
        public function Main() {
            var bg:Shape = new Shape();
            bg.graphics.beginFill(0);
            bg.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            bg.graphics.endFill();
            this.addChild(bg);
            centerX = stage.stageWidth/2;
            centerY = stage.stageHeight/2;
            init();
        }
        
        private function init():void
        {
                source = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0);
                this.addChild(new Bitmap(source));
            
                swords = new Vector.<Sword>();
               for(var i:int=0; i < numSwords; ++i) {
                   var sword:Sword = new Sword();
                    swords.push(sword);
               }
               
                stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
                stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        }
        
        private function ready():void
           {
               var groups:Array = [];
               
               for(var i:int=0; i < numSwords; ++i)
               {
                   var sword:Sword = swords[i];
                    var ox:int = centerX - Math.random() * 180 + 90;
                    var oy:int = centerY + 100;
                    sword.x = ox;
                    sword.y = oy;
                   
                    var a:Number = 45 - Math.random() * 30 + 15;
                    
                    var group:ITweenGroup = BetweenAS3.serial(
                    BetweenAS3.addChild(sword, this),
                    BetweenAS3.tween(sword, {rotation: -360-(90-a), y: oy - 200, alpha:1.0}, {rotation: 0, y: oy, alpha:0.0}, 0.8, Quad.easeOut),
                    BetweenAS3.to(sword, {x: ox + Math.cos(a * Math.PI/180) * 400, y: (oy -200) + Math.sin(a * Math.PI/180) * 400}, 0.2),
                    BetweenAS3.removeFromParent(sword)
                );
                groups.push(group);
               }
               
               tweens = BetweenAS3.parallelTweens(groups);
           }
        
        private function onMouseDown(e:Event):void
        {
                stage.removeEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);       
                ready();
                mouseUp = false;
                tweens.addEventListener(TweenEvent.UPDATE, onTweenUpdate);
                tweens.addEventListener(TweenEvent.COMPLETE, onTweenComplete);
                tweens.play();
            }
        
         private function onMouseUp(e:Event):void
        {
                stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
                mouseUp = true;
                if(tweens.position > 0.75) {
                    tweens.addEventListener(TweenEvent.UPDATE, onTweenUpdate);
                    tweens.togglePause();
                }
            }
            
            private function onTweenUpdate(e:Event):void
            {
                if(tweens.position > 0.75) {
                    if(!mouseUp) {
                        tweens.removeEventListener(TweenEvent.UPDATE, onTweenUpdate);
                        tweens.togglePause();
                    }
                    else {
                        source.draw(this);
                    }
                }    
            }
            
            private function onTweenComplete(e:Event):void
            {
                stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);    
                stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
                tweens.removeEventListener(TweenEvent.UPDATE, onTweenUpdate);
                source.fillRect(source.rect, 0);
            }
    }
}


//Sword from: http://wonderfl.net/c/tk1s by:夏天的树人
import flash.display.Sprite;
import flash.display.Graphics;

class Sword extends Sprite
{
    private var pen:Graphics;
    private var array:Array=[ [55,0],
        [55,50],
        [20,50],
        [20,60],
        [50,60],
        [50,300],
        [60,340],
        [70,300],
        [70,60],
        [100,60],
        [100,50],
        [65,50],
        [65,0],
        [55,0]
    ];
    public function Sword()
    {
        pen = this.graphics;
        pen.moveTo(array[0][0]-60, array[0][1]-95);
        pen.beginFill(0xffffff);
        var len:int = array.length;
        for (var i:int=0; i<len; i++)
        {
            pen.lineTo(array[i][0]-60, array[i][1]-95);
        }
        pen.endFill();
        
        pen.beginFill(0xffffff);
        pen.drawCircle(0, -40, 20);
        pen.drawCircle(0, -40, 16);
        pen.endFill();
        
        this.scaleX = this.scaleY = 0.5;
    }
}