/**
 * Copyright fukt ( http://wonderfl.net/user/fukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iQcx
 */

// forked from terra1119's forked from: Dynamic sound generation test ※音が出ます
// forked from terra1119's Dynamic sound generation test ※音が出ます
package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.events.SampleDataEvent;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundTransform;
    import flash.display.DisplayObjectContainer;
    import flash.text.TextField;
    import flash.filters.BlurFilter;
    [SWF(width="550", height="400", frameRate="30", backgroundColor="#000000")]

    public class TestSynthe extends Sprite {
        private var phase:Number=0;
        private var freq:Number=440;
        private const PI2:Number=Math.PI*2;
        private var soundChannelObject:SoundChannel= new SoundChannel();
        private var soundTr:SoundTransform=new SoundTransform();
        private var text_field:TextField = new TextField();
        private var isPlaying:Boolean=true;
        private var ball:Sprite;
        private var blurObj:BlurFilter;
                private var soundObj:Sound;
        
        public function TestSynthe() {
            soundObj = new Sound();
            soundObj.addEventListener(SampleDataEvent.SAMPLE_DATA,onSampleData);
            stage.addEventListener(MouseEvent.MOUSE_MOVE,mouseMoveHandler);
            stage.addEventListener(MouseEvent.CLICK,clickHandler);
            soundChannelObject=soundObj.play();
            addChild(text_field);
            text_field.border=true;
            text_field.background=true;
            text_field.backgroundColor=0xFFFFFF;
            text_field.width=120;
            text_field.height=20;
            text_field.x=stage.stageWidth-text_field.width-10;
            text_field.y=stage.stageHeight-text_field.height-10;
            textSet();
        }
        private function mouseMoveHandler(e:MouseEvent):void {
            freq=mouseY*2+55;
            textSet();
            if (isPlaying) {
              //  createBall();
            }
        }
        private function clickHandler(e:MouseEvent):void {
                        
            isPlaying=! isPlaying;
            if (! isPlaying) {
                //soundTr.volume=0;
                //soundChannelObject.soundTransform=soundTr;
                                soundChannelObject.stop();
                                soundObj.removeEventListener(SampleDataEvent.SAMPLE_DATA,onSampleData);
                                
            } else {
                //soundTr.volume=1;
                //soundChannelObject.soundTransform=soundTr;
                                soundObj.addEventListener(SampleDataEvent.SAMPLE_DATA,onSampleData);
                                soundChannelObject=soundObj.play();
            }
        }
        private function onSampleData(e:SampleDataEvent):void {
            var smpl:Number;
            //var w:Number=PI2*freq/44100;
                        var f0:Number = freq / 44100;
                        var f1:Number = 44100 / freq;
                        var PAI2:Number = 2 * Math.PI;

            var latency:Number=e.position/44.1-soundChannelObject.position;
                       

            for (var i:int = 0; i < 2048; ++i) {
                                /*
                phase+=w;
                if (phase>PI2) {
                    phase-=PI2;
                }

                smpl=Math.sin(phase);*/
                                smpl=(Math.sin(PAI2 * f0 * Number(i + e.position)) < 0) ?
              (4 * f0 * ((i + e.position) % (f1 / 2)) - 1) :
              (-4 * f0 * ((i + e.position) % (f1 / 2)) + 1);
                e.data.writeFloat(smpl);
                e.data.writeFloat(smpl);
            }
        }
        private function textSet():void {
            var str:String=String(freq);
            text_field.text="Frequency="+str+"Hz";
        }
        private function createBall():void {
            blurObj=new BlurFilter();
            blurObj.blurX=2;
            blurObj.blurY=2;
            ball=new Sprite();
            addChild(ball);
            ball.graphics.beginFill(Math.random()*0xFFFFFF);
            ball.graphics.drawCircle(mouseX,mouseY,freq/10);
            ball.graphics.endFill();
            ball.blendMode="add";
            ball.filters=[blurObj];
            ball.addEventListener(Event.ENTER_FRAME,efHandler);
                        //ball.addEventListener(MouseEvent.CLICK,clickHandler)
        }
        private function efHandler(e:Event):void {
            var targetSprite:Sprite=e.target as Sprite;
            targetSprite.alpha-=0.15;
            blurObj.blurX+=5;
            blurObj.blurY+=5;
            if (targetSprite.alpha<0) {
                targetSprite.removeEventListener(Event.ENTER_FRAME,efHandler);
                removeChild(targetSprite);
                                targetSprite=null;
                                
            }
            targetSprite.filters=[blurObj];
        }
    }
}