/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iQX6
 */

// forked from nackpan's Russian Alphabet ロシア語アルファベットの発音
package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    /**
     * ...
     * @author nackpan
     */
    public class Main extends Sprite 
    {
        private var scene:GameScene;
        private var mainScene:Sprite;
        private var qaList:QandAList;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            //問題と解答を用意
            qaList = new QandAList();
            qaList.init();
            //各シーンへ（まずタイトルから）
            scene = new TitleScene(qaList);
            addChild(scene);
            
            start();
        }
        
        public function start():void
        {
            scene.addEventListener(Event.COMPLETE, complete);
            scene.start();
        }
        
        public function complete(event:Event):void
        {
            scene.removeEventListener(Event.COMPLETE, complete);
            removeChild(scene);
            scene = scene.next;
            addChild(scene);
            start();
        }
    }
}

class QandAList 
{
    private var qaVector:Vector.<QandAObject>;
    private var currentIndex:int;
    public var length:int = 0;
    
    public function QandAList()
    {
        qaVector = new Vector.<QandAObject>();
    }
    
    //問題と答えをセットする
    public function init():void
    {
        var delimiter1:String = ";";
        var delimiter2:String = ",";
        var dataArray:Array = new Array(
                "А,а;a,ア",
                "Б,б;b,ブ",
                "В,в;v,ヴ",
                "Г,г;g,グ",
                "Д,д;d,ドゥ",
                "Е,е;ye,ィエ",
                "Ё,ё;yo,ィオ",
                "Ж,ж;zh,ジ",
                "З,з;z,ズ",
                "И,и;i,イー",
                "Й,й;y,イ",
                "К,к;k,ク",
                "Л,л;l,ル",
                "М,м;m,ム",
                "Н,Н;n,ン",
                "О,о;o,オ",
                "П,п;p,プ",
                "Р,р;r,ル",
                "С,с;s,ス",
                "Т,т;t,ト",
                "У,у;u,ウ",
                "Ф,ф;f,フ",
                "Х,х;kh,ハ",
                "Ц,ц;ts,ツ",
                "Ч,ч;ch,チ",
                "Ш,ш;sh,シ",
                "Щ,щ;sh,シ",
                "Ъ,ъ;,分離記号",
                "Ы,ы;i,ウイ",
                "Ь,ь;,軟音記号",
                "Э,э;e,エ",
                "Ю,ю;yu,ィウ",
                "Я,я;ya,ィア");
        
        length = dataArray.length;
        var i:int;
        var j:int;
        for (i = 0; i < dataArray.length; i++) {
            var qaObj:QandAObject = new QandAObject();
        
            var data:String = dataArray[i];
            var keysAndValues:Array = data.split(";");
            var keys:Array = keysAndValues[0].split(",");
            for (j = 0; j < keys.length; j++) {
                qaObj.addKey(keys[j]);
            }
            
            if(keysAndValues.length >= 2){
                var values:Array = keysAndValues[1].split(",");
                for (j = 0; j < values.length; j++)
                {
                    qaObj.addValue(values[j]);
                }
            }
            qaVector.push(qaObj);
        }
    }
    
    public function add(element:QandAObject):void
    {
        qaVector.push(element);
    }
    
    //出題する
    public function askQuestion(index:int, indexCase:int):String
    {
        currentIndex = index;
        return qaVector[index].getKey(indexCase);
    }
    
    //番号indexの問題に対する回答の正否を判定する
    public function match(index:int, answer:String):Boolean
    {
        return qaVector[index].match(answer);
    }
    
    public function getKeys(index:int):Vector.<String>
    {
        return qaVector[index].getKeys();
    }
    
    public function getValues(index:int):Vector.<String>
    {
        return qaVector[index].getValues();
    }
    
    //正答かチェックする
    public function checkCorrect(index:int):Boolean
    {
        return qaVector[index].checkCorrect();
    }
    
    public function get correctCount():int
    {
        var count:int = 0;
        for (var i:int = 0; i < length; i++) {
            if (qaVector[i].checkCorrect()) {
                count++;
            }
        }
        return count;
    }
}

class QandAObject
{
    private var keys:Vector.<String>;
    private var values:Vector.<String>;
    private var userAnswer:String;
    private var correctFlag:Boolean;
    
    public function QandAObject()
    {
        keys = new Vector.<String>();
        values = new Vector.<String>();
    }
    
    public function addKey(key:String):void
    {
        keys.push(key);
    }
    
    public function addValue(value:String):void
    {
        values.push(value);
    }
    
    public function getKey(index:int):String
    {
        return keys[index];
    }
    
    public function getKeys():Vector.<String>
    {
        return keys;
    }
    
    public function getValues():Vector.<String>
    {
        return values;
    }
    
    public function match(val:String):Boolean
    {
        val = val.toLocaleLowerCase();
        
        var blValue:Boolean = false;
        var len:int = values.length;
        var i:int;
        for (i = 0; i < len; i++)
        {
            if (val == values[i]) {
                blValue = true;
                break;
            }
        }
        
        //回答とその正否を登録する
        registerAnswer(val, blValue);
        
        return blValue;
    }
    
    //回答とその正否を登録する
    private function registerAnswer(val:String, bool:Boolean):void
    {
        userAnswer = val;
        
        if (bool) {
            correctFlag = true;
        }else {
            correctFlag = false;
        }
    }
    
    //正答かチェックする
    public function checkCorrect():Boolean
    {
        return correctFlag;
    }
}

import flash.display.Sprite;
import flash.events.Event;
class GameScene extends Sprite 
{
    protected var _next:GameScene;
    private var _qaList:QandAList;
    
    public function GameScene(qa:QandAList)
    {
        _qaList = qa;
    }
    
    public function start():void{}
    
    public function exit():void{}
    
    public function get next():GameScene
    {
        return _next;
    }
    
    protected function get qaList():QandAList
    {
        return _qaList;
    }
}

import flash.display.Sprite;
import flash.events.Event;
import flash.ui.Keyboard;
import flash.events.KeyboardEvent;
import flash.events.MouseEvent;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
class TitleScene extends GameScene
{
    private var alphabetTable:AlphabetTable;
    
    public function TitleScene(qalist:QandAList)
    {
        super(qalist);
    }
    
    override public function start():void
    {
        ////タイトルとアルファベット表を描く
        var titleText:TextField = new TextField();
        addChild(titleText);
        titleText.autoSize = TextFieldAutoSize.LEFT;
        titleText.defaultTextFormat = new TextFormat(null, 20);
        titleText.text = "ロシア語アルファベットの大まかな発音";
        titleText.x = 50;
        titleText.y = 10;
        
        var alphabetTable:AlphabetTable = new AlphabetTable();
        alphabetTable.draw(qaList, 0);
        alphabetTable.x = 20;
        alphabetTable.y = 50;
        addChild(alphabetTable);
        
        var caption0:TextField = new TextField();
        addChild(caption0);
        caption0.width = 450;
        caption0.height = 60;
        caption0.wordWrap = true;
        caption0.defaultTextFormat = new TextFormat(null, 14);
        caption0.x = 22;
        caption0.y = 360;
        var str:String = "クリックかENTER KEYを押すと問題が出題されます。\r";
        str += "問題「A」の場合「a」もしくは「ア」と入力してENTER KEYを押してください。\r";
        str += "「分離記号」「軟音記号」はそのままENTER KEYを押してください。";
        caption0.text = str;
        
        var caption1:TextField = new TextField();
        addChild(caption1);
        caption1.autoSize = TextFieldAutoSize.LEFT;
        caption1.defaultTextFormat = new TextFormat(null, 20);
        caption1.x = 95;
        caption1.y = 420;
        caption1.text = "click or press enter key to start!";
        
        stage.addEventListener(MouseEvent.CLICK, mouseClick);
        stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDown);
    }
    
    private function mouseClick(event:MouseEvent):void
    {
        finish();
    }
    
    private function keyDown(event:KeyboardEvent):void
    {
        if (event.keyCode == Keyboard.ENTER) {
            finish();
        }
    }
    
    private function finish():void
    {
        exit();
    }
    
    override public function exit():void
    {
        stage.removeEventListener(MouseEvent.CLICK, mouseClick);
        stage.removeEventListener(KeyboardEvent.KEY_DOWN, keyDown);
        
        super._next = new QandAScene(qaList);
        
        dispatchEvent(new Event(Event.COMPLETE));
    }
}

import flash.display.Sprite;
import flash.events.KeyboardEvent;
import flash.events.MouseEvent;
import flash.events.TimerEvent;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFormat;
import flash.ui.Keyboard;
import flash.events.Event;
import flash.utils.Timer;
class QandAScene extends GameScene 
{
    private var questionField:QandAField;
    private var correctMark:CircleMark;
    private var incorrectMark:CrossMark;
    private var state:String;
    private var count:int = 0;
    private var currentIndex:int;
    private var timer:Timer;
    private var order:Vector.<int>;    //出題番号
    
    public function QandAScene(qaList:QandAList)
    {
        super(qaList);
    }
    
    override public function start():void
    {
        setField();
        stage.addEventListener(KeyboardEvent.KEY_DOWN, keydown);
        stage.addEventListener(MouseEvent.CLICK, mouseClick);
        
        timer = new Timer(1600, 1);
        timer.addEventListener(TimerEvent.TIMER_COMPLETE, timeComplete);
        
        update();
    }
    
    override public function exit():void
    {
        stage.removeEventListener(KeyboardEvent.KEY_DOWN, keydown);
        stage.removeEventListener(MouseEvent.CLICK, mouseClick);
        
        super._next = new ResultScene(qaList);
        
        dispatchEvent(new Event(Event.COMPLETE));
    }
    
    public function setField():void
    {
        questionField = new QandAField(); 
        addChild(questionField);
        questionField.x = 100;
        questionField.y = 150;
        questionField.setField(100, 80, 68, 100, 60, 40);
        
        correctMark = new CircleMark(0xFF6644, 100, 20);
        addChild(correctMark);
        correctMark.x = 200;
        correctMark.y = 180;
        correctMark.visible = false;
        
        incorrectMark = new CrossMark(0x444FF, 160, 20);
        addChild(incorrectMark);
        incorrectMark.x = 200;
        incorrectMark.y = 180;
        incorrectMark.visible = false;
        
        //出題順
        var i:int;
        order = new Vector.<int>();
        var len:int = qaList.length;
        for (i = 0; i < len; i++){
            order[i] = i;
        }
        shuffle(order);
    }
    
    private function update():void
    {
        state = "play";
        correctMark.visible = false;
        incorrectMark.visible = false;
        
        currentIndex = order[count];
        var qStr:String = qaList.askQuestion(currentIndex, 0);
        drawQuestion(qStr);
    }
    
    private function shuffle(vec:Vector.<int>):void
    {
        var i:int;
        var len:int = vec.length;
        for(i = 0;i < len;i++){
            var n:int = Math.floor(Math.random() * len);
            var temp:int = vec[n];
            vec[n] = vec[i];
            vec[i] = temp;
        }
    }
    
    private function drawQuestion(qStr:String):void
    {
        questionField.setText(qStr);
    }
    
    private function mouseClick(event:MouseEvent):void
    {
        questionField.setFocus();
    }
    
    private function keydown(event:KeyboardEvent):void
    {
        if (event.keyCode == Keyboard.ENTER) {
            pressEnterKey();
        }
    }
    
    private function pressEnterKey():void
    {
        if (state == "play") {
            state = "check";
            checkAnswer();
        }
    }
    
    private function checkAnswer():void
    {
        //回答欄のtextをチェック
        var answerStr:String = questionField.getAnswer();
        var bool:Boolean = qaList.match(currentIndex, answerStr);
        drawResult(bool);
    }
    
    private function drawResult(bl:Boolean):void
    {
        if (bl) {
            drawCorrectMark();
        }else {
            questionField.correctAnswer(qaList.getValues(currentIndex).join(", "));
            drawIncorrectMark();
        }
        
        //回答の正解・不正解を表示してしばらく時間を置く
        timer.start();
    }
    
    private function timeComplete(event:TimerEvent):void
    {
        state = "play";
        finish();
    }
    
    private function finish():void
    {
        count++;
        if (count >= qaList.length) {
            exit();
        }else{
            update();
        }
    }
    
    private function drawCorrectMark():void
    {
        correctMark.visible = true;
    }
    
    private function drawIncorrectMark():void
    {
        incorrectMark.visible = true;
    }
}
import flash.display.Sprite;
class CircleMark extends Sprite
{
    public function CircleMark(color:uint, r:int, w:int)
    {
        with (this) {
            graphics.clear();
            //graphics.beginFill(color);
            graphics.lineStyle(w, color, .6);
            graphics.drawCircle(0, 0, r);
        }
    }
    
}
import flash.display.Sprite;
class CrossMark extends Sprite
{
    public function CrossMark(color:uint, size:int, w:int)
    {
        with (this) {
            graphics.clear();
            graphics.lineStyle(w, color,.4);
            graphics.moveTo(-size/2, -size/2 * .9);
            graphics.lineTo(size/2, size/2 * .9);
            graphics.moveTo(-size/2, size/2 * .9);
            graphics.lineTo(size / 2, -size / 2 * .9);
        }
    }
}

import flash.text.TextField;
import flash.text.TextFormat;
import flash.events.Event;
import flash.ui.Keyboard;
import flash.events.KeyboardEvent;
import flash.events.MouseEvent;
import flash.text.TextFieldAutoSize;
class ResultScene extends GameScene 
{
    public function ResultScene(qalist:QandAList)
    {
        super(qalist);
    }
    
    override public function start():void
    {
        with (this) {
            graphics.clear();
            graphics.beginFill(0xF0FFF0);
            graphics.drawRect(0,0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
        }
        
        var headerText:TextField = new TextField();
        addChild(headerText);
        headerText.autoSize = TextFieldAutoSize.LEFT;
        headerText.defaultTextFormat = new TextFormat(null, 24);
        headerText.x = 25;
        headerText.y = 10;
        headerText.text = "結果  " + qaList.correctCount.toString() + " / " + qaList.length.toString();
        
        var alphabetTable:AlphabetTable = new AlphabetTable();
        alphabetTable.draw(qaList, 1);
        alphabetTable.x = 20;
        alphabetTable.y = 50;
        addChild(alphabetTable);
        
        var caption:TextField = new TextField();
        addChild(caption);
        caption.autoSize = TextFieldAutoSize.LEFT;
        caption.defaultTextFormat = new TextFormat(null, 20);
        caption.x = 95;
        caption.y = 400;
        caption.text = "click or press enter key to retry!";
        
        stage.focus = stage;
        stage.addEventListener(MouseEvent.CLICK, mouseClick);
        stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDown);
    }
    
    override public function exit():void
    {
        stage.removeEventListener(MouseEvent.CLICK, mouseClick);
        stage.removeEventListener(KeyboardEvent.KEY_DOWN, keyDown);
        
        super._next = new TitleScene(qaList);
        
        dispatchEvent(new Event(Event.COMPLETE));
    }
    
    private function mouseClick(event:MouseEvent):void
    {
        finish();
    }
    
    private function keyDown(event:KeyboardEvent):void
    {
        if (event.keyCode == Keyboard.ENTER) {
            finish();
        }
    }
    
    private function finish():void
    {
        exit();
    }
}

import flash.display.Shape;
import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.TextFieldAutoSize;
import flash.text.TextFieldType;
import flash.events.Event;
class QandAField extends Sprite 
{
    private var questionText:TextField;
    private var answerText:TextField;
    private var correctText:TextField;
    
    public function QandAField()
    {
    }
    
    public function setField(qWidth:int, qHeight:int, qFontSize:int,
                             aWidth:int, aHeight:int, aFontSize:int):void
    {
        questionText = new TextField();
        addChild(questionText);
        questionText.width = qWidth;
        questionText.height = qHeight;
        questionText.defaultTextFormat = new TextFormat(null, qFontSize);
        
        var answerLeft:int = qWidth;
        
        answerText = new TextField();
        addChild(answerText);
        answerText.x = answerLeft;
        answerText.y = qHeight - aHeight;
        answerText.autoSize = TextFieldAutoSize.LEFT;
        answerText.defaultTextFormat = new TextFormat(null, aFontSize);
        answerText.type = TextFieldType.INPUT;
        
        correctText = new TextField();
        addChild(correctText);
        correctText.x = answerLeft + aWidth;
        correctText.y = qHeight - aHeight;
        correctText.autoSize = TextFieldAutoSize.LEFT;
        correctText.defaultTextFormat = new TextFormat(null, aFontSize * 1.2, 0xFF4444);
        
        var gLine:Shape = new Shape();
        addChild(gLine);
        with (gLine) {
            graphics.clear();
            graphics.lineStyle(1, 0x000000);
            graphics.moveTo(answerLeft, qHeight - aHeight + aFontSize * 1.2);
            graphics.lineTo(answerLeft + aWidth, qHeight - aHeight + aFontSize * 1.2);
        }
    }
    
    public function setText(str:String):void
    {
        questionText.text = str;
        answerText.text = "";
        correctText.text = "";
        stage.focus = answerText;
    }
    
    public function getAnswer():String
    {
        return answerText.text;
    }
    
    //不正解の場合、正答を表示するようにする
    public function correctAnswer(str:String):void
    {
        correctText.text = str;
    }
    
    public function setFocus():void
    {
        stage.focus = answerText;
    }
}

import flash.display.Shader;
import flash.display.Shape;
import flash.display.Sprite;
import flash.text.engine.SpaceJustifier;
import flash.text.TextField;
import flash.text.TextFormat;
class AlphabetTable extends Sprite 
{
    public function AlphabetTable(){}
    
    public function draw(qaList:QandAList, mode:int):void
    {
        //mode 0: 通常表示
        //mode 1: 回答が不正解のものは赤く表示する
            
        var cellWidth:int = 130;
        var cellHeight:int = 28;
        var keyFontSize:int = 24;
        var valueFontSize:int = 16;
        var keyColor:uint = 0x000000;
        var valueColor:uint = 0x000000;
        var padding:int = 10;
        
        //alphabetを並べる
        var n:int = 0;
        var i:int;
        var j:int;
        var len:int = qaList.length;
        var columnCount:int = 3;
        var rowCount:int = Math.ceil(len / columnCount);
        loop:for (i = 0; i < columnCount; i++) {
            for (j = 0; j < rowCount; j++) {
                if(mode == 1){
                    if (qaList.checkCorrect(n)) {
                        valueColor = 0x000000;
                    }else {
                        valueColor = 0xFF4444;
                    }
                }
                var cell:AlphabetCell = new AlphabetCell(qaList.getKeys(n), qaList.getValues(n),
                                                         cellWidth, cellHeight,
                                                         5, 15,
                                                         keyFontSize, valueFontSize,
                                                         keyColor, valueColor,
                                                         " ", ", ");
                cell.x = i * (cellWidth + padding);
                cell.y = j * cellHeight;
                addChild(cell);
                n++;
                if (n >= len) break loop;
            }
        }
        
        //枠線を描画
        drawFrameLine(cellWidth + padding, cellHeight, columnCount, rowCount);
    }
    
    private function drawFrameLine(cellWidth:int, cellHeight:int, columnCount:int, rowCount:int):void
    {
        var i:int;
        var j:int;
        
        var frameLine:Shape = new Shape();
        addChild(frameLine);
        frameLine.graphics.clear();
        frameLine.graphics.lineStyle(1, 0x000000);
        
        //縦のライン
        for (i = 0; i <= columnCount; i++) {
            with (frameLine) {
                graphics.moveTo(i * cellWidth, 0);
                graphics.lineTo(i * cellWidth, cellHeight * rowCount);
            }
        }
        //横のライン
        for (i = 0; i <= rowCount; i++) {
            with (frameLine) {
                graphics.moveTo(0, i * cellHeight);
                graphics.lineTo(cellWidth * columnCount, i * cellHeight);
            }
        }
    }
}

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.TextFieldAutoSize;
class AlphabetCell extends Sprite 
{
    private var keyText:TextField;
    private var valueText:TextField;
    
    public function AlphabetCell(keys:Vector.<String>, values:Vector.<String>, 
                                 w:int, h:int, 
                                 keyLeftMargin:int, valueLeftMargin:int,
                                 keyFontSize:int, valueFontSize:int,
                                 keyColor:uint, valueColor:uint,
                                 keySeparator:String, valueSeparator:String)
    {
        keyText = new TextField();
        addChild(keyText);
        keyText.x = keyLeftMargin;
        keyText.autoSize = TextFieldAutoSize.LEFT;
        keyText.defaultTextFormat = new TextFormat(null, keyFontSize, keyColor);
        keyText.text = keys.join(keySeparator);
        
        var padding:int = 2;
        
        valueText = new TextField();
        addChild(valueText);
        valueText.x = w * .5;
        valueText.y = (keyFontSize - valueFontSize) - padding;
        valueText.autoSize = TextFieldAutoSize.LEFT;
        valueText.defaultTextFormat = new TextFormat(null, valueFontSize, valueColor);
        valueText.text = values.join(valueSeparator);
    }
}