/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iPrr
 */

package {
	import flash.display.BitmapData;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.display.TriangleCulling;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix3D;
	import flash.geom.PerspectiveProjection;
	import flash.geom.Point;
	import flash.geom.Utils3D;
	import flash.geom.Vector3D;
	
	import net.hires.debug.Stats;
	[SWF (width = 465, height = 465, frameRate = 60, backgroundColor = 0x000000)]
	public class test10 extends Sprite {
		private var _viewport:Shape;
		private var _vertices:Vector.<Number>;
		private var _uvtData:Vector.<Number>;
		private var _worldMatrix:Matrix3D;
		private var _viewMatrix:Matrix3D;
		private var _projection:PerspectiveProjection;
		
		public function test10() {
			stage.addChild(new Stats());
			
			_viewport = new Shape();
			_viewport.x = stage.stageWidth * 0.5;
			_viewport.x = stage.stageHeight * 0.5;
			addChild(_viewport);
			
			createMesh();
			
			_worldMatrix = new Matrix3D();
			_viewMatrix = new Matrix3D();
			_viewMatrix.appendTranslation(0, 0, 150);
			_projection = new PerspectiveProjection();
			_projection.fieldOfView = 60;
			
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN, function(e:Event):void {
				_oldMousePos = new Point(mouseX, mouseY);
			});
			stage.addEventListener(MouseEvent.MOUSE_MOVE, function(e:Event):void {
				if (_oldMousePos != null) {
					_viewMatrix.appendTranslation(mouseX - _oldMousePos.x, mouseY - _oldMousePos.y, 0);
					_oldMousePos.x = mouseX;
					_oldMousePos.y = mouseY;
				}
			});
			stage.addEventListener(MouseEvent.MOUSE_UP, function(e:Event):void {
				_oldMousePos = null;
			});
		}
		private var _oldMousePos:Point;
		
		private function createMesh():void
		{
			_vertices = new Vector.<Number>;
			_uvtData = new Vector.<Number>;
			
			for (var i:int = 0; i < 100; i++) {
				_vertices.push(Math.random() * 100 - 50);
				_vertices.push(Math.random() * 100 - 50);
				_vertices.push(Math.random() * 100 - 50);
				_vertices.push(Math.random() * 100 - 50);
				_vertices.push(Math.random() * 100 - 50);
				_vertices.push(Math.random() * 100 - 50);
				_vertices.push(Math.random() * 100 - 50);
				_vertices.push(Math.random() * 100 - 50);
				_vertices.push(Math.random() * 100 - 50);
				_uvtData.push(0, 0, 0);
				_uvtData.push(0, 1, 0);
				_uvtData.push(1, 0, 0);
			}
		}
		
		private function enterFrameHandler(e:Event):void 
		{
			update();
			render();
		}
		
		private function render():void
		{
			var m:Matrix3D = new Matrix3D();
			m.append(_worldMatrix);
			m.append(_viewMatrix);
			m.append(_projection.toMatrix3D());
			
			var projected:Vector.<Number> = new Vector.<Number>;
			Utils3D.projectVectors(m, _vertices, projected, _uvtData);
			
			var texture:BitmapData = new BitmapData(100, 100, false, 0x00FF00);
			texture.perlinNoise(5, 5, 3, 0, true, true);
			
			_viewport.graphics.clear();
			_viewport.graphics.lineStyle( -1, 0xFFFFFF);
			//_viewport.graphics.beginFill(0x8080ff, 0.2);
			_viewport.graphics.beginBitmapFill(texture, null, false, true);
			_viewport.graphics.drawTriangles(projected, null, _uvtData, TriangleCulling.POSITIVE);
			_viewport.graphics.endFill();
		}
		
		private function update():void
		{
			_worldMatrix.appendRotation(1, Vector3D.Y_AXIS);
		}
	}
}	