/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iPo1
 */

// forked from mash's forked from: union 接続テスト
// recompiled to use reactor Alpha6 !
// forked from keno42's union 接続テスト
package {
    import net.user1.reactor.*;
    import flash.display.Sprite;
    import flash.text.*;
    import flash.utils.*;
    
    public class FlashTest extends Sprite {
        
        private var tf:TextField = new TextField();
        private var tf2:TextField = new TextField();
        private var server:String = "tryunion.com";
        private var port:int = 9100;
        private var reactor:Reactor = new Reactor();
        
        private var testRoom:Room;

        //private var incomingMessages:TextField;

        private var sent:Number = 0;

        private var count:int = 0;
        private var peek:int = 100;
        private var fast:int = 5000;
        
        private var vec : Vector.< int > = new Vector.< int >();
        private var vecCnt:int = 0;
        private var ave:Number = 0;//平均値
        //エントリ
        public function FlashTest() {
            //接続完了
            reactor.addEventListener(ReactorEvent.READY, onReady);
            //プロトコル
            reactor.addEventListener(ReactorEvent.PROTOCOL_INCOMPATIBLE, onProtocolIncompatible);
            //切断
            reactor.addEventListener(ReactorEvent.CLOSE, onClose);
            reactor.connect(server,port);//接続
            
            addChild(tf);
            tf.autoSize = "left";
            tf.appendText(server+":"+port+" に接続中です...\n");
            with(tf2){
                border =true;
                y = 40;
                type ="input";
                
            }
            addChild(tf2);

        }
        
        private function onReady(e:ReactorEvent):void{
            tf.appendText("接続完了しました\n");
            
            //ルーム作成
            testRoom = reactor.getRoomManager().createRoom("funnelTestRoom");
            //メッセージリスナー登録
            testRoom.addMessageListener("t", testMessageListener);
            //ルーム入室
            testRoom.join();
            //ping送信
            //sendPingMessage();
            //送信日時更新
            sent = getTimer();
        }
        private function onClose(e:ReactorEvent):void{
            tf.appendText("切断されました\n");
        }
        private function onProtocolIncompatible(e:ReactorEvent):void{
            tf.appendText("プロトコルが不適合です(サーバーUPCバージョン:"+e.getServerUPCVersion()+", クライアントUPCバージョン:"+reactor.getSystem().getUPCVersion()+")\n");
        }
        
        
        private function pingLog(time:int):void{
            vec[vecCnt] = time;
            vecCnt++;
            vecCnt%=100;
            if(vecCnt==0){
                var total:int = 0;
                for(var i:int=0;i<100;i++){
                    total+=vec[i];
                }
                ave = (total/100);

            }

        }

        
        private function testMessageListener(fromClient:IClient):void {
            var now:Number = getTimer();
            var pingTime:int = (now-sent);
            pingLog(pingTime);
            //tf.appendText("ping (" + count + "): " + (now - sent) + "ms\n");
            tf.text = "ping:"+pingTime+"ms";
            tf.appendText("\n"+fast+"～"+peek +" "+ave);
            count++;
            sendPingMessage();
            //if (count < 10) sendPingMessage();//ping送信
            
            sent = now;//送信日時
            if(pingTime<fast)fast = pingTime;
            else if(peek < pingTime)peek = pingTime;
        }
        
        //pingメッセージ
        private function sendPingMessage():void {
            testRoom.sendMessage("t", true, null);
        }
    }
}