/**
 * Copyright makc3d ( http://wonderfl.net/user/makc3d )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iP0T
 */

// forked from makc3d's BeatPort player
package {
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	/**
	 * Audiotool Player.
	 * Hack warning: could not find any xml/rss feed :(
	 * Also, it shuts up for some reason, if you skip alot...
	 */
	public class Audiotool extends Sprite {
		private var player:AudioToolPlayer
		public function Audiotool () {
			AudioToolPlayer (player = new AudioToolPlayer).play ("dubstep");
			stage.addEventListener (MouseEvent.CLICK, nextTrack);
		}
		private function nextTrack (e:MouseEvent):void {
			player.next ();
		}
	}
}

import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.media.SoundLoaderContext;
import flash.net.URLLoader;
import flash.net.URLLoaderDataFormat;
import flash.net.URLRequest;

class AudioToolPlayer {
	private var query:String;

	public function next ():void {
		if (channel) {
			channel.stop ();
			playNextTrack (new Event ("whatever"))
		}
	}

	/**
	 * Plays audiotool tracks in listing order.
	 */
	public function play (queryString:String):void {
		query = queryString; loadNextPage ();
	}
	
	protected function loadNextPage ():void {
		page++;
		var loader:URLLoader = new URLLoader;
		loader.dataFormat = URLLoaderDataFormat.TEXT;
		subscribeLoader (loader, getTracksInPage, onIOFailure1);
		loader.load (new URLRequest (makeUrl (query, page)));
	}
	

	private function makeUrl (query:String, page:int):String {
		return "http://burn-studios.audiotool.com/browse/popular/?p=" + page + "&s=" + encodeURIComponent (query);
	}

	private var page:int = -1, tracks:Array = [], sound:Sound, channel:SoundChannel;
	private var context:SoundLoaderContext = new SoundLoaderContext (10, true);

	private function getTracksInPage (e:Event):void {
		var loader:URLLoader = URLLoader (e.target);
		unsubscribeLoader (loader, getTracksInPage, onIOFailure1);

		var result:String = String (loader.data);
		// we are looking for strings like
		// mp3:"http://api.audiotool.com/play/dubstep_gamer/s3.mp3",
		var mp3re:RegExp = /"[^"]+mp3"/g;
		tracks = result.match (mp3re);

		if (tracks.length < 1) {
			// loop
			page = -1; loadNextPage ();
		} else {
			playNextTrack ();
		}
	}

	private function playNextTrack (e:Event = null):void {
		if (e != null) {
			unsubscribeSoundStuff (); channel = null;
		}

		if (tracks.length < 1) {
			loadNextPage ();
			return;
		}

		var url:String = tracks.pop ();
		url = url.substr (1, url.length - 2);

		trace ("playing:", url, "tracks left in page:", tracks.length, "page:", page);

		channel = Sound (sound = new Sound (
			new URLRequest (url), context
		)).play ();

		subscribeSoundStuff ();
	}

	private function subscribeLoader (loader:URLLoader, onComplete:Function, onIOFailure:Function):void {
		loader.addEventListener (Event.COMPLETE, onComplete);
		loader.addEventListener (IOErrorEvent.IO_ERROR, onIOFailure);
	}

	private function unsubscribeLoader (loader:URLLoader, onComplete:Function, onIOFailure:Function):void {
		loader.removeEventListener (Event.COMPLETE, onComplete);
		loader.removeEventListener (IOErrorEvent.IO_ERROR, onIOFailure);
	}

	private function subscribeSoundStuff ():void {
		sound.addEventListener (IOErrorEvent.IO_ERROR, onIOFailure3);
		channel.addEventListener (Event.SOUND_COMPLETE, playNextTrack);
	}

	private function unsubscribeSoundStuff ():void {
		sound.removeEventListener (IOErrorEvent.IO_ERROR, onIOFailure3);
		channel.removeEventListener (Event.SOUND_COMPLETE, playNextTrack);
	}

	private function onIOFailure1 (e:IOErrorEvent):void {
		unsubscribeLoader (URLLoader (e.target), getTracksInPage, onIOFailure1);
		page--; play (query);
	}

	private function onIOFailure3 (e:IOErrorEvent):void {
		// assumes sound's ioError comes before channel's soundComplete
		unsubscribeSoundStuff ();
		playNextTrack ();
	}
}