/**
 * Copyright inippo ( http://wonderfl.net/user/inippo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iOQW
 */

/*
カメラを繰り返し描画して動いた箇所（差分のある箇所）を描画します。
ちょっとチカチカするあたりが不完全。。。
*/
package{
    
        import flash.display.*;
        import flash.events.*;
        import flash.geom.*;
        import flash.media.*;
        import flash.system.*;
        import flash.text.*;
        import flash.utils.*;
        
        public class PhysicalBitmap extends MovieClip{
        public var camera:Camera;        
        public var video:Video;        
        public var copyBmd:BitmapData;        
        public var canvasBmd:BitmapData;
        public var canvas:Bitmap;
        
        public var prevAry:Array = [];
        
        public const DIFF_NUM:Number = 1000000; // 差分のしきい値
        public const CANVAS_COLOR:uint = 0xFFFFFF; // キャンバスの色
        
        
        public function PhysicalBitmap(){
            
            // カメラを検出
            camera = Camera.getCamera();
            if (camera != null){
                if (camera.muted) {
                    // 許可されない
                    trace("許可されない");
                    Security.showSettings(SecurityPanel.PRIVACY);
                    camera.addEventListener(StatusEvent.STATUS, statusHandler);
                }else {
                    // 許可
                    trace("許可");
                    connectCamera();
                }
            }
        }
        
        public function statusHandler(event:StatusEvent):void{
            if(event.code == "Camera.Unmuted"){
                connectCamera();
                camera.removeEventListener(StatusEvent.STATUS, statusHandler);
            }
        }
        
        
        /**
         * 描画の準備
         */
        public function connectCamera():void {
            
            // ビデオの生成（カメラの映像を投影する）
            video = new Video();
            video.attachCamera(camera);
            
            // 映像を複製するビットマップデータを作成
            copyBmd = new BitmapData (video.width, video.height);
            
            // 表示用のキャンバスを作成
            canvasBmd = new BitmapData (video.width, video.height);
            canvas = new Bitmap(canvasBmd);
            canvas.x = stage.stageWidth/2 - video.width/2;
            canvas.y = stage.stageHeight / 2 - video.height / 2;
            
            addChild(canvas);
            
            
            /*
             ここから初回の描画
            */
            copyBmd.lock();
            copyBmd.draw (video);
            
            // 1ピクセルずつ描画
            for (var xx:int; xx < video.width; xx++)
            {
                for (var yy:int; yy < video.height; yy++)
                {
                    var col:uint = copyBmd.getPixel(xx, yy);
                    prevAry.push(col);
                }
                
                yy = 0;
                
            }
            
            copyBmd.unlock();
            
            // タイマーで描画の繰り返し
            var timer:Timer = new Timer(33);
            timer.addEventListener(TimerEvent.TIMER, loop);
            timer.start();
            
        }
        
        
        /**
         * カメラの映像を繰り返しビダミービットマップに描画する。
         * 差分だけをさらに検出して描画。
         */
        public function loop(event:TimerEvent):void{
            
            var i:int;
            
            copyBmd.lock();
            canvasBmd.lock();
            
            // ビデオの映像を描画する
            copyBmd.draw(video);
            canvasBmd.draw(video);
            
            // 1ピクセルずつ描画
            for (var xx:int; xx < video.width; xx++)
            {
                for (var yy:int; yy < video.height; yy++)
                {
                    var col:uint = copyBmd.getPixel(xx, yy);
                    
                    /*
                     差分がしきい値を超えていない場合は白で塗る。
                     差分を塗っても良いけどこっちのほうが処理軽いと思います
                    */
                    if (Math.abs(prevAry[i] - col) < DIFF_NUM)
                    {
                        //bitmapData2.setPixel(xx, yy, col);
                        //prevAry[i] = col;
                        canvasBmd.setPixel(xx, yy, CANVAS_COLOR);
                    }
                    
                    prevAry[i] = col;
                    i++;
                    
                }
                
                yy = 0;
                
            }
            
            copyBmd.unlock();
            canvasBmd.unlock();
            
        }


    }
}
