/**
 * Copyright telcanty ( http://wonderfl.net/user/telcanty )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iOQG
 */

package {
    
    import flash.display.Sprite;
    import flash.events.Event;
    
    public class FlashTest extends Sprite {
        
        private var _ball:Sprite;
        private var _speed:Number = 10;
        
        private var _vx:Number;
        private var _vy:Number;
        
        public function FlashTest() {
             // Create Ball   
           _ball = new Sprite();
           // Position Ball in the center of the screen
           _ball.x = stage.stageWidth/2;
           _ball.y = stage.stageHeight/2;
            // Set our starting velocities
            _vx = Math.random() * _speed;
            _vy = Math.random() * _speed;
           // Draw the Ball
           _drawBall(0x000000);
           // Add the ball to the stage so it can be rendered
           addChild(_ball);
           // Add an enter frame event listener to the stage so we can run updates
           addEventListener(Event.ENTER_FRAME, _update);
        }
        
        private function _drawBall(color:uint):void
        {
            // Make a random size for fun
            var size:Number = Math.random() * 30 + 10;
            // Use the drawing API to draw a circle of the color set in parameter
            _ball.graphics.clear();
             _ball.graphics.beginFill(color);
             _ball.graphics.drawCircle(0,0,size);
            _ball.graphics.endFill();
        }
               
        private function _update(e:Event):void{
            // increment our ball speed
            _ball.x += _vx;
            _ball.y += _vy;
            // check to see if the ball went past our right border
            if(_ball.x > stage.stageWidth)
            {
                // reverse our x velocity
                _vx *= -1;
                // change color so we can see it hit
                _drawBall(0x0000FF);
           }else if(_ball.x < 0)    // check to see if ball went past our left border
           {
                // reverse our x velocity
                _vx *= -1;
                // change color so we can see it hit
                _drawBall(0x00FF00);
           }
           
           // check to see if the ball went past our bottom border
           if(_ball.y > stage.stageHeight)
           {
               //reverse our y velocity
               _vy *= -1;
               // change color so we can see it hit
                _drawBall(0xFF0000);
           }else if(_ball.y < 0)  // check to see if the ball went past our top border
           {
                //reverse our y velocity
               _vy *= -1;
                // change color so we can see it hit
                _drawBall(0x770077);
           }
           
        }
        
    }
}