/**
 * Copyright geko ( http://wonderfl.net/user/geko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iNBl
 */

package {
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.events.Event;
    
    
    public class Clock extends Sprite {
        private var hour_hand:Hand = new Hand(60);
        private var min_hand:Hand = new Hand(90);
        private var sec_hand:Hand = new Hand(100, 1, 0x999999)
        
        public function Clock() {
            var face:DisplayObject;
            for(var i:int = 1; i <= 24; i++){
                face = addChild(new ClockFace(i, 15, 0x333333));
                face.x = stage.stageWidth/2+Math.cos(Math.PI*2/24*i-Math.PI/2)*100;                
                face.y = stage.stageHeight/2+Math.sin(Math.PI*2/24*i-Math.PI/2)*100;
                face.rotation = Math.PI*2/24*i*180/Math.PI;
            }
            for(i = 5; i <= 60; i+=5){
                face = addChild(new ClockFace(i, 10, 0x888888));
                face.x = stage.stageWidth/2+Math.cos(Math.PI*2/60*i-Math.PI/2)*85;                
                face.y = stage.stageHeight/2+Math.sin(Math.PI*2/60*i-Math.PI/2)*85;
                face.rotation = Math.PI*2/60*i*180/Math.PI;
            }
            addChild(hour_hand);
            addChild(sec_hand);
            addChild(min_hand);
            
            hour_hand.x = sec_hand.x = min_hand.x = stage.stageWidth/2;
            hour_hand.y = sec_hand.y = min_hand.y = stage.stageHeight/2;
            
            stage.addEventListener(Event.ENTER_FRAME, update);
        }
        
        public function update(event:Event):void{
            var date:Date = new Date();
            sec_hand.rotation = (Math.PI*2/60*date.seconds-Math.PI/2)*180/Math.PI;
            min_hand.rotation = (Math.PI*2/60*date.minutes-Math.PI/2)*180/Math.PI+(Math.PI*2/60*date.seconds-Math.PI/2)*180/Math.PI/60;
            hour_hand.rotation = (Math.PI*2/24*date.hours-Math.PI/2)*180/Math.PI+((Math.PI*2/60*date.minutes-Math.PI/2)*180/Math.PI+(Math.PI*2/60*date.seconds-Math.PI/2)*180/Math.PI/60)/24;
        }
    }
}


import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFormat;

//
class ClockFace extends Sprite{
    private var font:String = "Vrinda"//"Levenim MT";
    private var txt:TextField = new TextField();
    private var bmp:Bitmap = new Bitmap();
    
    public function ClockFace(number:uint, size:Number = 12, color:uint = 0x0, bold:Boolean = false):void{
        txt.defaultTextFormat = new TextFormat(font, size, color, bold, null, null, null, null, "center");
        txt.text = number.toString();
        txt.width = txt.textWidth+5;
        addChild(bmp);
        bmp.bitmapData = new BitmapData(txt.textWidth+5, txt.textHeight, true, 0x0);
        bmp.bitmapData.draw(txt);
        bmp.x = -bmp.width/2;
        bmp.y = -bmp.height/2;
    }
}


//
class Hand extends Sprite{
    public function Hand(width:Number, height:Number = 5, color:uint = 0x0):void{
        graphics.beginFill(color, 0.8);
        graphics.drawRoundRect(-10, -height/2, width+10, height, height/2);
        graphics.endFill();
    }
}