/**
 * Copyright nonkasvas ( http://wonderfl.net/user/nonkasvas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iMrg
 */

// forked from nonkasvas's 編集中mouseOver
// forked from yaneura9's forked from: [PV3D] Field of Blur
// forked from clockmaker's [PV3D] Field of Blur
/**
* Papervision3Dで被写界深度
* 参照： http://clockmaker.jp/blog/2008/07/pv3d_gw_blur/
*/
package
{
	import flash.display.*;
	import flash.events.*;
	import flash.filters.*;
	
	import org.papervision3d.view.*;
	import org.papervision3d.materials.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.objects.primitives.*
	
        [SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "#000000")]
	
	public class Main extends BasicView 
	{	
		// const vars
		static private const OBJ_LENGTH   :int = 10;
		static private const CIRCLE_RANGE :int = 350;
		
		// 3d vars
		private var list :Array = []
		private var wrap :DisplayObject3D;
		private var isMouseDown:Boolean = false;
		private var oldX:Number = 0 ;
		private var targetRot:Number = 0 ;
		/**
		 * Constructor
		 */
		 


		
		
		public function Main()
		{
			//camera
			camera.x         = 0;
			camera.y         = 80;
			camera.z         = 600;
			camera.rotationX = 5
			
			// wrap
			wrap = new DisplayObject3D();
			scene.addChild(wrap);
			
			for (var i:int = 0; i < OBJ_LENGTH; i++)
			{
				var rot:Number = 360 * i / OBJ_LENGTH ;
				
				var m:ColorMaterial = new ColorMaterial(0xffffff);
				m.doubleSided = true;
				
				var o:Plane = new Plane(m, 100, 100);
				o.x = CIRCLE_RANGE * Math.sin(rot * Math.PI / 180);
				o.y = 0;
				o.z = CIRCLE_RANGE * Math.cos(rot * Math.PI / 180);
				o.rotationY = rot;
				o.useOwnContainer = true; //ココ重要
				
                                // 配列に追加　＆　wrapの子供にする
				list.push(wrap.addChild(o));
			}
			
			addEventListener(Event.ENTER_FRAME, loop);
			addEventListener(MouseEvent.MOUSE_DOWN, downHandler)
			addEventListener(MouseEvent.MOUSE_UP, upHandler)
			addEventListener(MouseEvent.MOUSE_MOVE, moveHandler)
			startRendering(); 
		}
		
		private function downHandler(event:Event):void{
			isMouseDown = true;
		    oldX = mouseX
			}
		private function upHandler(event:Event):void{
			isMouseDown = false;
			}
		private function moveHandler(event:Event):void{
			if(isMouseDown){
		        var oldX:Number = 0 ;
		        var dy:Number = x - oldX;
		        targetRot += dy * 0.25;
	 	        oldX = x;
	    		}
		}
		
            
		
		
		
		private function loop(event:Event):void
		{
			
			var targetRot:Number = ( mouseX / stage.stageWidth ) * 360
			var rot:Number = 0 ;
			wrap.rotationY -=0.3;
			rot += (targetRot - rot) * 0.05;
			if(isMouseDown &&  targetRot<230){
				wrap.rotationY ++}
				else if(isMouseDown && targetRot<230){
					wrap.rotationY --}
			
			
			
			
                        
                        // 被写界深度
			for (var i:int = 0; i < list.length; i++)
			{
				var o:DisplayObject3D = list[i] as DisplayObject3D;
				var blur:Number = Math.ceil((CIRCLE_RANGE - o.sceneZ) / 100); 
				o.filters = [new BlurFilter(blur, blur, 2)];
				
			}
		}
	}
}