/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iMPr
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    
    /**
     * ...
     * @author umhr
     */
    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 30)]
    public class Main extends Sprite 
    {
        private var _mousePoint:Array/*Point*/= [];
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            _mousePoint.unshift(new Point(mouseX, mouseY));
            _mousePoint.unshift(new Point(mouseX, mouseY));
            
            this.addEventListener(Event.ENTER_FRAME, onEnter);
        }
        
        private function onEnter(e:Event):void 
        {
            var p0:Point = _mousePoint[0];
            var p1:Point = _mousePoint[1];
            
            var inertiaPoint:Point = p0.subtract(p1).add(p0);
            //inertiaPoint.x = p0.x - p1.x + p0.x;
            //inertiaPoint.y = p0.y - p1.y + p0.y;
            
            inertiaPoint.x = inertiaPoint.x*0.9 + mouseX * 0.1;
            inertiaPoint.y = inertiaPoint.y*0.9 + mouseY * 0.1;
            
            _mousePoint.unshift(inertiaPoint);
            _mousePoint.splice(100);
            draw(_mousePoint);
            
        }
        
        /**
         * 線を描画
         * @param    mousePoint
         */
        private function draw(mousePoint:Array/*Point*/):void {
            this.graphics.clear();
            this.graphics.beginFill(0x000000);
            this.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            this.graphics.endFill();
            this.graphics.lineStyle(0, 0xFFFF00);
            this.graphics.moveTo(mousePoint[0].x, mousePoint[0].y);
            var n:int = mousePoint.length;
            for (var i:int = 1; i < n; i++) {
                this.graphics.lineTo(mousePoint[i].x, mousePoint[i].y);
            }
        }
    }
    
}