/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iKK4
 */

// forked from ProjectNya's Fireworks2011 [A Happy New Year]
////////////////////////////////////////////////////////////////////////////////
// Fireworks2014 [A Happy New Year]
//
// [AS3.0] ドットの光 (8)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1097
// [PV3D] ドットひよこ
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1216
// [AS3.0] DetectPixelsクラスに挑戦！ (2)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1135
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Rectangle;
    import flash.geom.Point;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.PixelSnapping;
    import flash.display.BlendMode;
    import flash.geom.Matrix;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.view.layer.*;
    import org.papervision3d.core.geom.*;
    import org.papervision3d.core.effects.*;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var scene:Scene3D;
        private var viewport:Viewport3D;
        private var camera:Camera3D;
        private var renderer:BasicRenderEngine;
        private var sw:uint = 465;
        private var sh:uint = 465;
        private var cx:uint = 232;
        private var cy:uint = 232;
        private static var cameraHeight:Number = 300;
        private static var radius:uint = 300;
        private var effect:BitmapEffectLayer;
        private var pixels:Pixels;
        private var bitmapData:BitmapData;
        private var matrix:Matrix;
        private static var bw:uint = 465;
        private static var bh:uint = 465;
        private static var scale:Number = 16;
        private var angle:Number = 90;
        private var map:Map;
        private var loader:PhotoLoader;
        private static var basePath:String = "http://assets.wonderfl.net/images/related_images/";
        private static var mapPath:String = "d/d4/d49f/d49f6923a043860aed5d60334893f27205017d3a";
        //
        private var fireworks:Fireworks;
        private var timer:Timer;
        private var colors:Array;
        private var points:Array;
        private var count:uint = 0;

        public function Main() {
            //Wonderfl.capture_delay(4);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            scene = new Scene3D();
            viewport = new Viewport3D(0, 0, true, false);
            camera = new Camera3D();
            renderer = new BasicRenderEngine();
            setup();
            initialize();
            addChild(viewport);
            viewport.y = 100;
            addEventListener(Event.ENTER_FRAME, render, false, 0, true);
            //
            colors = new Array();
            colors.push([{h: 200, s: 0}, {h: 200, s: 0.2}]);
            colors.push([{h: 0, s: 0.2}, {h: 0, s: 0.4}]);
            colors.push([{h: 60, s: 0.2}, {h: 60, s: 0.4}]);
            colors.push([{h: 150, s: 0.2}, {h: 150, s: 0.4}]);
            //
            points = new Array();
            // 2
            points.push(new Point(24+4, 84));
            points.push(new Point(24+52, 60));
            points.push(new Point(24+100, 84));
            points.push(new Point(24+68, 124));
            points.push(new Point(24+36, 164));
            points.push(new Point(24+4, 204));
            points.push(new Point(24+52, 204));
            points.push(new Point(24+100, 204));
            // 0
            points.push(new Point(56+172, 60));
            points.push(new Point(56+140, 84));
            points.push(new Point(56+124, 132));
            points.push(new Point(56+140, 180));
            points.push(new Point(56+172, 204));
            points.push(new Point(56+212, 180));
            points.push(new Point(56+220, 132));
            points.push(new Point(56+212, 84));
            points.push(new Point(56+172, 60));
            // 1
            points.push(new Point(64+292, 60));
            points.push(new Point(64+292, 108));
            points.push(new Point(64+292, 156));
            points.push(new Point(64+292, 204));
            // 1
            points.push(new Point(24+412, 60));
            points.push(new Point(24+412, 108));
            points.push(new Point(24+412, 156));
            points.push(new Point(24+412, 204));
            //
            fireworks = new Fireworks(new Rectangle(0, 0, 465, 465));
            addChild(fireworks);
            //start();
        }
        private function setup():void {
            viewport.interactive = true;
            camera.x = 0;
            camera.y = cameraHeight;
            camera.z = - radius;
            camera.zoom = 25;
            camera.focus = 20;
            camera.target = DisplayObject3D.ZERO;
        }
        private function initialize():void {
            setEffect();
            map = new Map(pixels);
            //
            loader = new PhotoLoader();
            loader.addEventListener(Event.INIT, complete, false, 0, true);
            //loader.addEventListener(Event.COMPLETE, complete, false, 0, true);
            loader.load(basePath + mapPath, true);
        }
        private function complete(evt:Event):void {
            var bitmap:Bitmap = Bitmap(loader.content);
            map.setup(bitmap.bitmapData);
            start();
        }
        private function setEffect():void {
            effect = new BitmapEffectLayer(viewport, bw, bh);
            effect.addEffect(new BitmapColorEffect(1, 1, 1, 0.8));
            viewport.containerSprite.addLayer(effect);
            pixels = new Pixels(effect);
            scene.addChild(pixels);
            bitmapData = new BitmapData(bw/scale, bh/scale, false, 0xFF000000);
            var bitmap:Bitmap = new Bitmap(bitmapData, PixelSnapping.NEVER, true);
            bitmap.scaleX = bitmap.scaleY = scale;
            bitmap.blendMode = BlendMode.ADD;
            addChild(bitmap);
            bitmap.y = 100;
            matrix = new Matrix(1/scale, 0, 0, 1/scale, 0, 0);
        }
        private function render(evt:Event):void {
            sparkle();
            angle ++;
            camera.x = Math.cos(angle*Math.PI/180)*radius;
            camera.y = cameraHeight;
            camera.z = Math.sin(angle*Math.PI/180)*radius;
            renderer.renderScene(scene, camera, viewport);
        }
        private function sparkle():void {
            bitmapData.lock();
            bitmapData.fillRect(bitmapData.rect, 0xFF000000);
            bitmapData.draw(viewport, matrix);
            bitmapData.unlock();
        }
        //
        private function start():void {
            fireworks.addEventListener(Fireworks.COMPLETE, loop, false, 0, true);
            fireworks.launch(points[count], colors[count%colors.length]);
            startTimer();
        }
        private function startTimer():void {
            timer = new Timer(200, 1);
            timer.addEventListener(TimerEvent.TIMER_COMPLETE, launch, false, 0, true);
            timer.start();
        }
        private function launch(evt:TimerEvent):void {
            timer.removeEventListener(TimerEvent.TIMER_COMPLETE, launch);
            count ++;
            if (count < points.length) {
                fireworks.launch(points[count], colors[count%colors.length]);
                startTimer();
            }
        }
        private function loop(evt:Event):void {
            fireworks.removeEventListener(Fireworks.COMPLETE, loop);
            timer = new Timer(1000, 1);
            timer.addEventListener(TimerEvent.TIMER_COMPLETE, restart, false, 0, true);
            timer.start();
        }
        private function restart(evt:TimerEvent):void {
            evt.target.removeEventListener(TimerEvent.TIMER_COMPLETE, restart);
            count = 0;
            start();
        }

    }

}


//////////////////////////////////////////////////
// Fireworksクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.PixelSnapping;
import flash.display.BlendMode;
import flash.geom.Matrix;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.ColorTransform;
import flash.filters.BlurFilter;
import flash.events.Event;

class Fireworks extends Sprite {
    private var rect:Rectangle;
    private var bitmapData:BitmapData;
    private var sparkle:BitmapData;
    private var afterglow:BitmapData;
    private static var scale:uint = 4;
    private var matrix:Matrix;
    private var amatrix:Matrix;
    private var colorTrans:ColorTransform;
    private var blur:BlurFilter;
    private var fireworks:Array;
    private var garbage:Array;
    private var initialized:Boolean = false;
    public static const COMPLETE:String = Event.COMPLETE;

    public function Fireworks(r:Rectangle) {
        rect = r;
        init();
    }

    private function init():void {
        bitmapData = new BitmapData(rect.width, rect.height, true, 0x00000000);
        var bitmap:Bitmap = new Bitmap(bitmapData);
        addChild(bitmap);
        sparkle = new BitmapData(rect.width/scale, rect.height/scale, true, 0x00000000);
        var sBitmap:Bitmap = new Bitmap(sparkle);
        sBitmap.smoothing = true;
        sBitmap.blendMode = BlendMode.ADD;
        sBitmap.scaleX = sBitmap.scaleY = scale;
        addChild(sBitmap);
        afterglow = new BitmapData(rect.width*2/scale, rect.height*2/scale, true, 0x00000000);
        var aBitmap:Bitmap = new Bitmap(afterglow, PixelSnapping.AUTO, true);
        aBitmap.blendMode = BlendMode.ADD;
        aBitmap.scaleX = aBitmap.scaleY = scale/2;
        addChild(aBitmap);
        matrix = new Matrix(1/scale, 0, 0, 1/scale, 0, 0);
        amatrix = new Matrix(2/scale, 0, 0, 2/scale, 0, 0);
        colorTrans = new ColorTransform(0.16, 0.16, 0.16);
        blur = new BlurFilter(2, 2, 1);
        fireworks = new Array();
        garbage = new Array();
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    public function launch(targetPos:Point, color:Object):void {
        var firework:Firework = new Firework(bitmapData);
        firework.id = fireworks.length;
        firework.targetPos = targetPos;
        firework.create(color);
        firework.addEventListener(Firework.COMPLETE, complete, false, 0, true);
        fireworks.push(firework);
    }
    private function update(evt:Event):void {
        if (fireworks.length < 1) initialized = true;
        if (fireworks.length > 0) {
            bitmapData.lock();
            bitmapData.fillRect(bitmapData.rect, 0x00000000);
            if (garbage.length > 0) remove();
            for (var n:uint = 0; n < fireworks.length; n++) {
                var firework:Firework = fireworks[n];
                firework.emit();
            }
            bitmapData.unlock();
            sparkle.lock();
            sparkle.fillRect(sparkle.rect, 0x00000000);
            sparkle.draw(bitmapData, matrix);
            sparkle.unlock();
        }
        afterglow.lock();
        afterglow.draw(bitmapData, amatrix, colorTrans, BlendMode.ADD);
        afterglow.applyFilter(afterglow, afterglow.rect, new Point(), blur);
        afterglow.unlock();
        if (initialized && fireworks.length < 2) {
            fireworks = new Array();
            reset();
            dispatchEvent(new Event(Fireworks.COMPLETE));
            initialized = false;
        }
    }
    private function complete(evt:Event):void {
        var firework:Firework = Firework(evt.target);
        firework.removeEventListener(Firework.COMPLETE, complete);
        garbage.push(firework.id);
    }
    private function remove():void {
        for (var n:uint = 0; n < garbage.length; n++) {
            var id:uint = garbage[n];
            var firework:Firework = fireworks[id];
            fireworks.splice(id, 1);
            firework = null;
        }
        reset();
    }
    private function reset():void {
        for (var n:uint = 0; n < fireworks.length; n++) {
            var firework:Firework = fireworks[n];
            firework.id = n;
        }
        garbage = new Array();
    }

}


//////////////////////////////////////////////////
// Fireworkクラス
//////////////////////////////////////////////////

import flash.events.EventDispatcher;
import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.events.Event;
import frocessing.color.ColorHSV;

class Firework extends EventDispatcher {
    public var id:uint;
    private var bitmapData:BitmapData;
    private var rect:Rectangle;
    private var launcher:ParticleDot;
    private var dots:Array;
    private static var speed:Number = 10;
    private static var deceleration:Number = 0.94;
    private static var gravity:Number = 0.05;
    private var color:ColorHSV;
    private var colors:Object;
    private static var length:Number = 2;
    private var manager:Bresenham;
    public var emit:Function;
    private var se:SoundEffect;
    private static var soundPath:String = "http://www.project-nya.jp/images/flash/explosion.mp3";
    public var targetPos:Point;
    public static const COMPLETE:String = Event.COMPLETE;

    public function Firework(s:BitmapData) {
        bitmapData  = s;
        rect = bitmapData.rect;
        init();
    }

    private function init():void {
        dots = new Array();
        color = new ColorHSV(0, 1);
        manager = new Bresenham(bitmapData);
        emit = ready;
        se = new SoundEffect();
        se.load(soundPath);
    }
    private function ready():void {
    }
    public function create(option:Object):void {
        colors = option;
        launcher = new ParticleDot(targetPos.x, rect.height);
        launcher.vy = - speed*(1 + Math.random()*0.05);
        color.h = colors.h;
        color.s = colors.s;
        launcher.rgb = color.value;
        emit = launch;
    }
    private function launch():void {
        launcher.vy += gravity;
        launcher.y += (targetPos.y - launcher.y)*0.5;
        bitmapData.setPixel32(launcher.x, launcher.y, 0xFF << 24 | launcher.rgb);
        if (Math.abs(targetPos.y - launcher.y) < 0.5) {
            explode(160, new Point(launcher.x, launcher.y), launcher.rgb);
            launcher = null;
        }
    }
    private function explode(max:uint, point:Point, rgb:uint):void {
        for (var n:uint = 0; n < max; n++) {
            var energy:Number = Math.random()*5;
            var angle:Number = Math.random()*360;
            var dot:ParticleDot = new ParticleDot(point.x, point.y, energy, angle);
            dot.velocity = Math.random()*5;
            dot.vx = Math.cos(dot.angle*Math.PI/180)*dot.velocity;
            dot.vy = Math.sin(dot.angle*Math.PI/180)*dot.velocity;
            dot.px = dot.x;
            dot.py = dot.y;
            dot.rgb = rgb;
            dots.push(dot);
        }
        emit = spread;
        se.play(0.6);
    }
    private function spread():void {
        for (var n:uint = 0; n < dots.length; n++) {
            var dot:ParticleDot = dots[n];
            dot.vx *= deceleration;
            dot.vy *= deceleration;
            dot.vy += gravity;
            dot.x += dot.vx;
            dot.y += dot.vy;
            dot.energy *= deceleration;
            var x0:int = dot.x;
            var y0:int = dot.y;
            var x1:int = dot.x - (dot.x - dot.px)*length;
            var y1:int = dot.y - (dot.y - dot.py)*length;
            color.h = colors[1].h + (colors[0].h - colors[1].h)*dot.energy*0.2;
            color.s = colors[1].s + (colors[0].s - colors[1].s)*dot.energy*0.2;
            dot.rgb = color.value;
            manager.draw(x0, y0, x1, y1, dot.rgb, 1);
            dot.px = dot.x;
            dot.py = dot.y;
            if (dot.energy < 0.05) {
                dots.splice(n, 1);
                dot = null;
                if (dots.length < 1) {
                    dispatchEvent(new Event(Firework.COMPLETE));
                }
            }
        }
    }

}


//////////////////////////////////////////////////
// EmitLightクラス
//////////////////////////////////////////////////

import flash.display.BitmapData;
import flash.geom.Rectangle;
import frocessing.color.ColorHSV;

class EmitLight {
    private var canvas:BitmapData;
    private var rect:Rectangle;
    private var dots:Array;
    private static var deceleration:Number = 0.1;
    private var color:ColorHSV;

    public function EmitLight(c:BitmapData) {
        canvas  = c;
        rect = canvas.rect;
        init();
    }

    private function init():void {
        dots = new Array();
        color = new ColorHSV(0, 0.4);
    }
    public function create(max:uint):void {
        for (var n:uint = 0; n < max; n++) {
            var px:Number = Math.random()*rect.width;
            var py:Number = rect.height - Math.random()*5;
            var energy:Number = Math.random() + 0.5;
            var dot:ParticleDot = new ParticleDot(px, py, energy);
            color.h = Math.random()*360;
            dot.rgb = color.value;
            dots.push(dot);
        }
    }
    public function emit():void {
        for (var n:uint = 0; n < dots.length; n++) {
            var dot:ParticleDot = dots[n];
            dot.energy -= deceleration;
            canvas.setPixel(dot.x, dot.y, dot.rgb);
            if (dot.energy < 0) {
                dots.splice(n, 1);
                dot = null;
            }
        }
    }

}


//////////////////////////////////////////////////
// ParticleDotクラス
//////////////////////////////////////////////////

class ParticleDot {
    public var x:Number = 0;
    public var y:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var px:Number = 0;
    public var py:Number = 0;
    public var energy:Number = 1;
    public var angle:Number = 0;
    public var velocity:Number = 1;
    public var rgb:uint = 0xFFFFFF;

    public function ParticleDot(_x:Number, _y:Number, e:Number = 1, a:Number = 0):void {
        x = _x;
        y = _y;
        energy = e;
        angle = a;
    }
    
}


//////////////////////////////////////////////////
// Bresenhamクラス
//////////////////////////////////////////////////

import flash.display.BitmapData;

class Bresenham {
    private var canvas:BitmapData;

    public function Bresenham(c:BitmapData) {
        canvas = c;
    }

    public function draw(x0:int, y0:int, x1:int, y1:int, color:uint, alpha:Number):void {
        var steep:Boolean = Math.abs(y1 - y0) > Math.abs(x1 - x0);
        var t:int;
        if (steep) {
            t = x0;
            x0 = y0;
            y0 = t;
            t = x1;
            x1 = y1;
            y1 = t;
        }
        if (x0 > x1) {
            t = x0;
            x0 = x1;
            x1 = t;
            t = y0;
            y0 = y1;
            y1 = t;
        }
        var dx:int = x1 - x0;
        var dy:int = Math.abs(y1 - y0);
        var e:int = dx*0.5;
        var ys:int = (y0 < y1) ? 1 : -1;
        var y:int = y0;
        for (var x:int = x0; x <= x1; x++) {
            if (steep) {
                plot(y, x, color, alpha);
            } else {
                plot(x, y, color, alpha);
            }
            e = e - dy;
            if (e < 0) {
                y = y + ys;
                e = e + dx;
            }
        }
    }
    private function plot(x:int, y:int, c:uint, a:Number):void {
        canvas.setPixel32(x, y, c | ((a*0xFF) << 24));
    }

}


//////////////////////////////////////////////////
// SoundEffectクラス
//////////////////////////////////////////////////

import flash.events.EventDispatcher;
import flash.events.Event;
import flash.events.ProgressEvent;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.media.SoundTransform;
import flash.net.URLRequest;

class SoundEffect extends EventDispatcher {
    public var id:String;
    private var sound:Sound;
    private var channel:SoundChannel;
    private var level:Number;
    private var volume:Number = 1;
    private var looping:Boolean = false;
    public var initialized:Boolean = false;
    public var playing:Boolean = false;
    private var muted:Boolean = false;
    private var mute:Number = 1;

    public function SoundEffect() {
    }

    public function init(Snd:Class):void {
        sound = new Snd();
    }
    public function load(filePath:String):void {
        sound = new Sound();
        sound.load(new URLRequest(filePath));
        sound.addEventListener(ProgressEvent.PROGRESS, progress, false, 0, true);
        sound.addEventListener(Event.COMPLETE, initialize, false, 0, true);
    }
    private function progress(evt:ProgressEvent):void {
        dispatchEvent(evt);
    }
    private function initialize(evt:Event):void {
        initialized = true;
        channel = sound.play();
        channel.stop();
        dispatchEvent(evt);
    }
    public function play(lv:Number, loop:Boolean = false):void {
        playing = true;
        if (channel) channel.stop();
            level = lv;
            looping = loop;
            channel = sound.play();
            var transform:SoundTransform = channel.soundTransform;
            transform.volume = level*volume*mute;
            channel.soundTransform = transform;
            channel.addEventListener(Event.SOUND_COMPLETE, complete, false, 0, true);
    }
    public function stop():void {
        playing = false;
        channel.stop();
        channel.removeEventListener(Event.SOUND_COMPLETE, complete);
    }
    public function setVolume(v:Number):void {
        volume = v;
        var transform:SoundTransform = channel.soundTransform;
        transform.volume = level*volume*mute;
        channel.soundTransform = transform;
    }
    public function setMute(m:Boolean):void {
        muted = m;
        if (muted) {
            mute = 0;
        } else {
            mute = 1;
        }
        var transform:SoundTransform = channel.soundTransform;
        transform.volume = level*volume*mute;
        channel.soundTransform = transform;
    }
    private function complete(evt:Event):void {
        channel.removeEventListener(Event.SOUND_COMPLETE, complete);
        dispatchEvent(new Event(Event.COMPLETE));
        if (looping) {
            channel = sound.play(0);
            channel.addEventListener(Event.SOUND_COMPLETE, complete, false, 0, true);
            var transform:SoundTransform = channel.soundTransform;
            transform.volume = level*volume*mute;
            channel.soundTransform = transform;
        } else {
            playing = false;
        }
    }

}


//////////////////////////////////////////////////
// Mapクラス
//////////////////////////////////////////////////

import flash.display.BitmapData;
import org.papervision3d.core.geom.*;
import org.papervision3d.core.geom.renderables.*;
import frocessing.color.ColorHSV;

class Map {
    private var detection:DetectPixels;
    private static var accuracy:uint = 2;
    private var threshold:uint = 0xFF808080;
    private var pixels:Pixels;
    private static var sw:uint = 400;
    private static var sh:uint = 200;
    private static var colors:Array;
    private var layers:Array;

    public function Map(p:Pixels) {
        pixels = p;
        init();
    }

    private function init():void {
        detection = new DetectPixels(accuracy);
    }
    public function setup(bitmapData:BitmapData):void {
        detection.search(bitmapData, bitmapData.rect, threshold);
        var map:Array = detection.pixels();
        //レイヤー指定
        layers = [map, map, map];
        //色相指定
        var hsv:ColorHSV = new ColorHSV(50, 1);
        for (var n:uint = 0; n < layers.length; n++) {
            //色相変化
            hsv.h = 180 + 20/layers.length*(layers.length - n);
            hsv.s = 1/layers.length*(layers.length - n);
            var color:uint = 0xFF << 24 | hsv.value;
            drawLayer(n, color);
        }
    }
    private function drawLayer(id:uint, color:uint):void {
        var map:Array = layers[id];
        for (var n:uint = 0; n < map.length; n++) {
            var dx:Number = sw/2 - map[n].x;
            var dy:Number = 8*id - 8*uint(layers.length/2);
            var dz:Number = map[n].y - sh/2;
            pixels.addPixel3D(new Pixel3D(color, dx, dy, dz));
        }
    }

}


//////////////////////////////////////////////////
// DetectPixelsクラス
//////////////////////////////////////////////////

import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.Matrix;
import flash.display.IBitmapDrawable;

class DetectPixels {
    private var bd:IBitmapDrawable;
    private var rect:Rectangle;
    private var map:BitmapData;
    private var mapList:Array;
    private var accuracy:uint;
    private var threshold:uint = 0x80FFFFFF;

    public function DetectPixels(a:uint = 1) {
        accuracy = a;
    }

    public function search(t:IBitmapDrawable, r:Rectangle, th:uint = 0x80FFFFFF):void {
        bd = t;
        rect = r;
        threshold = th;
        var w:uint = rect.width/accuracy;
        var h:uint = rect.height/accuracy;
        detect(w, h);
    }
    private function detect(w:uint, h:uint):void {
        map = new BitmapData(w, h, true, 0x00000000);
        var matrix:Matrix = new Matrix();
        matrix.translate(-rect.x, -rect.y);
        matrix.scale(1/accuracy, 1/accuracy);
        map.lock();
        map.draw(bd, matrix);
        map.unlock();
        mapList = new Array();
        for (var x:uint = 0; x < w; x++) {
            for (var y:uint = 0; y < h; y++) {
                var color:uint = map.getPixel32(x, y);
                if (color >= threshold) {
                    var px:int = x*accuracy + rect.x;
                    var py:int = y*accuracy + rect.y;
                    var point:Point = new Point(px, py);
                    mapList.push(point);
                }
            }
        }
    }
    public function pixels():Array {
        return mapList;
    }

}


//////////////////////////////////////////////////
// PhotoLoaderクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.display.Bitmap;
import flash.system.LoaderContext;

class PhotoLoader extends Sprite {
    private var loader:Loader;
    private var info:LoaderInfo;
    public var content:Bitmap;
    private var smoothing:Boolean;
    public static const IO_ERROR:String = IOErrorEvent.IO_ERROR;
    public static const HTTP_STATUS:String = HTTPStatusEvent.HTTP_STATUS;
    public static const SECURITY_ERROR:String = SecurityErrorEvent.SECURITY_ERROR;
    public static const INIT:String = Event.INIT;
    public static const COMPLETE:String = Event.COMPLETE;

    public function PhotoLoader() {
        loader = new Loader();
        info = loader.contentLoaderInfo;
    }

    public function load(file:String, s:Boolean = false):void {
        smoothing = s;
        info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
        info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
        info.addEventListener(Event.INIT, initialize, false, 0, true);
        info.addEventListener(Event.COMPLETE, complete, false, 0, true);
        try {
            loader.load(new URLRequest(file), new LoaderContext(true));
        } catch (err:Error) {
            trace(err.message);
        }
    }
    public function unload():void {
        loader.unload();
    }
    private function ioerror(evt:IOErrorEvent):void {
        loader.unload();
        dispatchEvent(new Event(PhotoLoader.IO_ERROR));
    }
    private function httpstatus(evt:HTTPStatusEvent):void {
        dispatchEvent(new Event(PhotoLoader.HTTP_STATUS));
    }
    private function securityerror(evt:SecurityErrorEvent):void {
        dispatchEvent(new Event(PhotoLoader.SECURITY_ERROR));
    }
    private function initialize(evt:Event):void {
        content = Bitmap(info.content);
        if (smoothing) content.smoothing = true;
        dispatchEvent(new Event(PhotoLoader.INIT));
    }
    private function complete(evt:Event):void {
        info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
        info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
        info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
        info.removeEventListener(Event.INIT, initialize);
        info.removeEventListener(Event.COMPLETE, complete);
        addChild(loader);
        dispatchEvent(new Event(PhotoLoader.COMPLETE));
    }

}
