/**
 * Copyright naoyago ( http://wonderfl.net/user/naoyago )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iJAh
 */

package  {

    import flash.display.Stage;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.KeyboardEvent;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;

    // embed font
    import flash.system.Security;
    import com.bit101.components.*;
    
    [SWF(backgroundColor="#CC0000", width="240", height="240", frameRate="24")]
    
    public class Line extends MovieClip {

        private var data:Data;
        private var player:Array = new Array();
        private var bullet:Array = new Array();
        private var enemy:Array = new Array();
        private var game_start:GameStart;
        private var levelup:Levelup;
        private var score_text:TextField = new TextField();
        private var chain_text:TextField = new TextField();
        private var level_text:TextField = new TextField();
        private var hit_line:HitLine;
        private var mc_hp:Hp;
        private var label:GameLabel;
        private var label_op:OpeningLabel;
        
        // embed font
        private var _zen:FontEmbed;        
        private var _txtFmt:TextFormat = new TextFormat()
        private var _bar:ProgressBar;
        private var _label:Label;

        // constructor code
        public function Line() {
            // background
            this.graphics.beginFill(0x000000, 1.0);
            this.graphics.drawRect(0, 0, 240, 240);
            
            // embed font
            this.loadEmbedFont();
            
            this.data = Data.getInstance();
        }

        private function loadEmbedFont() {
            _label = new Label(this, 180, 203, "Now Loading");
            _bar = new ProgressBar(this, 180, 220);
            _bar.maximum = 100;
            _bar.addEventListener(Event.ENTER_FRAME, loading);
                      
            // Load 88 Zen
            _zen = new FontEmbed("http://begoingto.jp/files/font_zen88.swf", "font_Zen88");
            _zen.addEventListener(FontEmbed.FONT_LOADED, onFontLoaded);
        }
        
        private function loading(event:Event):void {
            _bar.value = _zen.progress;
            if(_bar.value >= 100){
                _bar.removeEventListener(Event.ENTER_FRAME, loading);
                removeChild(_bar)
                removeChild(_label)
            }
        }

        private function onFontLoaded(e:Event):void {
            // load complete
            _zen.removeEventListener(FontEmbed.FONT_LOADED, onFontLoaded);
            
            // play title
            this.playTitle();
        }

        // ========================================
        // 画面
        // ========================================
        // タイトル
        private function playTitle():void {
            this.data.game_mode = this.data.MODE_TITLE;

            this.label_op = new OpeningLabel(stage);

            // キーボード判定(PC用)
            stage.addEventListener(KeyboardEvent.KEY_DOWN , this.keyPlayer);

            // マウス判定
            stage.addEventListener(MouseEvent.CLICK, this.clickStage);
        }

        // ゲーム中
        private function playGame():void {
            this.data.game_mode = this.data.MODE_OPENING;

            this.label_op.remove(stage);

            this.init();

            this.game_start = new GameStart(stage);

            stage.addEventListener(Event.ENTER_FRAME, this.enterFrame);
        }

        // ========================================
        // ゲーム画面
        // ========================================

        // ゲーム初期化
        public function init():void {
            this.data.init();

            // ラベル
            this.label = new GameLabel(stage);

            var i:uint;
            for (i = 1; i <= 3; i++) {
                // playerの初期配置
                this.player[i]= new Player(stage);
                this.player[i].x = i * this.data.PLAYER_X;
                this.player[i].y = this.data.PLAYER_Y;

                // マウスで自機クリック
                this.player[i].addEventListener(MouseEvent.CLICK, this.clickPlayer(i));

                // 弾の初期配置
                this.bullet[i]= new Bullet(stage);
                //this.bullet[i].x = i * PLAYER_X + this.player[i].width / 2;
                this.bullet[i].y = this.data.BULLET_Y;

                // 敵の初期配置
                this.enemy[i]= new Enemy(stage);
                this.enemy[i].x = this.player[i].x + 13;
            }

            // ライン
            this.hit_line = new HitLine(stage);

            // HP
            this.mc_hp = new Hp(stage);

            // レベルアップ表示
            this.levelup = new Levelup(stage);

            // テキスト表示のフォーマット
            var text_format:TextFormat = new MyTextFormat();
            text_format.align = TextFormatAlign.RIGHT;

            // スコア
            this.score_text.defaultTextFormat = text_format;
            this.score_text.text = String(this.data.score);
            this.score_text.textColor = 0xFFFFFF;
            this.score_text.width = 100;
            this.score_text.x = 132;
            this.score_text.y = 6;
            this.score_text.embedFonts = true;
            stage.addChild(this.score_text);

            // チェイン
            this.chain_text.defaultTextFormat = text_format;
            this.chain_text.text = String(this.data.chain);
            this.chain_text.textColor = 0xFFFFFF;
            this.chain_text.width = 100;
            this.chain_text.x = 0;
            this.chain_text.y = 6;
            this.chain_text.embedFonts = true;
            stage.addChild(this.chain_text);

            // レベル
            this.level_text.defaultTextFormat = text_format;
            this.level_text.text = this.addZero(this.data.level, 2);
            this.level_text.textColor = 0xFFFFFF;
            this.level_text.width = 40;
            this.level_text.x = -9;
            this.level_text.y = 140;
            this.level_text.embedFonts = true;
            stage.addChild(this.level_text);
        }

        private function addZero(num:uint, digit:Number):String {
            var str:String = String(num);
            while (str.length < digit) {
                str = "0" + str;
            }
            return str;
        }

        // ==============================
        // スレッド処理
        // ==============================
        private function enterFrame(e:Event):void {
            // ちらつき防止
            this.graphics.beginFill(0x000000, 1.0);
            this.graphics.drawRect(0, 0, 240, 240);
            
            if (this.data.game_mode == this.data.MODE_PLAY) {
                // 3列分ループ
                this.loop();

                // HP0以下で終了
                if (this.data.hp <= 0) {
                    this.endGame();
                }

                this.levelup.enterFrame();
                this.hit_line.enterFrame();

                //trace('score' + this.score);
                //trace('chain' + this.chain);
                //trace('level' + this.level);
            } else if (this.data.game_mode == this.data.MODE_OPENING) {
                this.game_start.enterFrame();
            }
        }

        // ==============================
        // クリックで弾発射用
        // ==============================
        private function clickStage(e:Event):void {
            // タイトル画面
            if (this.data.game_mode == this.data.MODE_TITLE) {
                this.playGame();
                return;
            }

            // ゲーム終了画面
            if (this.data.game_mode == this.data.MODE_END) {
                this.returnTitle();
                return;
            }

            // wait mode
            if (this.data.game_mode == this.data.MODE_WAIT) {
                return;
            }
        }

        private function clickPlayer(param:int):Function{
            return function (e:Event):void {
                shotBullet(param);
            }
        }

        // ==============================
        // キーボードで弾発射用
        // ==============================
        private function keyPlayer(e:KeyboardEvent):void{
            // wait mode
            if (this.data.game_mode == this.data.MODE_WAIT) {
                return;
            }

            // タイトル画面
            if (this.data.game_mode == this.data.MODE_TITLE) {
                this.playGame();
                return;
            }

            // ゲーム終了画面
            if (this.data.game_mode == this.data.MODE_END) {
                this.returnTitle();
                return;
            }

            if (this.data.game_mode == this.data.MODE_PLAY) {
                var param:int;

                // 1〜3なら弾発射処理
                switch (e.keyCode) {
                    case 49:
                        param = 1
                        break;
                    case 50:
                        param = 2;
                        break;
                    case 51:
                        param = 3;
                        break;
                    default:
                        // 1〜3以外なのでreturn
                        return;
                }

                this.shotBullet(param);
            }
        }

        // ==============================
        // 弾発射
        // ==============================
        private function shotBullet(param:uint):void {
            // 弾が存在していなかったら発射
            if (this.bullet[param].y < 1 || this.bullet[param].y >= this.data.BULLET_Y) {
                this.bullet[param].x = param * this.data.PLAYER_X + this.player[param].width / 2;
                this.bullet[param].y = this.data.PLAYER_Y;
            }
        }

        // ==============================
        // 3列分ループ
        // ==============================
        private function loop():void {
            for (var i:uint = 1; i <= 3; i++) {
                // 弾が範囲外
                if (this.bullet[i].y < 1) {
                    this.bullet[i].y = this.data.BULLET_Y;
                } else if (this.bullet[i].y < this.data.BULLET_Y) {
                    // 弾移動
                    this.bullet[i].y -= this.data.BULLET_SPEED;
                }

                // 敵移動
                this.moveEnemy(i);

                // 当たり判定
                this.checkHit(i);

                this.enemy[i].enterFrame();
            }
        }

        // ==============================
        // 敵移動
        // ==============================
        private function moveEnemy(i:uint):void {
            // 難易度、レベルで変化
            if (this.enemy[i].y < stage.stageHeight) {
                this.enemy[i].y += this.enemy[i].speed;
            }
        }

        // ==============================
        // 当たり判定
        // ==============================
        private function checkHit(i:uint):void {
            if (this.enemy[i].status == '') {
                // 弾と敵の当たり判定
                if (this.enemy[i].y > this.bullet[i].y) {
                    var diff:int = this.enemy[i].y - this.hit_line.y + this.data.HIT_ADJUST;
                    var s:String = this.calcScore(diff);
                    this.bullet[i].y = this.data.BULLET_Y;
                    this.enemy[i].explosion(s);
                    this.calcLevel();
                } else if (this.enemy[i].y > this.data.BAD_Y) {
                    // この座標までこられたら強制的に破壊
                    var ss:String = this.calcScore(999);
                    this.bullet[i].y = this.data.BULLET_Y;
                    this.enemy[i].explosion(ss);
                    this.calcLevel();
                }
            }
        }

        // ==============================
        // スコア計算
        // ==============================
        private function calcScore(diff:int):String{
            var str:String = '';

            if (diff > -12 && diff < 12) {
                this.data.score += this.data.SCORE_COOL * this.data.chain * this.data.level;
                this.score_text.text = String(this.data.score);
                this.calcChain(true);
                this.data.cool++;
                str = 'COOL';
            } else if (diff > -20 && diff < 20) {
                this.data.score += this.data.SCORE_GOOD + this.data.chain * this.data.level;
                this.score_text.text = String(this.data.score);
                this.calcChain(true);
                this.data.good++;
                str = 'GOOD';
            } else {
                this.data.score += this.data.SCORE_BAD * this.data.level;
                this.score_text.text = String(this.data.score);
                this.calcChain(false);
                this.data.bad++;
                str = 'BAD';
            }

            // HP増減
            this.calcHp(str);

            return str;
        }

        // ==============================
        // hp計算
        // ==============================
        private function calcHp(str:String):void {
            // とりあえずbadで減るのみ
            switch (str) {
                case 'COOL':
                    this.data.hp += 0;
                    break;
                case 'GOOD':
                    this.data.hp += 0;
                    break;
                case 'BAD':
                    this.data.hp -= 10;
                    break;
            }

            // HPを最大値以上にしない
            if (this.data.hp > this.data.HP_MAX) {
                this.data.hp = this.data.HP_MAX;
            }

            // メータ表示
            this.mc_hp.scaleY = Number(this.data.hp / this.data.HP_MAX);
        }

        // ==============================
        // チェイン判定
        // ==============================
        private function calcChain(isSuccess:Boolean):void {
            if (isSuccess) {
                this.data.chain++;
                if (this.data.max_chain < this.data.chain) {
                    this.data.max_chain = this.data.chain;
                }
            } else {
                this.data.chain = 0;
            }
            this.chain_text.text = String(this.data.chain);
        }

        // ==============================
        // レベルアップ判定
        // ==============================
        private function calcLevel():void {
            if (this.data.level >= this.data.LEVEL_MAX) {
                return;
            }

            if ((this.data.cool * 2 + this.data.good) >= this.data.level * this.data.LEVELUP_BASE) {
                this.data.level++;
                this.level_text.text = this.addZero(this.data.level, 2);
                this.levelup.execute();
            }
        }

        // ========================================
        // 終了画面
        // ========================================
        private function endGame():void{
            this.data.game_mode = this.data.MODE_WAIT;;
            this.remove();
            this.dispScore();
            wait_frame = 0;
            stage.addEventListener(Event.ENTER_FRAME, this.waitFrame);
        }

        // 一定時間操作させない
        private var wait_frame:uint = 0;
        private function waitFrame(e:Event):void {
            wait_frame++;
            // 一定時間過ぎたらゲームモードを変更
            if (wait_frame > 30) {
                this.data.game_mode = this.data.MODE_END;;
            }
        }

        private function remove():void {
            stage.removeEventListener(Event.ENTER_FRAME, this.enterFrame);
            stage.removeChild(this.levelup);
            stage.removeChild(this.hit_line);
            for (var i:uint= 1; i <= 3; i++) {
                stage.removeChild(this.player[i]);
                this.enemy[i].remove(stage);
                stage.removeChild(this.enemy[i]);
                stage.removeChild(this.bullet[i]);
            }
        }

        private var re_chain:TextField = new TextField();
        private var re_cool:TextField = new TextField();
        private var re_good:TextField = new TextField();
        private var re_bad:TextField = new TextField();
        private var re_comment:TextField = new TextField();
        public var end_label:EndLabel;

        private function dispScore():void {
            end_label = new EndLabel(stage);

            // テキスト表示のフォーマット
            var text_format:TextFormat = new MyTextFormat();
            text_format.align = TextFormatAlign.RIGHT;

            // max_chain
            this.re_chain.defaultTextFormat = text_format;
            this.re_chain.text = String(this.data.max_chain);
            this.re_chain.textColor = 0x00FF00;
            this.re_chain.width = 100;
            this.re_chain.height = 22;
            this.re_chain.x = 112;
            this.re_chain.y = 70;
            this.re_chain.embedFonts = true;
            stage.addChild(this.re_chain);

            // cool
            this.re_cool.defaultTextFormat = text_format;
            this.re_cool.text = String(this.data.cool);
            this.re_cool.textColor = 0xFFFF00;
            this.re_cool.width = 100;
            this.re_cool.height = 22;
            this.re_cool.x = 112;
            this.re_cool.y = 94;
            this.re_cool.embedFonts = true;
            stage.addChild(this.re_cool);

            // good
            this.re_good.defaultTextFormat = text_format;
            this.re_good.text = String(this.data.good);
            this.re_good.textColor = 0xFF0000;
            this.re_good.width = 100;
            this.re_good.height = 22;
            this.re_good.x = 112;
            this.re_good.y = 118;
            this.re_good.embedFonts = true;
            stage.addChild(this.re_good);

            // bad
            this.re_bad.defaultTextFormat = text_format;
            this.re_bad.text = String(this.data.bad);
            this.re_bad.textColor = 0x0000FF;
            this.re_bad.width = 100;
            this.re_bad.height = 22;
            this.re_bad.x = 112;
            this.re_bad.y = 142;
            this.re_bad.embedFonts = true;
            stage.addChild(this.re_bad);

            // comment
            text_format.align = TextFormatAlign.LEFT;
            this.re_comment.defaultTextFormat = text_format;
            this.re_comment.text = String(this.makeComment());
            this.re_comment.textColor = 0xffffff;
            this.re_comment.width = 200;
            this.re_comment.x = 52;
            this.re_comment.y = 174;
            this.re_comment.embedFonts = true;
            stage.addChild(this.re_comment);
        }

        private function makeComment():String {
            if (this.data.level < 3) {
                return 'もっと練習しましょう';
            } else if (this.data.level < 5) {
                return '初心者レベルです';
            } else if (this.data.level < 7) {
                return 'まあまあですね';
            } else if (this.data.level < 10) {
                return '10レベル突破で何かが起きる';
            } else if (this.data.level < 12) {
                return 'いい線いってます';
            } else if (this.data.level < 15) {
                return '15レベルで新たな試練が...!?';
            } else if (this.data.level < 17) {
                return '達人レベルです';
            } else if (this.data.level < 20) {
                return 'トップアスリートレベル';
            } else if (this.data.level >= this.data.LEVEL_MAX) {
                return 'まさに神';
            } else {
                return '測定不能です';
            }
        }

        private function returnTitle():void {
            stage.removeChild(this.re_chain);
            stage.removeChild(this.re_cool);
            stage.removeChild(this.re_good);
            stage.removeChild(this.re_bad);
            stage.removeChild(this.re_comment);
            this.end_label.remove(stage);
            this.label.remove(stage);
            this.playTitle();
            stage.removeChild(this.score_text);
            stage.removeChild(this.chain_text);
            stage.removeChild(this.level_text);
            stage.removeEventListener(Event.ENTER_FRAME, this.waitFrame);
        }
    }
}

import flash.display.Sprite;
import flash.display.Shape;
import flash.events.Event;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.text.TextFieldAutoSize;

// ----------------------------
// データ保持用構造体
// class間でのデータやり取りのために使う
// ----------------------------
class Data {

    const PLAYER_X = 58;
    const PLAYER_Y = 232;
    const ENEMY_Y = -30;
    const ENEMY_BASE_SPEED = 3;
    const ENEMY_MIN_SPEED = 2;
    const ENEMY_MAX_SPEED = 5;
    // 削除状態にするy座標
    // removeChildせずに範囲外に置くことで削除状態にする
    const BULLET_Y = 260;
    const BULLET_SPEED = 5;
    const BAD_Y = 180; // 敵破壊できなくても特定の座標まできたら強制的に破壊
    const HIT_ADJUST = 0; // 当たり判定の弾の大きさによるぶれ調整用
    const SCORE_COOL = 20;
    const SCORE_GOOD = 10;
    const SCORE_BAD = 1;
    const CHAIN_MAX = 99;
    const SPEED_CHANGE_LEVEL = 10; // このレベルに到達で難易度さらに上昇
    const LEVELUP_BASE = 10; // レベルアップするまでのgood以上のカウント数
    const LEVEL_MAX = 20;
    const LEVEL_HARD_MODE = 5;
    const LEVEL_MASTER_MODE = 10;
    const LEVEL_LAST_MODE = 15;
    const HP_MAX = 100; // HP量

    public var game_mode:uint = 0; // タイトル画面、ゲーム画面、終了画面の判定に使う
        const MODE_TITLE = 0;
        const MODE_OPENING = 1;
        const MODE_PLAY = 2;
        const MODE_WAIT = 98;
        const MODE_END = 99;
    public var level:uint = 1;
    public var score:int = 0;
    public var chain:int = 0;
    public var max_chain:int = 0;
    public var cool:int = 0;
    public var good:int = 0;
    public var bad:int = 0;
    public var hp:int = HP_MAX;

    public static var instance:Data = new Data();  // singleton

    public function Data() {
        if (instance) {
            throw new ArgumentError('Dataクラスは外部からインスタンス化できません。');
        }
    }

    public static function getInstance():Data {
        return instance;
    }

    public function init() {
        // initialize for retry game
        this.hp = HP_MAX;
        this.level = 1;
        this.score = 0;
        this.chain = 0;
        this.max_chain = 0;
        this.cool = 0;
        this.good = 0;
        this.bad = 0;
    }
}

// ----------------------------
// player
// ----------------------------
class Player extends Sprite {

    public function Player(s) {
        this.graphics.lineStyle(2, 0x0000ff, 1.0);
        this.graphics.beginFill(0x000000, 1.0);
        this.graphics.drawRect(0, 0, 24, 10);
        s.addChild(this);
    }
}

// ----------------------------
// bullet
// ----------------------------
class Bullet extends Shape {

    public function Bullet(s) {
        this.graphics.lineStyle(2, 0x00ff00, 1.0);
        this.graphics.beginFill(0x00ff00, 1.0);
        this.graphics.drawRect(0, 0, 0, 10);
        s.addChild(this);
    }
}

// ----------------------------
// enemy
// ----------------------------
class Enemy extends Shape {

    public var speed:int;
    public var status:String = '';
    private var data;
    private var tf:TextField = new TextField();

    public function Enemy(s) {
        this.data = Data.getInstance();
        this.reset();
        s.addChild(this);

        // COOL or GOOD or BAD
        var text_format = new MyTextFormat();
        text_format.size = 14;
        this.tf.defaultTextFormat = text_format;
        this.tf.textColor = 0xff0000;
        this.tf.alpha = 0;
        this.tf.embedFonts = true;
        s.addChild(this.tf);
    }

    public function reset() {
        this.status = '';
        this.speed = this.setSpeed();
        this.setColor();
        this.setPosition();
        this.tf.alpha = 0;
    }

    public function setColor() {
        // 暗い色は除去するために範囲内でランダム
        var color:uint = 0x666666 * Math.random() + 0x999999;
        this.graphics.lineStyle(2, color, 1.0);
        this.graphics.beginFill(0x000000, 1.0);
        this.graphics.drawRect(-8, -8, 16, 16);

        this.scaleX = 1
        this.scaleY = 1;
        this.alpha = 1;
    }

    public function setSpeed():Number {
        var r:Number;

        // 一定レベルまでは敵の速度は変わらない
        if (data.level >= data.LEVEL_HARD_MODE) {
            // レベルMAXでこの値
            r = Math.random() * data.ENEMY_BASE_SPEED;

            // レベルに応じて調整
            r = (data.level / data.LEVEL_MAX) * r;
        } else {
            r = 0;
        }

        var speed:Number;

        // 速い方が若干確率高い
        if ((Math.random() * 100) >= 40) {
            speed = (data.ENEMY_BASE_SPEED + r > data.ENEMY_MAX_SPEED && data.level < data.LEVEL_MAX) ? data.ENEMY_MAX_SPEED : data.ENEMY_BASE_SPEED + r;
        } else {
            speed = (data.ENEMY_BASE_SPEED - r < data.ENEMY_MIN_SPEED && data.level < data.LEVEL_MAX) ? data.ENEMY_MIN_SPEED : data.ENEMY_BASE_SPEED - r;
        }

        return speed;
    }

    private function setPosition() {
        var r:Number;

        // レベルで初期位置がばらける
        r = Math.random() * 150 * (0.5 + (this.data.level / this.data.LEVEL_MAX / 2));

        this.y = data.ENEMY_Y - r;
    }

    public function explosion(st) {
        this.status = st;
        this.tf.text = this.status;
        this.tf.x = this.x;
        this.tf.y = this.y;
        switch (this.status) {
            case 'COOL':
                this.tf.textColor = 0xffff00;
                break;
            case 'GOOD':
                this.tf.textColor = 0xff0000;
                break;
            case 'BAD':
                this.tf.textColor = 0x0000ff;
                break;
        }
        this.tf.alpha = 0;
    }

    private var cnt:int = 0;
    public function enterFrame() {
        if (this.status) {
            this.speed = 0;
            this.scaleX += 0.1;
            this.scaleY += 0.1;
            this.alpha -= 0.2;
            this.tf.alpha += 0.2;
            if (this.alpha <= 0 && this.cnt == 0) {
                this.cnt = 1;
                this.alpha = 0;
            }
            if (this.cnt >= 1) {
                this.cnt++;
                if (this.cnt >= 8) {
                    this.cnt = 0;
                    this.reset();
                }
            }
        }
    }

    public function remove(s) {
        s.removeChild(this.tf);
    }
}

// ----------------------------
// line
// ----------------------------
class HitLine extends Shape {

    const MASTER_LIMIT_Y = 10;
    const LAST_LIMIT_Y = 15;
    private var data;
    private var flag:Boolean = false;
    private var last_flag:Boolean = false;
    private var default_y:int = 120;;
    private var limit_y:int;
    private var cnt:int = 0;

    public function HitLine(s) {
        this.data = Data.getInstance();
        this.graphics.lineStyle (1, 0xffffff, 1.0);
        this.graphics.moveTo (0, 0);
        this.graphics.lineTo (240, 0);
        this.y = this.default_y;
        s.addChild(this);
    }

    public function enterFrame() {
        // move line
        if (this.data.level >= this.data.LEVEL_MASTER_MODE) {
            this.limit_y = MASTER_LIMIT_Y;
        } else if (this.data.level >= this.data.LEVEL_LAST_MODE) {
            this.limit_y = LAST_LIMIT_Y;
        }

        if (this.data.level >= this.data.LEVEL_MASTER_MODE) {
            this.moveLine();
        }

        // hide line
        if (this.data.level >= this.data.LEVEL_LAST_MODE) {
            if (this.cnt > 0) {
                this.cnt++;
                if (this.cnt >= 5) {
                    this.cnt = 0;
                }
            } else {
                this.hideLine();
            }
        }
    }

    private function moveLine() {
        if (this.flag == false) {
            this.y--;
            if (this.y <= this.default_y - this.limit_y) {
                this.flag = true;
            }
        } else {
            this.y++;
            if (this.y >= this.default_y + this.limit_y) {
                this.flag = false;
            }
        }
    }

    private function hideLine() {
        if (this.last_flag == false) {
            this.alpha -= 0.1;
            if (this.alpha <= 0) {
                this.alpha = 0;
                this.last_flag = true;
                this.cnt = 1;
            }
        } else {
            this.alpha += 0.1;
            if (this.alpha >= 1) {
                this.alpha = 1;
                this.last_flag = false;
                this.cnt = 1;
            }
        }
    }
}

// ----------------------------
// hp
// ----------------------------
class Hp extends Shape {

    public function Hp(s) {
        this.graphics.lineStyle(2, 0xffffff, 1.0);
        this.graphics.beginFill(0x000000, 1.0);
        this.graphics.drawRect(0, 0, -20, -60);
        this.x = 30;
        this.y = 244;
        s.addChild(this);
    }
}

// ----------------------------
// text format
// ----------------------------
class MyTextFormat extends TextFormat {

    public function MyTextFormat() {
        this.font = "88 Zen";
        this.size = 10;
        this.align = TextFormatAlign.LEFT;
    }
}


// ----------------------------
// label
// ----------------------------
class GameLabel extends Sprite {

    private var hp:TextField = new TextField();
    private var level:TextField = new TextField();
    private var chain:TextField = new TextField();
    private var score:TextField = new TextField();

    public function GameLabel(s) {
        var text_format = new MyTextFormat();
        text_format.size = 10;

        // hp
        hp.defaultTextFormat = text_format;
        hp.text = 'HP';
        hp.textColor = 0xffff00;
        hp.x = 11;
        hp.y = 164;
        hp.embedFonts = true;
        s.addChild(hp);

        // level
        level.defaultTextFormat = text_format;
        level.text = 'LV';
        level.textColor = 0xffff00;
        level.x = 11;
        level.y = 124;
        level.embedFonts = true;
        s.addChild(level);

        // chain
        chain.defaultTextFormat = text_format;
        chain.text = 'CHAIN';
        chain.textColor = 0x00ff00;
        chain.x = 10;
        chain.y = 6;
        chain.embedFonts = true;
        s.addChild(chain);

        // score
        score.defaultTextFormat = text_format;
        score.text = 'SCORE';
        score.textColor = 0xffffff;
        score.x = 120;
        score.y = 6;
        score.embedFonts = true;
        s.addChild(score);
    }

    public function remove(s) {
        s.removeChild(this.hp);
        s.removeChild(this.level);
        s.removeChild(this.chain);
        s.removeChild(this.score);
    }
}

// ----------------------------
// opening label
// ----------------------------
class OpeningLabel extends Sprite {

    private var border = new Shape();
    private var title:TextField = new TextField();
    private var explain:TextField = new TextField();
    private var press:TextField = new TextField();

    public function OpeningLabel(s) {
        var text_format = new MyTextFormat();

        // border
        border.graphics.lineStyle(2, 0xffffff, 1.0);
        border.graphics.beginFill(0x000000, 1.0);
        border.graphics.drawRect(32, 78, 180, 114);
        s.addChild(border);

        // title BORDER LINE
        text_format.size = 24;
        title.defaultTextFormat = text_format;
        title.text = 'BORDER LINE';
        title.textColor = 0xffffff;
        title.width = 200;
        title.x = 32;
        title.y = 20;
        title.embedFonts = true;
        s.addChild(title);

        // text size
        text_format.size = 10;

        // explain
        explain.defaultTextFormat = text_format;
        explain.width = 170;
        explain.height = 160;
        explain.multiline = true;
        explain.wordWrap = true;
        explain.text = "中央のラインに合わせて撃破しろ!!\n\nCOOL, GOOD, BADの3種類の評価だ!!\n\nATTCK: 1, 2, 3 KEY";
        explain.textColor = 0xffffff;
        explain.x = 40;
        explain.y = 84;
        explain.embedFonts = true;
        s.addChild(explain);

        // press key
        press.defaultTextFormat = text_format;
        press.text = 'PRESS ANY KEY TO START';
        press.textColor = 0xffffff;
        press.width = 200;
        press.x = 42;
        press.y = 204;
        press.embedFonts = true;
        s.addChild(press);
    }

    public function remove(s) {
        s.removeChild(this.title);
        s.removeChild(this.border);
        s.removeChild(this.explain);
        s.removeChild(this.press);
    }
}


// ----------------------------
// end label
// ----------------------------
class EndLabel extends Sprite {

    private var over:TextField = new TextField();
    private var chain:TextField = new TextField();
    private var cool:TextField = new TextField();
    private var good:TextField = new TextField();
    private var bad:TextField = new TextField();
    private var border = new Shape();
    private var press:TextField = new TextField();

    public function EndLabel(s) {
        var text_format = new MyTextFormat();

        // game over
        text_format.size = 20;
        over.defaultTextFormat = text_format;
        over.text = 'GAME OVER...';
        over.textColor = 0xffffff;
        over.width = 200;
        over.x = 50;
        over.y = 30;
        over.embedFonts = true;
        s.addChild(over);

        text_format.size = 10;

        // max chain
        chain.defaultTextFormat = text_format;
        chain.text = 'MAX CHAIN';
        chain.textColor = 0x00ff00;
        chain.x = 50;
        chain.y = 70;
        chain.embedFonts = true;
        s.addChild(chain);

        // cool
        cool.defaultTextFormat = text_format;
        cool.text = 'COOL';
        cool.textColor = 0xffff00;
        cool.x = 50;
        cool.y = 94;
        cool.embedFonts = true;
        s.addChild(cool);

        // good
        good.defaultTextFormat = text_format;
        good.text = 'GOOD';
        good.textColor = 0xff0000;
        good.x = 50;
        good.y = 118;
        good.embedFonts = true;
        s.addChild(good);

        // bad
        bad.defaultTextFormat = text_format;
        bad.text = 'BAD';
        bad.textColor = 0x0000ff;
        bad.x = 50;
        bad.y = 142;
        bad.embedFonts = true;
        s.addChild(bad);

        // comment
        border.graphics.lineStyle(2, 0xffffff, 1.0);
        border.graphics.beginFill(0x000000, 1.0);
        border.graphics.drawRect(46, 170, 170, 30);
        s.addChild(border);

        // press key
        press.defaultTextFormat = text_format;
        press.text = 'PRESS ANY KEY TO CONTINUE';
        press.textColor = 0xffffff;
        press.width = 200;
        press.x = 46;
        press.y = 210;
        press.embedFonts = true;
        s.addChild(press);
    }

    public function remove(s) {
        s.removeChild(this.over);
        s.removeChild(this.chain);
        s.removeChild(this.cool);
        s.removeChild(this.good);
        s.removeChild(this.bad);
        s.removeChild(this.border);
        s.removeChild(this.press);
    }
}

// ----------------------------
// game start
// ----------------------------
class GameStart extends TextField {

    const EASE_Y = 104;
    private var data;

    public function GameStart(s) {
        this.data = Data.getInstance();

        var text_format = new MyTextFormat();
        text_format.size = 20;
        this.defaultTextFormat = text_format;
        this.autoSize = TextFieldAutoSize.LEFT;
        this.text = 'GAME START!!';
        this.textColor = 0xffffff;
        this.x = s.width / 2 - 74;
        this.y = 92;
        this.alpha = 0;
        this.embedFonts = true;

        s.addChild(this);
    }

    private function reset() {
        //this.alpha = 0;
        this.data.game_mode = this.data.MODE_PLAY;
        stage.removeChild(this);
    }

    private var cnt:int = 0;
    public function enterFrame() {
        if (this.alpha <= 1) {
            this.y += (EASE_Y - this.y) * 0.3;
            this.alpha += 0.1;
        } else if (this.alpha >= 1 && this.cnt == 0) {
            this.alpha = 1;
            this.cnt = 1;
        }

        if (this.cnt >= 1) {
            this.cnt++;
        }

        if (this.cnt > 8 && this.cnt <= 20) {
            this.y += 1;
            this.alpha -= 0.2;
        } else if (this.cnt > 20) {
            this.cnt = 0;
            this.reset();
        }
    }
}

// ----------------------------
// levelup
// ----------------------------
class Levelup extends TextField {

    const LEVEL_Y = 82;
    const EASE_Y = 104;

    private var base_x;
    private var data;

    public function Levelup(s) {
        this.data = Data.getInstance();

        var text_format = new MyTextFormat();
        text_format.size = 20;
        this.defaultTextFormat = text_format;
        this.autoSize = TextFieldAutoSize.LEFT;
        this.textColor = 0xffffff;
        this.base_x = s.width / 2 - 54;
        this.x = this.base_x;
        this.y = LEVEL_Y;
        this.embedFonts = true;
        this.reset();

        s.addChild(this);
    }

    private function reset() {
        this.alpha = 0;
        this.text = '';
        this.x = this.base_x;
        this.y = LEVEL_Y;
    }

    public function execute() {
        if (data.level == data.LEVEL_HARD_MODE) {
            //this.background = true;
            //this.textColor = 0x333333;
            //this.backgroundColor = 0xeeee00;
            this.textColor = 0xffff00;
            this.x = this.base_x - 30;
            this.text = String('HARD MODE突入!!');
        } else if (data.level == data.LEVEL_MASTER_MODE) {
            //this.background = true;
            //this.textColor = 0x333333;
            //this.backgroundColor = 0xeeee00;
            this.textColor = 0xffff00;
            this.x = this.base_x - 58;
            this.text = String('MASTER MODE突入!!');
        } else if (data.level == data.LEVEL_LAST_MODE) {
            //this.background = true;
            //this.textColor = 0x333333;
            //this.backgroundColor = 0xeeee00;
            this.textColor = 0xffff00;
            this.x = this.base_x - 18;
            this.text = String('最後の試練だ...!!');
        } else if (data.level >= data.LEVEL_MAX) {
            this.background = true;
            this.backgroundColor = 0x990000;
            this.textColor = 0xffffff;
            this.x = this.base_x - 10;
            this.text = String('LEVEL MAX!!');
        } else {
            this.background = false;
            this.textColor = 0xffffff;
            this.text = String('LEVEL UP!!');
        }
    }

    private var cnt:int = 0;
    public function enterFrame() {
        //display if has levelup text
        if (this.text) {
            if (this.alpha <= 1) {
                this.y += (EASE_Y - this.y) * 0.3;
                this.alpha += 0.1;
            } else if (this.alpha >= 1 && this.cnt == 0) {
                this.alpha = 1;
                this.cnt = 1;
            }

            if (this.cnt >= 1) {
                this.cnt++;
            }

            if (this.cnt > 8 && this.cnt <= 20) {
                this.y += 1;
                this.alpha -= 0.2;
            } else if (this.cnt > 20) {
                this.cnt = 0;
                this.reset();
            }
        }
    }
}

// forked from mousepancyo's フォント共有テスト（Dynamic Embedded Fonts）
//class FontEnbed
import flash.events.Event;
import flash.events.ProgressEvent;
import flash.events.EventDispatcher;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.net.URLLoader;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.Font;
import flash.system.LoaderContext;
import flash.system.ApplicationDomain;
import flash.system.SecurityDomain;
import flash.system.Security;

class FontEmbed extends EventDispatcher {

    private var _fontClassName:String
    private var _loader:Loader = new Loader()
    public var progress:int
    
    public static const FONT_LOADED:String = "font_loaded";
    
    public function FontEmbed(fontPath:String, fontClassName:String) {
        Security.loadPolicyFile("http://begoingto.jp/crossdomain.xml");
        Security.allowDomain("begoingto.jp");
        swfLoad(fontPath);
        _fontClassName = fontClassName;
    }
    
    //Load FontSwf
    private function swfLoad(fontPath:String):void{
        var context:LoaderContext = new LoaderContext(); 
        context.checkPolicyFile = true;
        context.securityDomain = SecurityDomain.currentDomain; 
        context.applicationDomain = ApplicationDomain.currentDomain;
        var req:URLRequest = new URLRequest(fontPath);
        _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, swfLoadComplete);
        _loader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS,onProgressListener);
        _loader.load(req, context);
    }
    
    //Progress
    private function onProgressListener(e:ProgressEvent):void {
        progress = e.bytesLoaded/e.bytesTotal*100;
    }
    
    //Load Complete
    private function swfLoadComplete(e:Event):void {
        _loader.contentLoaderInfo.removeEventListener(Event.COMPLETE,swfLoadComplete);
        _loader.contentLoaderInfo.removeEventListener(ProgressEvent.PROGRESS,onProgressListener);
        var fontClass:Class = _loader.contentLoaderInfo.applicationDomain.getDefinition(_fontClassName) as Class; 
        try{
            Font.registerFont(fontClass);
        }catch(e:Error){
            //
        }
        dispatchEvent(new Event(FontEmbed.FONT_LOADED));
    }
    
    //Embeted Font
    public function embetedFont(txt:TextField, fontname:String, size:Number, fmt:TextFormat):void {
        var tfmt:TextFormat = fmt
        tfmt.font = fontname;
        tfmt.size = size;
        txt.embedFonts = true;
        txt.defaultTextFormat = tfmt;
    }
}