/**
 * Copyright Cheshir ( http://wonderfl.net/user/Cheshir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iIVi
 */

package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private var level:MapLevel = new MapLevel();
        
        public function FlashTest() {
            // write as3 code here..
            addChild(level.getGreed(42,42));
        }
    }
}
import flash.display.DisplayObject;
import flash.display.BlendMode;
import flash.geom.ColorTransform;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.events.MouseEvent;
import flash.display.Sprite;

Class {
    class MapLevel extends Sprite {
    public var coridor6:int = 2;    // 2 коридора длинной 6 клеток
    public var coridor3:int = 4;    // 4 коротких коридора
    public var coridor2:int = 2;    // 2 очень коротких коридора
    public var coridor1:int = 1;    // 1 перемычка
    public var turn:int = 4;    // Количество поворотов влияет на запутанность подземелья?
    
    // Нельзя купить еще развилку пока недостаточно окончаний 
    public var fork:int = 2;      // Вероятно можно рассчитать количество окончаний подземелья из количества развилок...
    // Мне кажется или количество тупиков равно количеству развилок * 2 ?
    // Это окончания коридоров...
    public var deadEnd:int = 1;    // не уверен что следует количественно ограничивать тупики... а вот комнаты можно
    public var steps:int = 1;    // Количество лестниц - будет равным количеству этажей - самая дорогая деталь...
    public var rooms:int = 2;    // Комнаты 2...
    
    private var tileSize:int = 10;
    private var myGrid:Sprite;
    
    private var NRoom:Sprite;
    private var elementsPanel:ElementsPanel;
    
        public function MapLevel(){
            /* Я ведь могу позволить игрокам создавать свои крепости?
            Почему нет? В комнатах генерятся монстры, в тупиках можно найти предметы. 
            
            Короче вместо рандомной генерации я выбираю творчество игроков... 
            И развитие крепости вглубь чтобы делать забег по крепости, а потом улучшать ее чтобы сдеалать следующий забег */
            NRoom = new Sprite();
            drawNRoom(0xccffcc);
        }
        public function getGreed(w:int, h:int):Sprite {
            var greed:Sprite = new Sprite();
            greed.graphics.lineStyle(1,0xB5692F);
            greed.graphics.beginFill(0xC68E3B);
            var cellSize:int = tileSize;
            for(var i:int=0; i<=w; i++){
                greed.graphics.moveTo( i*cellSize, 0 );
                greed.graphics.lineTo( i*cellSize, h*cellSize );
            }
            for(i = 0; i<=h; i++){
                greed.graphics.moveTo( 0, i*cellSize );
                greed.graphics.lineTo( w*cellSize, i*cellSize  );
            }
            greed.graphics.drawRect(0,0,w*cellSize,h*cellSize);
            myGrid = greed;
         //   myGrid.addEventListener(MouseEvent.MOUSE_DOWN, startDr);
         //   myGrid.addEventListener(MouseEvent.MOUSE_UP, stopDr);
            myGrid.addEventListener(MouseEvent.MOUSE_MOVE, replaceNRoom);
            myGrid.addEventListener(MouseEvent.CLICK, createTile);
            myGrid.addChild(makePergament(w*tileSize, h*tileSize));
            myGrid.addChild(NRoom);
            elementsPanel = new ElementsPanel(myGrid)
            return myGrid;
        }
        private var tiles:Array = [];
        private function createTile(e:MouseEvent):void {
            if(canPlaceTile){
                myGrid.graphics.beginFill(0xffffff);
                myGrid.graphics.drawRect(NRoom.x-tileSize,NRoom.y-tileSize,NRoom.width,NRoom.height);
            }
            tiles.push({ x : NRoom.x + tileSize, y : NRoom.y + tileSize,    // WTF ?
             width : 10, heigth : 10 });        // something went wrong
        }
        private var canPlaceTile:Boolean = true;
        private function replaceNRoom(e:MouseEvent):void {
            NRoom.x = Math.floor(mouseX/tileSize)*tileSize;
            NRoom.y = Math.floor(mouseY/tileSize)*tileSize;
            canPlaceTile = true;
            drawNRoom(0xccffcc);
            // Здесь же я могу проверить не пересекается ли тайл со старыми значениями... Если хоть одна клетка тайла
            // Пересекается с занятой клеткой... тогда запрещаем сие действие
            for each(var oldTile:Object in tiles){
                if( intersects( oldTile.y, NRoom.y+NRoom.height, oldTile.y+oldTile.heigth, NRoom.y, oldTile.x+oldTile.width, NRoom.x, oldTile.x, NRoom.x+NRoom.width ) ){
                    canPlaceTile = false;
                    drawNRoom(0xffcccc);
                    return;
                }
            }
        }
        private function startDr(e:MouseEvent):void {
            myGrid.startDrag();
        }
        private function stopDr(e:MouseEvent):void {
            myGrid.stopDrag();
        }
        private function drawNRoom(color:uint):void{
            NRoom.graphics.clear();
            NRoom.graphics.beginFill(color,0.4);
            NRoom.graphics.lineStyle(1,color);
            NRoom.graphics.drawRect(-10,-10, tileSize*3, tileSize*3);
        }
        // Проверим прямоугольники на пересечения
        private function intersects(aY:Number, bY_1:Number, aY_1:Number, bY:Number, aX_1:Number, bX:Number, aX:Number, bX_1:Number):Boolean {
            return !( aY > bY_1 || aY_1 < bY || aX_1 < bX || aX > bX_1 );
        }
        private function makePergament(w:Number, h:Number):Bitmap{
            var b:Bitmap = new Bitmap(new BitmapData(w,h,true,0));
            b.bitmapData.perlinNoise(w, h, 3, 12345, true, true, 7, true);
            b.transform.colorTransform = new ColorTransform(1, 1, 1, 0.3, 255, 225, 50, 50);
            //b.blendMode = BlendMode.ADD;
            return b;
        }
    }
    class ElementsPanel extends Sprite {
        public var elements:Array = [];
        public function ElementsPanel(parent:Sprite) {
            this.y = parent.height - 50;
            parent.addChild(this);
            initElements();
        }
        private function initElements():void{
            var undoBtn:Sprite = new Sprite();
            undoBtn.graphics.lineStyle(1,0xB5692F);
            undoBtn.graphics.beginFill(0xC68E3B);
            undoBtn.graphics.drawCircle(30,0,20);
            addChild(undoBtn);
        }
    }
    
    class AddElementCommand {
        public function AddElementCommand(){
            
        }
        public function execute(deadEnd:Object, newElement:Object):void{    // Добавить элемент
            
        }
        public function undo():void{    // Отменить команду
            
        }
    }
}


