/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iIHz
 */

package
{
    import flash.display.*;
    import flash.system.*;
    import flash.events.*;
    import flash.geom.*;
    
    [SWF(frameRate = 60, width = 465, height = 465)]
    public class TestInstance extends Sprite
    {
        public function TestInstance()
        {
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
        
        public function _init() :void
        {
            graphics.clear     ();
            graphics.lineStyle (1, 0, 0.75);
            graphics.drawRect  (0, 0, 464, 464);
        }
    
        public function addedToStage($e:Event) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);

            _init();
            
            addChild(new Target);
            addChild(new Projectile);
        }
    }
}

import flash.display.*;
import flash.system.*;
import flash.events.*;
import flash.geom.*;

class varResource
{
    public static var targetX :Number;
    public static var targetY :Number;
    public static var targetvX :Number;
    public static var targetvY :Number;
}


class Projectile extends Sprite
{
    protected var _size :Number;
    protected var _x :Number;
    protected var _y :Number;
    
    public function Projectile()
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    
        _x = 232.5;
        _y = 232.5;
        _size = 5;
    }
    
    public function _init() :void
    {
        graphics.lineStyle  (1, 0, 0.9);
        graphics.drawCircle (_x, _y, _size);     
    }
    
    public function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _init();
        
        stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
    }
    
    internal var velX:Number;
    internal var velY:Number;
    
    public function traverseStage($dest:Point) :void
    {
        if (x < (varResource.targetX + 12) && y < (varResource.targetY + 12))
        {
            removeEventListener(Event.ENTER_FRAME, onEnterFrame);
            x = y = 232.5;
        }

        velX = ($dest.x - x);
        velY = ($dest.y - y);
       
        x -= -(velX / 4);
        y -= -(velY / 4);
    }
    
    internal var mouseCoord:Point = new Point();
    
    public function onMouseDown($e:MouseEvent) :void
    {
        addEventListener(Event.ENTER_FRAME, onEnterFrame);
        
        mouseCoord = new Point($e.stageX, $e.stageY);
    }
    
    public function onEnterFrame($e:Event) :void
    {
        traverseStage(new Point(varResource.targetX, varResource.targetY));
    }
    
    public function get size() :Number
    { return _size }
    public override function get x() :Number
    { return _x }
    public override function get y() :Number
    { return _y }
    
    public function set size($:Number) :void
    { _size = $; _init(); }
    public override function set x($:Number) :void
    { _x = $; _init(); }
    public override function set y($:Number) :void
    { _y = $; _init(); }
}

class Target extends Sprite
{
    protected var _size :Number;
    protected var _x :Number;
    protected var _y :Number;
    
    private var i :Number; //initial coordinate
    private var t :Number; //terminal coordinate
    
    private var TOP_LEFT :Boolean = true;
    private var TOP_RIGHT :Boolean;
    private var BOT_LEFT :Boolean;
    private var BOT_RIGHT :Boolean;
    
    public function Target()
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);    
        
        _size = 12;
        _x = (_size + 1);
        _y = (_size + 1);
        
        i = 13;
        t = 452;
        
        BOT_RIGHT = BOT_LEFT = TOP_RIGHT = !TOP_LEFT;
    }
    
    public function _init() :void
    {
        graphics.clear      ();
        graphics.beginFill  (0, 0.5);
        graphics.drawCircle (_x, _y, _size);
        graphics.endFill    ();
        
        varResource.targetX = _x;
        varResource.targetY = _y;
    }

    public function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _init();
        
        addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    
    public function onEnterFrame($e:Event) :void
    {
        plotTriggers();
        traverseCanvas();    
    }
    
    public function plotTriggers() :void
    {
        if  ((_x == t) && (_y == i))
            {TOP_RIGHT = !(TOP_LEFT = false)}
        if  ((_x == t) && (_y == t))
            {BOT_RIGHT = !(TOP_RIGHT = false)}
        if  ((_x == i) && (_y == t))
            {BOT_LEFT = !(BOT_RIGHT = false)}
        if  ((_x == i) && (_y == i))
            {TOP_LEFT = !(BOT_LEFT = false)}
    }
    
    public function traverseCanvas() :void
    {
        if  (TOP_LEFT)
            {x++; varResource.targetvX = 1; varResource.targetvY = 0; }
        if  (TOP_RIGHT)
            {y++; varResource.targetvY = 1; varResource.targetvX = 0; }
        if  (BOT_RIGHT)
            {x--; varResource.targetvX = -1; varResource.targetvY = 0; }
        if  (BOT_LEFT)
            {y--; varResource.targetvY = -1; varResource.targetvX = 0; }
    }

    public function get size() :Number
    { return _size }    
    public override function get x() :Number
    { return _x }
    public override function get y() :Number
    { return _y }

    public function set size($:Number) :void
    { _size = $; _init(); }    
    public override function set x($:Number) :void
    { _x = $; _init(); }
    public override function set y($:Number) :void
    { _y = $; _init(); }
}
