/**
 * Copyright aolba ( http://wonderfl.net/user/aolba )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iHsz
 */

// forked from craftomaniac's flash on 2011-2-9
package {
    import flash.display.*;
    import flash.events.*;
    public class FlashTest extends Sprite {
        public var backgroundSpr:Sprite;
        public var displaySpr:Sprite;
        public var points:Vector.<Object>;
        public var joints:Vector.<Object>;
        public var isMouseDown:Boolean = false;
        public var clickThreshold:Number = 4;
        public function FlashTest():void {
            initialize();
        }
        public function initialize():void {
            points = new Vector.<Object>();
            joints = new Vector.<Object>();
            drawBackground();
            displaySpr = new Sprite();
            addChild(displaySpr);
            populatePoints();
            addEventListener(Event.ENTER_FRAME, enterFrame);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent) {
                isMouseDown = true;
                var i:int;
                for (i = 0; i < points.length; ++i) {
                    var dx:Number = stage.mouseX - points[i].x;
                    var dy:Number = stage.mouseY - points[i].y;
                    var dist:Number = Math.sqrt(dx * dx + dy * dy);
                    if (dist < clickThreshold) {
                        points[i].mouse = true;
                        break;
                    }
                }
            });
            stage.addEventListener(MouseEvent.MOUSE_UP, function(e:MouseEvent) {isMouseDown = false;});
        }
        public function enterFrame(e:Event):void {
            updatePhysics();
            
            displaySpr.graphics.clear();
            var i:int;
            joints.forEach(function(o:Object, id:int, v:Vector.<Object>):void {
                with (displaySpr.graphics) {
                    lineStyle(1, 0xFF0000, 0.3);
                    moveTo(o.a.x, o.a.y);
                    lineTo(o.b.x, o.b.y);
                    endFill();
                }
            });
            points.forEach(function(o:Object, id:int, v:Vector.<Object>):void {
                with (displaySpr.graphics) {
                    beginFill(0xFFFFFF, 0.5);
                    drawCircle(o.x, o.y, 3);
                    endFill();
                }
            });
        }
        public function updatePhysics():void {
            points.forEach(function(o:Object, id:int, v:Vector.<Object>):void {
                if (!isMouseDown) o.mouse = false;
                if (o.mouse) {
                    o.x = stage.mouseX;
                    o.y = stage.mouseY;
                }
                if (!o.blocked) {
                    o.vy += 0.3;
                    o.vx *= 0.95;
                    o.vy *= 0.95;
                    o.x += o.vx;
                    o.y += o.vy;
                }
            });
            joints.forEach(function(o:Object, id:int, v:Vector.<Object>):void {
                var angle:Number = Math.atan2(o.b.y - o.a.y, o.b.x - o.a.x);
                var dx:Number = o.b.x - o.a.x;
                var dy:Number = o.b.y - o.a.y;
                var dd:Number = Math.sqrt(dx * dx + dy * dy) - o.d;
                var fx:Number = 0.5 * dd * Math.cos(angle);
                var fy:Number = 0.5 * dd * Math.sin(angle);
                o.a.vx += fx;
                o.a.vy += fy;
                o.b.vx -= fx;
                o.b.vy -= fy;
            });
        }
        public function populatePoints():void {
            var i:int, j:int;
            var sw:Number = stage.stageWidth;
            var sh:Number = stage.stageHeight;
            var w:Number = 0.7 * sw;
            var h:Number = 0.7 * sh;
            var ox:Number = 0.5 * (sw - w);
            var oy:Number = 0.5 * (sh - h);
            var kx:Number = 10;
            var ky:Number = 10;
            var kw:Number = w / (kx - 1);
            var kh:Number = h / (ky - 1);
            for (i = 0; i < ky; ++i) {
                for (j = 0; j < kx; ++j) {
                    var blocked:Boolean = (i == 0 && (j == 0 || j == kx - 1));
                    points.push({x: ox + j * kw, y: oy + i * kh, vx: 0, vy: 0, blocked: blocked, mouse: false});
                }
            }
            for (i = 0; i < ky; ++i) {
                for (j = 0; j < kx; ++j) {
                    if (i > 0) joints.push({a: points[i * kx + j], b: points[(i - 1) * kx + j], d: kh});
                    if (j > 0) joints.push({a: points[i * kx + j], b: points[i * kx + j - 1], d: kw});
                }
            }
        }
        public function drawBackground():void {
            backgroundSpr = new Sprite();
            with (backgroundSpr.graphics) {
                beginFill(0x000000);
                drawRect(0, 0, stage.stageWidth, stage.stageHeight);
                endFill();
            }
            addChild(backgroundSpr);
        }

    }
}