/**
 * Copyright y_tti ( http://wonderfl.net/user/y_tti )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iGvI
 */

package
{
        //クネクネしたもの。
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BevelFilter;
	import flash.geom.Point;
	
	[SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "0xFFFFFF")]
	public class TestSquare extends Sprite
	{
		private var _pt1:Point;
		private var _pt2:Point;
		private var _pt3:Point;
		private var _pt4:Point;
		private var _w:Number = 200;
		private var _h:Number = 200;
		private var _ptCtop:Point;
		private var _ptCbottom:Point;
		private var _canvas:Sprite;
		private var _angle:Number = 0;
		
		public function TestSquare()
		{
			_canvas = addChild(new Sprite()) as Sprite;
			
			_canvas.x = (stage.stageWidth - _w)/2;
			_canvas.y = (stage.stageHeight - _h)/2;
			
			_pt1 = new Point(0,0);
			_pt2 = new Point(_w,0);
			_pt3 = new Point(0,_h);
			_pt4 = new Point(_w,_h);
			_ptCtop = Point.interpolate(_pt1 , _pt2 , 0.5);
			_ptCbottom = Point.interpolate(_pt3 , _pt4 , 0.5);
			
			addEventListener(Event.ENTER_FRAME , _update );
		}
		
		private function _update(e:Event):void {
			//_angle += 1;
			_angle = (mouseX - stage.stageWidth/2)/5;
			var rad1:Number = _angle * Math.PI /180;
			var rad2:Number = (_angle +180) * Math.PI /180; 
			_pt1.x = Math.cos(rad1) * _w/2 + _ptCtop.x;
			_pt1.y = Math.sin(rad1) * _w/2 + _ptCtop.y; 
			_pt2.x = Math.cos(rad2) * _w/2 + _ptCtop.x;
			_pt2.y = Math.sin(rad2) * _w/2 + _ptCtop.y; 
			_pt3.x = Math.cos(-rad1) * _w/2 + _ptCbottom.x;
			_pt3.y = Math.sin(-rad1) * _w/2 + _ptCbottom.y; 
			_pt4.x = Math.cos(-rad2) * _w/2 + _ptCbottom.x;
			_pt4.y = Math.sin(-rad2) * _w/2 + _ptCbottom.y; 
			
			
			_draw(_angle);
		}
		
		private function _draw($angle:Number):void {
			_canvas.graphics.clear();
			_canvas.graphics.lineStyle(2,0xFF0000);
			_canvas.graphics.moveTo( _pt1.x , _pt1.y );
			_canvas.graphics.lineTo( _pt2.x , _pt2.y );
			_canvas.graphics.moveTo( _pt3.x , _pt3.y );
			_canvas.graphics.lineTo( _pt4.x , _pt4.y );
			
			var mid:Point;
			mid = Point.interpolate( _pt1 , _pt3 , 0.5 );
			mid.x += -_angle;
			
			_canvas.graphics.moveTo( _pt1.x , _pt1.y );
			//_canvas.graphics.curveTo( mid.x , mid.y , _pt3.x , _pt3.y );
			var i:Number;
			var p:Point;
			for(i = 0;i <= 1;i+=0.1 ){
				p = _quadraticBeziercurves(_pt1 , mid , _pt3 , i );
				_canvas.graphics.lineTo( p.x , p.y );
			}
			
			mid = Point.interpolate( _pt2 , _pt4 , 0.5 );
			mid.x += -_angle;
			_canvas.graphics.moveTo( _pt2.x , _pt2.y );
			//_canvas.graphics.curveTo( mid.x , mid.y , _pt4.x , _pt4.y );
			for(i = 0;i <= 1;i+=0.1 ){
				p = _quadraticBeziercurves(_pt2 , mid , _pt4 , i );
				_canvas.graphics.lineTo( p.x , p.y );
			}
		}
		
		private function _quadraticBeziercurves($p0:Point , $p1:Point , $p2:Point , $t:Number):Point {
			//http://en.wikipedia.org/wiki/B%C3%A9zier_curve
			// B(t) = (1-t)(1-t)P0 + 2(1-t)tP1 + ttP2 , 0<=t<=1
			var xP:Number = Math.pow((1-$t),2) * $p0.x + 2*(1-$t)*$t*$p1.x + $t*$t*$p2.x;
			var yP:Number = Math.pow((1-$t),2) * $p0.y + 2*(1-$t)*$t*$p1.y + $t*$t*$p2.y;
			return new Point(xP ,yP);
		}
	}
}