/**
 * Copyright yasu ( http://wonderfl.net/user/yasu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iGW3
 */

// forked from yasu's flash on 2010-6-2
// forked from clockmaker's [Alternativa3D] Basic Template
package {
	import alternativ5.engine3d.materials.FillMaterial;
	import alternativ5.engine3d.materials.DevMaterial;
	import alternativ5.engine3d.primitives.Box;
	import alternativ5.engine3d.events.MouseEvent3D
	import alternativ5.types.Point3D;
	import flash.display.Sprite;
	
	[SWF(width = 465, height = 465, frameRate = 60)]
	/**
	 * Alternativa3D を簡単に扱うためのベーシックテンプレート
	 * @author Yasu (clockmaker)
	 */
	/**
	 * Alternativa3D LookAtするプリミティブ
	 * papervision3dではおなじみですが・・・ Alternativa3DではControllerにしか見当たらないので、自作。
	　*
	 * @narutohyper
	 */
	 
	 
	 
	public class SimpleDemo extends Sprite {
		
		public function SimpleDemo():void {
			// テンプレートを作成します
			var template:BasicTemplate = new BasicTemplate();
			addChild(template);

			// プリミティブを作成します

				var box:lookAtBox = new lookAtBox(200, 200, 200);
				box.cloneMaterialToAllSurfaces(new FillMaterial(0x0000FF));
				box.setMaterialToSurface(new FillMaterial(0x990000),'top');
				box.coords=new Point3D(0,200,0);

				var cone:lookAtCone = new lookAtCone(200, 100,0,1,4);
				cone.setMaterialToSurface(new FillMaterial(0x990000),'bottom');
				cone.setMaterialToSurface(new FillMaterial(0xFF0000),'side');
				cone.coords=new Point3D(0,0,0);

			// 3Dシーンのルートに追加します
				template.scene.root.addChild(box);
				template.scene.root.addChild(cone);
			

			var angle:Number=0;			//外周りの箱の為の角度

			// Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
			// レンダリング前に実行したい処理を記述します。
			template.onPreRender = function():void {

				// 立方体を回転させます (角度はラジアン)
				angle++;
				var radian:Number= angle/180*Math.PI;
				var radian2:Number= angle/180*Math.PI*2;
				box.y=Math.sin(radian)*400
				box.x=Math.cos(radian2)*400
				box.z=Math.cos(radian)*400

				box.lookAt(cone)
				cone.lookAt(box)

				template.cameraContoller.lookAt(new Point3D());
			}
		}

	}
}


import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageQuality;
import flash.display.StageScaleMode;
import flash.events.Event;

import alternativ5.engine3d.controllers.CameraController;
import alternativ5.engine3d.core.Camera3D;
import alternativ5.engine3d.core.Object3D;
import alternativ5.engine3d.core.Scene3D;
import alternativ5.types.Point3D;
import alternativ5.types.Matrix3D;
import alternativ5.engine3d.display.View;

import alternativ5.engine3d.primitives.Box;
import alternativ5.engine3d.primitives.Cone;
import alternativ5.engine3d.events.MouseEvent3D
import alternativ5.engine3d.materials.DevMaterial;
import alternativ5.utils.MathUtils;

/**
 * 追記
 * lookAtするbox
 */
class lookAtBox extends Box{

	private var lookUtl:lookAtUtility;

	public function lookAtBox(width:Number = 100, length:Number = 100, height:Number = 100, widthSegments:uint = 1, lengthSegments:uint = 1, heightSegments:uint = 1, reverse:Boolean = false, triangulate:Boolean = false) {
		super(width, length, height, widthSegments, lengthSegments, heightSegments, reverse, triangulate);
		lookUtl=new lookAtUtility(this);

	}

	public function lookAt(targetObject:*, upAxis:Point3D=null ):void {
		lookUtl.lookAt(targetObject, this.getFaceById('top_0_0').normal)
	}

}




/* lookAtするCone */

class lookAtCone extends Cone{

	private var lookUtl:lookAtUtility;

 	public function lookAtCone(height:Number = 100, bottomRadius:Number = 100, topRadius:Number = 0, heightSegments:uint = 1, radialSegments:uint = 12, reverse:Boolean = false, triangulate:Boolean = false) {
		super(height,bottomRadius, topRadius, heightSegments, radialSegments, reverse, triangulate);
		lookUtl=new lookAtUtility(this);

	}

	public function lookAt(targetObject:*):void {
		lookUtl.lookAt(targetObject, this.getFaceById('bottom').normal)
	}

}




class lookAtUtility {

	private var thisObject:*
	public function lookAtUtility(mc:*) {
		thisObject=mc;
	}

	public function lookAt(targetObject:*, vAxis:Point3D=null ):void {

		var position :Point3D = thisObject.coords;
		var target	 :Point3D = targetObject.coords;

		var zAxis 	 :Point3D = Point3D.difference(target,position);
		zAxis.normalize();

		if (!vAxis) {
			vAxis=new Point3D(0,1,0)
		}

		if( modulo(zAxis) > 0.1 ) {
			var xAxis :Point3D = Point3D.cross(vAxis, zAxis);
			xAxis.normalize();
			var yAxis :Point3D = Point3D.cross( zAxis, xAxis);
			yAxis.normalize();

			var look	:Matrix3D = thisObject.transformation;

			var mtr:Matrix3D=new Matrix3D()
			mtr.rotate(MathUtils.toRadian(90),MathUtils.toRadian(90),MathUtils.toRadian(90))
			vAxis.transform(mtr)

			look.a =	xAxis.x * thisObject.scaleX*reverseCheck(vAxis.x);
			look.e =	xAxis.y * thisObject.scaleX*reverseCheck(vAxis.x);
			look.i =	xAxis.z * thisObject.scaleX*reverseCheck(vAxis.x);
			
			look.b =	yAxis.x * thisObject.scaleY*reverseCheck(vAxis.y);
			look.f =	yAxis.y * thisObject.scaleY*reverseCheck(vAxis.y);
			look.j =	yAxis.z * thisObject.scaleY*reverseCheck(vAxis.y);
			
			look.c =	zAxis.x * thisObject.scaleZ*reverseCheck(vAxis.z);
			look.g =	zAxis.y * thisObject.scaleZ*reverseCheck(vAxis.z);
			look.k =	zAxis.z * thisObject.scaleZ*reverseCheck(vAxis.z);

			var rotations:Point3D = look.getRotations();
			
			thisObject.rotationX = rotations.x;
			thisObject.rotationY = rotations.y;
			thisObject.rotationZ = rotations.z;

		}
	}


	private function modulo(target:Point3D):Number {
		return Math.sqrt( target.x*target.x + target.y*target.y + target.z*target.z );
	}

	private function reverseCheck(no:Number):Number {
		var result:Number=1;
		if (no<0) result=-1;
		return result;
	}


}






/**
 * BasicTemplate for Alternativa3D
 * Alternativa3Dを扱いやすくするためのテンプレートです
 * @author Yasu
 */
class BasicTemplate extends Sprite{
	/**
	 * シーンインスタンスです。
	 */
	public var scene:Scene3D;
	/**
	 * ビューインスタンスです。
	 */
	public var view:View;
	/**
	 * カメラインスタンスです。
	 */
	public var camera:Camera3D;
	/**
	 * カメラコントローラーです。
	 */
	public var cameraContoller:CameraController;
	
	private var _viewWidth:int;
	private var _viewHeight:int;
	private var _scaleToStage:Boolean;

	/**
	 * 新しい BasicTemplate インスタンスを作成します。
	 * @param	viewWidth
	 * @param	viewHeight
	 * @param	scaleToStage
	 */
	public function BasicTemplate(viewWidth:int=640, viewHeight:int=480, scaleToStage:Boolean = true) {
		_viewWidth = viewWidth;
		_viewHeight = viewHeight;
		_scaleToStage = scaleToStage;
		
		// Creating scene
		scene = new Scene3D();
		scene.splitAnalysis = false; // not analysis for performance
		scene.root = new Object3D();
		
		// Adding camera
		camera = new Camera3D();
		camera.z = -1000;
		scene.root.addChild(camera);
		
		// camera contoller
		cameraContoller = new CameraController(this);
		cameraContoller.camera = camera;
		
		// set view
		view = new View();
		view.camera = camera;
		addChild(view);
		
		// stage
		if (stage) init();
		else addEventListener(Event.ADDED_TO_STAGE, init);
	}
	
	/**
	 * 初期化されたときに実行されるイベントです。
	 * 初期化時に実行したい処理をオーバーライドして記述します。
	 */
	protected function atInit():void {}
	
	/**
	 * 初期化されたときに実行されるイベントです。
	 * 初期化時に実行したい処理を記述します。
	 */
	private var _onInit:Function = function():void { };
	public function get onInit():Function { return _onInit; }
	public function set onInit(value:Function):void {
		_onInit = value;
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング前に実行したい処理をオーバーライドして記述します。
	 */
	protected function atPreRender():void {}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング前に実行したい処理を記述します。
	 */
	private var _onPreRender:Function = function():void{};
	public function get onPreRender():Function { return _onPreRender; }
	public function set onPreRender(value:Function):void {
		_onPreRender = value;
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング後に実行したい処理をオーバーライドして記述します。
	 */
	protected function atPostRender():void {
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング後に実行したい処理を記述します。
	 */
	protected var _onPostRender:Function = function():void{};
	public function get onPostRender():Function { return _onPostRender; }
	public function set onPostRender(value:Function):void {
		_onPostRender = value;
	}
	
	/**
	 * レンダリングを開始します。
	 */
	public function startRendering():void {
		addEventListener(Event.ENTER_FRAME, onRenderTick);
	}
	/**
	 * レンダリングを停止します。
	 */
	public function stopRendering():void {
		removeEventListener(Event.ENTER_FRAME, onRenderTick);
	}
	
	/**
	 * シングルレンダリング(レンダリングを一回だけ)を実行します。
	 */
	public function singleRender():void {
		onRenderTick();
	}
	
	/**
	 * @private
	 */
	private function init(e:Event = null):void {
		stage.scaleMode = StageScaleMode.NO_SCALE;
		stage.align = StageAlign.TOP_LEFT;
		stage.quality = StageQuality.HIGH;

		// resize
		stage.addEventListener(Event.RESIZE, onResize);
		onResize(null);
		
		// render
		startRendering();
		
		atInit();
		_onInit();
		
	}
	
	/**
	 * @private
	 */
	private function onRenderTick(e:Event = null):void {
		atPostRender();
		_onPostRender();
		scene.calculate();
		atPreRender();
		_onPreRender();
	}
	
	/**
	 * @private
	 */
	private function onResize(event:Event = null):void {
		if (_scaleToStage) {
			view.width = stage.stageWidth;
			view.height = stage.stageHeight;
		}else {
			view.width = _viewWidth;
			view.height = _viewHeight;
		}
	}
}
