/**
 * Copyright mikako ( http://wonderfl.net/user/mikako )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iFo1
 */

// forked from yuuganisakase's Rain Drop
package 
{
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.display.BlendMode;

	[SWF(width=465, height=465, frameRate=30, backgroundColor=0xffffff)]
	public class Drop extends Sprite 
	{
		private var shapes:Vector.<AbstractRain> = new Vector.<AbstractRain>();
		private var back:Shape;
		private var clickCount:int = 0;
		public function Drop():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			stage.quality = StageQuality.BEST;
			back = new Shape();
			back.graphics.beginFill(0xffffff);
			back.graphics.drawRect(0, 0, Wid, Hei);
			addChild(back);
			for (var i:int = 0; i < 15; i++) 
			{
				var s:RainCircle = new RainCircle();
				s.x = Math.random() * (Wid-s.width);
				s.y = Math.random() * (Hei-s.height);
				addChild(s);
				shapes.push(s);
			}
			for (var j:int = 0; j < 13; j++) 
			{
				var d:RainDrop = new RainDrop();
				d.x = Math.random() * Wid;
				d.y = Math.random() * Hei;
				shapes.push(d);
				addChild(d);
				
			}
			stage.quality = StageQuality.LOW;
			addEventListener(Event.ENTER_FRAME, onEnter);
			stage.addEventListener(MouseEvent.CLICK, onClick);
		}
		
		private function onClick(e:MouseEvent):void 
		{
			clickCount += 1;
			back.graphics.clear();
			if (clickCount % 2 == 1) {
				back.graphics.beginFill(0x000000);
			}else {
				back.graphics.beginFill(0xffffff);
			}
			back.graphics.drawRect(0, 0, Wid, Hei);
			
			for each(var a:AbstractRain in shapes)
			{
				if(a is RainDrop){
					if (a.blendMode == BlendMode.DIFFERENCE)
					{
                                                //a.blendMode = (clickCount % 2 == 1)? BlendMode.SUBTRACT:BlendMode.ADD;
					}else if(a.blendMode == BlendMode.ADD){
						a.blendMode = BlendMode.SUBTRACT;
					}else{
                                                a.blendMode = BlendMode.ADD;
                                        }
				}
			}
		}
		
		private function onEnter(e:Event):void 
		{
			for each(var s:AbstractRain in shapes)
			{
				s.update();
			}
		}
	}	
}

const Wid:int = 465;
const Hei:int = 465;


import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.BlendMode;
import flash.display.Shape;
import flash.geom.Matrix;
import flash.geom.Point;
class AbstractRain extends Bitmap
{
	internal var bd:BitmapData;
	internal var speed:Point;

	public function update():void {
		
	}
	
}
class RainDrop extends AbstractRain
{
	public function RainDrop()
	{
		speed = new Point((Math.random()-0.5), 1.5 + Math.random()*3 );

		var sh:Shape = new Shape();
		
		const Size:int = 5+Math.random()*20;
		
		var color:uint = 0xffffff;
		
		this.blendMode = (Math.random() > 0.5)? BlendMode.DIFFERENCE: BlendMode.ADD;
		

		sh.graphics.beginFill(color);
		
		sh.graphics.moveTo(0, -Size*2.1);
		sh.graphics.curveTo(Size / 1.7, -Size / 3,  Size / 2, 0 );
		sh.graphics.curveTo( 0, Size/1.0,            -Size / 2, 0);
		sh.graphics.curveTo( -Size / 1.7, -Size / 3,    0, -Size * 2.1);
		
		bd = new BitmapData(sh.width, sh.height*2,true, 0x00000000);
		bd.draw(sh, new Matrix(1, 0, 0, 1, sh.width/2, sh.height),null, null, null, true);
		this.bitmapData = bd;
		sh.graphics.clear();
	}
	override public function update():void
	{
		this.x += speed.x;
		this.y += speed.y;
		if (this.y > Hei + this.height) this.y = -this.height;
		if (this.x > Wid + this.width) this.x = -this.width;
		if (this.x < -this.width) this.x = Wid + this.width;
	}
}
class RainCircle extends AbstractRain
{
	public function RainCircle()
	{
		super();
		const Num:int = int(Math.random() * 6) + 3;
		const NormalSize:Number = Num * 1 + Math.random() * 4.5 *Num;
		speed = new Point(1*(Math.random()-0.5), 1.5*(Math.random() - 0.5));
		
		this.blendMode = BlendMode.DIFFERENCE;
		var sh:Shape = new Shape();
		for (var i:int = Num; i > 0; i--) 
		{
			if ( (i % 2) == 1) sh.graphics.beginFill(0xffffff);
			else sh.graphics.beginFill(0x000000);
			sh.graphics.drawCircle(0, 0, (Math.sqrt(i) * (1 + Math.random() * 0.1) * NormalSize*(1+Math.random()*0.0) ));
		}
		
		bd = new BitmapData(sh.width, sh.height, true, 0x00000000);
		bd.draw(sh, new Matrix(1, 0, 0, 1, sh.width/2, sh.height/2),null, null, null, true);
		this.bitmapData = bd;
		sh.graphics.clear();
		
	}

	override public function update():void
	{
		this.x += speed.x;
		this.y += speed.y;
		if (this.y > Hei - this.height) speed.y *= -1; this.y += speed.y
		if (this.y < 0) speed.y *= -1; this.y += speed.y;

		if (this.x > Wid - this.width) speed.x *= -1; this.x += speed.x;
		if (this.x < 0) speed.x *= -1; this.x += speed.x;
		
		
		
	}
}
