/**
 * Copyright demouth ( http://wonderfl.net/user/demouth )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iFHU
 */

// forked from demouth's Wonderfl
package {
	import flash.display.DisplayObject;
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.text.TextField;
	import flash.utils.Timer;
	import frocessing.geom.FVector;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.Cubic;
	import org.libspark.betweenas3.easing.Quart;
	import org.libspark.betweenas3.tweens.IObjectTween;
	import org.libspark.betweenas3.tweens.ITween;
	import org.libspark.betweenas3.tweens.ITweenGroup;
    import flash.display.Sprite;
    import net.wonderfl.widget.Wanco;
    public class FlashTest extends Sprite {
		private var timer:Timer = new Timer(500, 0);
		private var flg:Boolean = false;
		private var shiri:Sprite;
    		[SWF(backgroundColor = "0xFFFFFF", frameRate = "60")]
        public function FlashTest() {
			var obj:Array = this.create(["W", "o", "n", "d", "e", "r", "f", "l","","unko",""]);
			var tweens:ITweenGroup = BetweenAS3.serialTweens(obj);
			tweens.stopOnComplete = false;
			tweens.play();
			
			this.timer.addEventListener(TimerEvent.TIMER, timerHandler);
			this.timer.start();
			
			this.shiri = this.addChild(this.createShiri()) as Sprite;
			
			this.addEventListener(Event.ENTER_FRAME , enterFrameHandler);
            
        }
		
		private function timerHandler(e:TimerEvent):void 
		{
			this.flg = !this.flg;
		}
		
		private function enterFrameHandler(event:Event):void
		{
			if (this.flg)
			{
				this.shiri.x = Math.random() * 10 - 5 + this.stage.stageWidth / 2;
				this.shiri.y = Math.random() * 10 - 5;
			}
		}
		
		private function create(str:Array):Array
		{
			var retArray:Array = [];
			str.forEach(function(element:*, index:int, arr:Array):void {
				retArray.push(createTween(addChild(createDisplayObject(element))));
			});
			return retArray;
		}
		
		private function createTween(obj:DisplayObject):ITween
		{
			var w:Number = this.stage.stageWidth / 2;
			return BetweenAS3.tween(obj,{x:w,y:300,alpha:0,scaleX:10,scaleY:10,_blurFilter:{blurX:8,blurY:8}},{x:w,y:100,alpha:1,scaleX:1,scaleY:1,_blurFilter:{blurX:0,blurY:0}},1,Quart.easeInOut);
		}
		
		private function createDisplayObject(str:String):DisplayObject
		{
			var s:Sprite = new Sprite();
			if(str=="unko")
			{
				var wanco:Wanco = new Wanco();
				s.addChild(wanco);
				wanco.scaleX = wanco.scaleY = 0.2;
			}
			else
			{
				var t:TextField = new TextField();
				t.htmlText = "<font size='20' color='#FFD700'>"+str+"</font>";
				s.addChild(t);
				t.x = - t.textWidth / 2;
				t.y = - t.textHeight / 2;
			}
			return s;
		}
		
		private function createShiri():Sprite
		{
			var s:Sprite = new Sprite();
			s.x = this.stage.stageWidth / 2;
			var g:Graphics = s.graphics;
			g.lineStyle(5,0xCD853F);
			g.beginFill(0xFFE4C4);
			g.moveTo( -250, -10);
			g.curveTo(-150,200, 0, 120);
			g.curveTo( 150,200, 250, -10);
			return s;
		}
    }
}