/**
 * Copyright potix2 ( http://wonderfl.net/user/potix2 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iFFt
 */

// forked from tail_y's Math.absとMath.min Math.maxは何のためにあるの？
// forked from tail_y's forked from: [最適化 Tips] Number, int, uint の計算による処理速度の違い
// forked from muta244's [最適化 Tips] Number, int, uint の計算による処理速度の違い
// min,max,absみたいな関数はマクロで実装できればいいのにと思う
package {

import flash.display.*;
import flash.geom.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;

public class Main extends Sprite
{
    static private const _NUM_TIMES:int = 1000000;
    
    private function _init():void
    {
        _debug(
            "各テスト " + _NUM_TIMES + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n"
        );
        
        
        _measure("ループのみ", function ():void
        {
            var n1:Number = Math.random()*10 - 5;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                
            }
        });
        
        _measure("ループ+関数呼び出し", function ():void
        {
            var n1:Number = Math.random()*10 - 5;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                nullFunc(n1);
            }
        });
        
        _measure("n2 = Math.abs(n1);", function ():void
        {
            var n1:Number = Math.random()*10 - 5;
            var n2:Number;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                n2 = Math.abs(n1);
            }
        });
        
        _measure("n2 = (0 < n1) ? n1 : -n1;", function ():void
        {
            var n1:Number = Math.random()*10 - 5;
            var n2:Number;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                n2 = (0 < n1) ? n1 : -n1;
            }
        });
        
        _measure("n3 = Math.max(n1, n2);", function ():void
        {
            var n1:Number = Math.random()*10 - 5;
            var n2:Number = Math.random()*10 - 5;
            var n3:Number;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                n3 = Math.max(n1, n2);
            }
        });
        
        _measure("n3 = (n2 < n1) ? n1 : n2;", function ():void
        {
            var n1:Number = Math.random()*10 - 5;
            var n2:Number = Math.random()*10 - 5;
            var n3:Number;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                n3 = (n2 < n1) ? n1 : n2;
            }
        });
        
        _debug("\n関数呼び出しによるオーバーヘッドは大きいという結果。");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        _field.multiline = true;
        _field.wordWrap = true;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
    
    private function nullFunc(n:Number):void {}
}

}
