/**
 * Copyright tsu_droid ( http://wonderfl.net/user/tsu_droid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iDav
 */

// forked from Ludd's forked from: forked from: forked from: Fire
// forked from C0wmAn76's forked from: forked from: Fire
// forked from hacker_ciaxk5up's forked from: Fire
// forked from Saqoosha's Fire
package {
    
    import flash.display.*;
    import flash.events.*
    import flash.filters.*;
    import flash.geom.*;
    import flash.system.LoaderContext;
    import flash.net.*;
    import flash.text.*;
    
    [SWF(width=640, height=480, backgroundColor=0x0, frameRate=30)]

    public class Fire extends Sprite {
        
        private static const ZERO_POINT:Point = new Point();
        
        private var _fireColor:BitmapData;
        private var _currentFireColor:int;
        
        private var _canvas:Sprite;
        private var _grey:BitmapData;
        private var _spread:ConvolutionFilter;
        private var _cooling:BitmapData;
        private var _color:ColorMatrixFilter;
        private var _offset:Array;
        private var _fire:BitmapData;
        private var _palette:Array;
        private var _zeroArray:Array;
        
        public function Fire() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.quality = StageQuality.LOW;
            
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, _onLoaded);
            loader.load(new URLRequest('http://qzone.net.cn/293299/ziti.png'), new LoaderContext(true));
        }
        
        private function _onLoaded(e:Event):void {
            _fireColor = Bitmap(LoaderInfo(e.target).loader.content).bitmapData;
            
            _canvas = new Sprite();
            _canvas.graphics.beginFill(0x0, 0);
            _canvas.graphics.drawRect(0, 0, 465, 465);
            _canvas.graphics.endFill();
            _canvas.addChild(_createEmitter());
            
            _grey = new BitmapData(465, 465, false, 0x0);
            _spread = new ConvolutionFilter(3, 3, [0, 1, 0,  1, 1, 1,  0, 1, 0], 5);
            _cooling = new BitmapData(465, 465, false, 0x0);
            _offset = [new Point(), new Point()];
            _fire = new BitmapData(465, 465, false, 0x0);
            addChild(new Bitmap(_fire));
            
            _createCooling(0.18);
            _createPalette(_currentFireColor = 0);
            
            addEventListener(Event.ENTER_FRAME, _update);
            stage.addEventListener(MouseEvent.CLICK, _onClick);
        }
        
        private function _onClick(e:MouseEvent):void {
            if (++_currentFireColor == int(_fireColor.height / 32)) {
                _currentFireColor = 0;
            }
            _createPalette(_currentFireColor);
        }
        
        private function _createEmitter():DisplayObject {
            var tf:TextField = new TextField();
            tf.selectable = false;
            tf.autoSize = TextFieldAutoSize.CENTER;
            tf.defaultTextFormat = new TextFormat('HG丸ｺﾞｼｯｸM-PRO', 80, 0xffffff, true);
            tf.text = '恋の季節';
            tf.x = (465 - tf.width) / 2 + 80/2;
            tf.y = (465 - tf.height) / 2;
            return tf;
        }
        
        private function _createCooling(a:Number):void {
            _color = new ColorMatrixFilter([
                a, 0, 0, 0, 0,
                0, a, 0, 0, 0,
                0, 0, a, 0, 0,
                0, 0, 0, 1, 0
            ]);
        }
        
        private function _createPalette(idx:int):void {
            _palette = [];
            _zeroArray = [];
            for (var i:int = 0; i < 256; i++) {
                _palette.push(_fireColor.getPixel(i, idx * 32));
                _zeroArray.push(0);
            }
        }
        
        private function _update(e:Event):void {
            _grey.draw(_canvas);
            _grey.applyFilter(_grey, _grey.rect, ZERO_POINT, _spread);
            _cooling.perlinNoise(50, 50, 2, 982374, false, false, 0, true, _offset);
            _offset[0].x += 2.0;
            _offset[1].y += 2.0;
            _cooling.applyFilter(_cooling, _cooling.rect, ZERO_POINT, _color);
            _grey.draw(_cooling, null, null, BlendMode.SUBTRACT);
            _grey.scroll(0, -3);
            _fire.paletteMap(_grey, _grey.rect, ZERO_POINT, _palette, _zeroArray, _zeroArray, _zeroArray);
        }
    }
}