/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iDLA
 */

// forked from christian's PAN # 1
package
{
    import flash.events.*;
    import flash.net.URLRequest;
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.filters.BevelFilter;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundTransform;
    import flash.media.SoundLoaderContext;


    public class PAN_1 extends Sprite
    {
        private var URL : String = 'http://mm4d.free.fr/tracks/breaks/sample_a.mp3';

        private var W : Number, H : Number;

        private var trans : SoundTransform;
        private var chans : SoundChannel;
        private var sound : Sound;

        //

        private var controller : Sprite;

        private var output : TextField;


        public function PAN_1 ()
        {
            Wonderfl.disable_capture ();

            stage ? init () : addEventListener (Event.ADDED_TO_STAGE, init);
        }

        private function init (e : Event = null) : void
        {
            if (hasEventListener (Event.ADDED_TO_STAGE))
            {
                removeEventListener (Event.ADDED_TO_STAGE, init);
            }

            H = stage.stageHeight / 2;
            W = stage.stageWidth  / 2;
            
            //
            
            addChild (output = new TextField ());
            output.autoSize = 'left';

            addChild (controller = new Sprite ());
            controller.graphics.lineStyle (1, 0x333333, 1);
            controller.graphics.beginFill (0x666666, 1);
            controller.graphics.drawCircle (0, 0, 10);
            controller.filters = [new BevelFilter ()];
            controller.buttonMode = true;
            controller.x = W;
            controller.y = H;

            controller.addEventListener (MouseEvent.MOUSE_DOWN, onDrag);
            controller.addEventListener (MouseEvent.MOUSE_UP  , onDrag);

            //

            sound = new Sound ();

            sound.addEventListener
            (
                Event.COMPLETE, setPlay
            );
            sound.addEventListener
            (
                IOErrorEvent.IO_ERROR, onIOError
            );
            sound.addEventListener
            (
                SecurityErrorEvent.SECURITY_ERROR, onSecurityError
            );

            sound.load (new URLRequest (URL), new SoundLoaderContext (1000, false));

            //

            chans = new SoundChannel ();

            trans = new SoundTransform (1, 0);
        }

        private function setPlay (e : Event) : void
        {
            chans = sound.play (0, 1000);

            setChannels ();

            stage.addEventListener (Event.ENTER_FRAME, setPanning);
        }

        private function setPanning (e : Event) : void
        {
            graphics.clear ()
            graphics.lineStyle (1, 0x333333);
            graphics.moveTo (W, H);
            graphics.lineTo (controller.x, controller.y);
            
            //

            var L : Number = 1 - Math.abs ((controller.x - W) / W);
            var R : Number = 1 - Math.abs ((controller.y - H) / H);

            setChannels (L, L, R, R);

            //

            output.text = 'PAN IN LL / LR  |  ' + L.toFixed (2) + '  | RR / RL  |  ' + R.toFixed (2);
        }

        private function setChannels
        (
            LTL : Number = 1, LTR : Number = 0, RTR : Number = 1, RTL : Number = 0
        ) : void
        {
            trans.leftToLeft   = LTL;
            trans.leftToRight  = LTR;
            trans.rightToRight = RTR;
            trans.rightToLeft  = RTL;

            chans.soundTransform = trans;
        }

        // --o ERROR HANDLING

        private function onIOError (e : IOErrorEvent) : void {}

        private function onSecurityError (e : SecurityErrorEvent) : void {}

        //

        private function onDrag (e : MouseEvent) : void
        {
            controller[(e.type == 'mouseUp' ? 'stopDrag' : 'startDrag')]();
        }
    }
}
    /*
    SOUND (LENGTH 13'') IS
    LEFT  CHANNEL SAMPLED FROM _ AKUFEN : LATE NIGHT MUNCHIES
    RIGHT CHANNEL SAMPLED FROM _ WAREIKA : KING'S CHILD
    */
