/**
 * Copyright makc3d ( http://wonderfl.net/user/makc3d )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iBpX
 */

package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Shader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.ShaderFilter;
	import flash.utils.ByteArray;
	import flash.utils.Endian;
	public class Mandelbrot extends Sprite {
		public function Mandelbrot () {
			// create kernel
			// for kernel source see http://pastebin.com/qbqcrHb9
			var a:Array = [-23295,0,164,2560,19809,28260,25964,25202,28532,-24564,28257,28005,29552,24931,25856,25976,28773,29289,28005,28276,24940,160,3190,25966,25711,29184,28001,27491,160,2166,25970,29545,28526,1,161,258,0,3167,20341,29763,28527,29284,163,4,29554,25344,-24318,1025,15,25715,29696,7424,49,0,4096,12290,241,0,-20480,7427,243,512,6912,12802,32,16544,0,12802,16,16128,0,7428,128,768,16384,516,128,512,-16384,7426,16,512,-32768,770,16,1024,0,7426,128,512,-16384,12802,32,16544,0,12802,16,16128,0,7428,128,768,-32768,516,128,512,-16384,7426,16,512,-32768,770,16,1024,0,7426,64,512,-16384,7426,49,512,4096,12802,128,17384,-32768,12802,64,17384,-32768,12804,32,16230,26214,7428,16,512,0,772,16,1024,-32768,7428,32,0,-32768,516,32,1024,-16384,12804,16,15948,-13107,7429,128,512,0,773,128,1024,-16384,1028,16,1280,0,772,16,1024,-32768,7428,128,1024,-16384,12804,32,16128,0,7428,16,512,16384,772,16,1024,-32768,7428,32,0,-16384,516,32,1024,-16384,12804,16,15948,-13107,7429,128,512,16384,773,128,1024,-16384,1028,16,1280,0,772,16,1024,-32768,7428,64,1024,-16384,7428,49,1024,4096,7428,128,512,-32768,772,128,512,-32768,7428,64,1024,0,7428,128,512,-16384,772,128,512,-16384,7429,128,1024,0,12804,128,16384,0,7429,64,1024,0,773,64,512,-32768,7428,128,1280,16384,772,128,512,-16384,7429,64,1024,0,7428,128,1024,16384,516,128,1280,0,7429,32,1024,0,261,32,1024,-32768,7426,32,1280,-32768,7428,128,1280,16384,260,128,1024,-16384,7426,16,1024,0,7428,128,1024,16384,260,128,1280,0,12805,32,16512,0,10757,32,1024,0,7425,-32640,128,0,12804,128,0,0,12805,32,16256,0,13061,16,384,0,1024,0,1280,-32768,7430,128,1280,-16384,12804,128,15948,-13107,7429,32,1024,0,773,32,512,-32768,12804,128,16128,0,7429,16,1280,-32768,261,16,1024,0,7430,64,1280,-16384,12804,128,15948,-13107,7429,32,1024,0,773,32,512,-16384,12804,128,16128,0,7429,16,1280,-32768,261,16,1024,0,7430,32,1280,-16384,12804,128,16256,0,7430,16,1024,0,7425,243,1536,6912];
			var b:ByteArray = new ByteArray; b.endian = Endian.BIG_ENDIAN; for (var i:int = 0; i < a.length; i++) b.writeShort (a [i]); b.position = 0; 0;
			k = new ShaderFilter (new Shader (b));

			// create bitmap
			this.b = new BitmapData (465, 465, false); addChild (new Bitmap (this.b));

			// go
			addEventListener (Event.ENTER_FRAME, loop);
		}
		private var k:ShaderFilter;
		private var b:BitmapData;
		private function loop (e:Event):void {
			b.fillRect (b.rect, 0xFF7F7F);
			var i:int, n:int = 17 * mouseX / b.width;
			for (i = 0; i < n; i++)
				b.applyFilter (b, b.rect, b.rect.topLeft, k);
		}
	}
}