/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iBij
 */

// forked from ProjectNya's LightCircle [Sprite版]
////////////////////////////////////////////////////////////////////////////////
// LightCircle [Sprite版]
//
// [AS3.0] LightCircleクラスだ！ (2)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1153
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.geom.Rectangle;
    import flash.events.MouseEvent;
    import net.hires.debug.Stats;

    [SWF(backgroundColor="#FF9900", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var light:LightCircle;

        public function Main() {
            init();
            addChild(new Stats());
        }

        private function init():void {
            graphics.beginFill(0xffffff);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            var rect:Rectangle = new Rectangle(0, 0, 465, 465);
            var colors:Array = new Array();
            colors.push({h: 270, s: 0.6, v: 1});
            colors.push({h: 300, s: 0.8, v: 1});
            colors.push({h: 0, s: 0.8, v: 1});
            colors.push({h: 60, s: 1, v: 1});
            colors.push({h: 76, s: 0.8, v: 1});
            colors.push({h: 90, s: 1, v: 1});
            colors.push({h: 100, s: 1, v: 0.8});
            colors.push({h: 180, s: 1, v: 1});
            colors.push({h: 200, s: 1, v: 1});
            colors.push({h: 220, s: 1, v: 1});
            light = new LightCircle(rect, colors);
            addChild(light);
            light.start();
        }

    }

}


//////////////////////////////////////////////////
// LightCircleクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Rectangle;
import flash.display.BlendMode;
import frocessing.color.ColorHSV;

class LightCircle extends Sprite {
    private var rect:Rectangle;
    private var colors:Array;
    private var circles:uint;
    private var circleList:Array;

    public function LightCircle(r:Rectangle, c:Array) {
        rect = r;
        colors = c;
        circles = colors.length;
        init();
    }

    private function init():void {
        circleList = new Array();
        for (var n:uint = 0; n < circles; n++) {
            var hue:uint = colors[n].h;
            var saturation:Number = colors[n].s;
            var value:Number = colors[n].v;
            var color:ColorHSV = new ColorHSV(hue, saturation, value);
            var circle:Circle = new Circle(100);
            circle.color = color.value;
            circle.blendMode = BlendMode.ADD;
            circleList.push(circle);
        }
        create();
    }
    private function create():void {
        for (var n:uint = 0; n < circles; n++) {
            var circle:Circle = circleList[n];
            circle.x = Math.random()*rect.width;
            circle.y = Math.random()*rect.height;
            circle.vx = Math.random()*8 - 4;
            circle.vy = Math.random()*8 - 4;
            addChild(circle);
        }
    }
    public function start():void {
        addEventListener(Event.ENTER_FRAME, move, false, 0, true);
    }
    public function stop():void {
        removeEventListener(Event.ENTER_FRAME, move);
    }
    private function move(evt:Event):void {
        for (var n:uint = 0; n < circles; n++) {
            var circle:Circle = circleList[n];
            if (circle.x < rect.left || circle.x > rect.right) circle.vx = - circle.vx;
            if (circle.y < rect.top || circle.y > rect.bottom) circle.vy = - circle.vy;
            circle.x += circle.vx;
            circle.y += circle.vy;
        }
    }


}


//////////////////////////////////////////////////
// Circleクラス
//////////////////////////////////////////////////

import flash.display.Shape;
import flash.filters.BlurFilter;

class Circle extends Shape {
    private var radius:uint = 100;
    private var rgb:uint = 0xFFFFFF;
    private var blur:BlurFilter
    public var vx:Number = 0;
    public var vy:Number = 0;

    public function Circle(r:uint) {
        radius = r;
        blur = new BlurFilter(radius*0.5, radius*0.5, 3);
        draw();
    }

    private function draw():void {
        graphics.clear();
        graphics.beginFill(rgb);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
        var blur:BlurFilter = new BlurFilter(50, 50, 3);
        filters = [blur];
    }
    public function set color(c:uint):void {
        rgb = c;
        draw();
    }

}
