/**
 * Copyright fakestar0826 ( http://wonderfl.net/user/fakestar0826 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iBNY
 */

// forked from clockmaker's [PV3D] Xmas Tree
package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.utils.getTimer;
    
    import org.papervision3d.core.effects.BitmapColorEffect;
    import org.papervision3d.core.geom.Pixels;
    import org.papervision3d.core.geom.renderables.Pixel3D;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.view.layer.BitmapEffectLayer;

    [SWF(width=465, height=465, frameRate=60)]
    public class Tree extends BasicView {
        private var level:int = 0;
        private var rot:Number = 0;
        private var treePixels:Pixels;
        private var canvas:BitmapData;
        private var mtx:Matrix;
        
        public static const WHITE:uint = 0xFFF0F0F0;
        public static const GREEN:uint = 0xFF008800;
        public static const RED:uint = 0xFFCC0000;
        public static const GOLD:uint = 0xFFFFCC66;
        public static const SILVER:uint = 0xFFCCCCCC;
        public static const COLORS:Array = [WHITE, GREEN, RED, GOLD, SILVER];
        
        /**
        * コンストラクタ
        */ 
        public function Tree() {
            stage.quality = StageQuality.MEDIUM;
            opaqueBackground = 0;
            
            var bfx:BitmapEffectLayer = new BitmapEffectLayer(viewport, stage.stageWidth, stage.stageHeight);
            bfx.addEffect(new BitmapColorEffect(1, 1, 1, 0.75));
            viewport.containerSprite.addLayer(bfx);

            treePixels = new Pixels(bfx);
            scene.addChild(treePixels);

            // tree
            drawTree(0, -1000, 0, 500, 90, GOLD);

            // snow
            for(var i:int=0; i< 300; i++){
                var pix:Pixel3D = new Pixel3D(0xFFFFFFFF,
                    10000 * (Math.random() - 0.5),
                    10000 * (Math.random() - 0.5),
                    10000 * (Math.random() - 0.5));
                treePixels.addPixel3D(pix);
            }
            
            // earth
            var p:Plane = new Plane(new WireframeMaterial(0x222222), 5000, 5000, 8, 8);
            p.rotationX = 90;
            p.y = -1000;
            scene.addChild(p);
            
            // kira kira
            canvas = new BitmapData(465 / 4, 465 / 4, false, 0x000000);
            var bmp:Bitmap = new Bitmap(canvas, PixelSnapping.NEVER, false);
            bmp.scaleX = bmp.scaleY = 4;
            bmp.smoothing = true;
            bmp.blendMode = BlendMode.ADD;
            addChild(bmp);
            
            mtx = new Matrix();
            mtx.scale(0.25, 0.25);

            // render
            startRendering();
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        /**
        * 再帰関数で木の枝を作っていく
        */
        private function drawTree(x:Number, y:Number, z:Number, length:Number, angle:Number, cf:int):void {
            level += 1;
            var destx:Number = x + length * Math.cos(angle * (Math.PI / 180));
            var desty:Number = y + length * Math.sin(angle * (Math.PI / 180));
            var destz:Number = z + length * (Math.random() - 0.5) * 2;

            if (Math.random() < 0.5)
                cf = COLORS[COLORS.length * Math.random() | 0];

            var max:int = 8 - level / 2;

            for (var i:int = 0; i < max; i++) {
                treePixels.addPixel3D(new Pixel3D(cf,
                    destx * i / max + x * (max - i) / max,
                    desty * i / max + y * (max - i) / max,
                    destz * i / max + z * (max - i) / max
                    ));
            }

            if (level < 7) {
                drawTree(destx, desty, destz, length * (1 + 3 * Math.random()) * 0.25, angle + 60 * (Math.random() - Math.random()), cf);
                drawTree(destx, desty, destz, length * (1 + 3 * Math.random()) * 0.25, angle + 60 * (Math.random() - Math.random()), cf);
                drawTree(destx, desty, destz, length * (1 + 3 * Math.random()) * 0.25, angle + 60 * (Math.random() - Math.random()), cf);
                drawTree(destx, desty, destz, length * (1 + 3 * Math.random()) * 0.25, angle + 60 * (Math.random() - Math.random()), cf);
            }
            level -= 1;
        }
        
        /**
        * エンターフレーム
        */ 
        private function loop(e:Event):void {
            // camera motion
            rot += (mouseX / stage.stageWidth * 3 * Math.PI - rot) * .1
            camera.x = Math.sin(rot) * 1500;
            camera.z = Math.cos(rot) * 1500;
            camera.y += (mouseY / stage.stageHeight * 3000 - 500 - camera.y) * .05;
            camera.fov = Math.sin(getTimer() / 2000) * 10 + 60;
            
            // kira kira
            canvas.fillRect(canvas.rect, 0x000000);
            canvas.draw(viewport, mtx);
        }
    }
}