/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iA1I
 */

package
{
	import flash.events.Event;
	import flash.events.MouseEvent;
	import org.papervision3d.core.effects.view.ReflectionView;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.special.CompositeMaterial;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.objects.primitives.Sphere;

	public class BallTest extends ReflectionView{
		private var balls:Vector.<Ball>;
		
		public function BallTest() {
			camera.y = 300; 
			var co:CompositeMaterial = new CompositeMaterial();
			co.addMaterial(new ColorMaterial(0xffffff, 0.5));
			var floor:Plane = new Plane(co, 2000, 2000, 12, 12);
			floor.pitch(-90);
			scene.addChild(floor);
			balls = new Vector.<Ball>();
			addBall();
			addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function update(e:Event):void {
			singleRender();
			for each(var p:Ball in balls) p.update();
		}
		
		private function addBall():void {
			var material:CompositeMaterial = new CompositeMaterial();
			material.addMaterial(new WireframeMaterial(0xffbbbb));
			material.addMaterial(new ColorMaterial(0xaaaaff, 0.5));
			var sp:Ball = new Ball(material, 100, 16, 16);
			sp.y = 500;
			scene.addChild(sp);
			balls.push(sp);
		}
	}
}
import org.papervision3d.core.proto.MaterialObject3D;
import org.papervision3d.objects.primitives.Sphere;
class Ball extends Sphere {
	private var vy:Number = 0;
	private var G:Number = 9.8;
	private var dt:Number = 0.05;
	private var radius:Number;
	
	public function Ball(m:MaterialObject3D, r:Number, a:int,b:int ):void {
		super(m, r, a, b);
		radius = r;
	}
	
	public function update():void {
		vy -= G * dt;
		y += vy;
		if (y < radius) {
			vy *= -1;
			y += radius - y;
		}
	}
}