/**
 * Copyright hankuro ( http://wonderfl.net/user/hankuro )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/i9Tr
 */

package {
    	import flash.display.Sprite;
    	import flash.events.*;
    	[SWF(width = 540, height = 400, backgroundColor = 0x000000)]
    	/*
    	 * 「初めてのActionScript3.0」(O'REILLY)の7章モーションにパーティクルシステムがあり、	 
    	 * これが2Dで実現されていたので、これをpapervision3dを使用し3Dに変えてみました。 	 
    	 */
    	 	public class Main extends Sprite{
    	 	    public var emitterX:Number = 0;
    	 	    public var emitterY:Number = 200;
    	 	    public var num:Number = 0;
    	 	    public function Main() {
    	 	        stage.addEventListener(Event.ENTER_FRAME, onLoop, false, 0, true);
    	 	    }
    	 	    private function onLoop(evt:Event):void {
    	 	        var p:Part = new Part(0,
    	 	        					  200,
    	 	        					  Math.random()*11,
    	 	        					  Math.random()*-20,
    	 	        					  num++ % 2,
    	 	        					  Math.random() * 0xFFFFFF);
    	 	       	addChild(p);
    	 	    }
    	 	}
}
		import flash.events.Event;
		import org.papervision3d.core.effects.view.ReflectionView;
		import org.papervision3d.objects.primitives.Sphere;
		import org.papervision3d.lights.PointLight3D;
		import org.papervision3d.materials.shadematerials.GouraudMaterial;
		class Part extends ReflectionView{
		    private var _xpos:Number;
		    private var _ypos:Number;
		    private var _xvel:Number;
		    private var _yvel:Number;
		    private var _grav:Number;
		    public var ball:Sphere;
		    private var pointLight:PointLight3D;
		    private var bounce:Number = -0.7;
		    
		    public function Part(xp:Number, yp:Number, xvel:Number, yvel:Number, grav:Number, col:uint) {
		        _xpos = xp;
		        _ypos = yp;
		        _xvel = xvel;
		        _yvel = yvel;
		        _grav = grav;
		        super(540,400,false, false);
		        surfaceHeight = -50;
		        camera.z = -400;
		        pointLight = new PointLight3D();
		        pointLight.x = -200;
		        pointLight.y = 200;
		        pointLight.z = -90;
		        scene.addChild(pointLight);
		        ball = new Sphere(new GouraudMaterial(pointLight, col, 0x000000), Math.random() * 20, 8, 6);
		        scene.addChild(ball);
		        ball.x = _xpos;
		        ball.y = _ypos;
		        ball.alpha = .08;
		        addEventListener(Event.ENTER_FRAME,onRun , false, 0, true);
		    }
		    private function onRun(evt:Event):void {
		        if(_grav == 0)_xpos += _xvel;
		        else _xpos -= _xvel;
		        _ypos += _yvel;
		        ball.x = _xpos;
		        ball.y = _ypos;
		        ball.z = _xpos;
		        singleRender();
		        if ( ball.z < -200 ||  ball.z > 300) {
		            removeEventListener(Event.ENTER_FRAME, onRun);
		            parent.removeChild(this);
		        }
		        if (_ypos < 0) {
		          ball.y = 0;
		          _yvel *= bounce;
		        }
		    }
		 } 