/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/i9EB
 */

// forked from _wonder's curveToを使って閉じた曲線を描く
package {
    import flash.display.Sprite;

    public class Multicurves extends Sprite {
        private var num:uint = 16;
        private var radius:Number = 100;
        private var rdm:Number = 10;
        private var points:Array = [];
        
        public function Multicurves() {
            init();
        }
        
        public function init():void {
        		for( var i:int = 0; i < num; i++){
            		var rad:Number = (i*360/num) * Math.PI / 180;
            		points[i] = new Object();
            		points[i].x = Math.sin( rad ) * radius + stage.stageWidth/2 + (Math.random() * rdm);
            		points[i].y = Math.cos( rad ) * radius + stage.stageHeight/2 + (Math.random() * rdm);
            }
        	    graphics.lineStyle(1, 0X0000ff);
        	    graphics.beginFill(0X0000ff);
        		
        		var xc1:Number = (points[0].x+points[num-1].x) / 2;
        		var yc1:Number = (points[0].y+points[num-1].y) / 2;
        		graphics.moveTo(xc1,yc1);
        		
        		for(var j:int = 0; j < num-1; j++){
        			var xc:Number = (points[j].x+points[j+1].x) / 2;
        			var yc:Number = (points[j].y+points[j+1].y) / 2;
        			graphics.curveTo(points[j].x, points[j].y, xc, yc);
        		}
        		
        		graphics.curveTo(points[j].x, points[j].y, xc1, yc1);
        }
    }
}