/**
 * Copyright nenjiru ( http://wonderfl.net/user/nenjiru )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/i7ud
 */

package 
{
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	
	/**
	 * OSX環境でテキストの上部がちょっと見切れるかもしれないテスト
	 */
	[SWF (backgroundColor = "0xFFFFFF", width = "465", height = "465", frameRate = "30")]
	public class TextFieldTest extends Sprite 
	{	
		private var _fonts:Array = [
			null,
			"",
			"MS ゴシック",
			"Helvetica",
			"_明朝",
			"_ゴシック",
			"_等幅",
			"_serif",
			"_sans",
			"_typewriter"
		];
		
		public function TextFieldTest():void 
		{
			var text:TextField;
			var font:TextField;
			var format:TextFormat;
			var fonttype:String;
			
			for (var i:int = 0; i < _fonts.length; i++) 
			{
				format = new TextFormat();
				
				text = new TextField();
				text.autoSize = TextFieldAutoSize.LEFT;
				font = new TextField();
				font.autoSize = TextFieldAutoSize.LEFT;
				font.defaultTextFormat = new TextFormat("_sans");
				
				if (_fonts[i] == null) {
					fonttype = "フォント指定なし";
				}
				else if (_fonts[i] == "") {
					format.font = "";
					text.defaultTextFormat = format;
					fonttype = "\"\" （空白を指定）";
				}
				else {
					format.font = _fonts[i];
					text.defaultTextFormat = format;
					fonttype = format.font;
				}
				
				text.text = "サンプル文字  SAMPLE";
				font.text = fonttype;
				
				text.x = 10;
				font.x = 165;
				if (i) text.y = font.y = i * 40 + 15;
				else text.y = font.y = 15;
				
				addChild(text);
				addChild(font);
			}
		}
	}
}