/**
 * Copyright pasodania ( http://wonderfl.net/user/pasodania )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/i7NO
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    public class Main extends Sprite {
        public function Main() {
            // write as3 code here..
            var txt:TextField = new TextField();
            txt.text = "Abstract Factory Pattern Test";
            
            var hunter:Hunter = new Hunter();
            var factory:Factory = new AttackerFactory(hunter);
            factory.setAll();
            
            
            txt.appendText("\n\n" + hunter.toString());
            
            factory = new GunnerFactory(hunter);
            factory.setAll();
            txt.appendText( "\n\n" + hunter.toString());
            
            addChild(txt);
            txt.width = txt.height = 500;
        }
    }
}

class Hunter{
    protected var _weapon:Weapon;
    public function set weapon(value:Weapon):void{
        _weapon = value;
    }
    public function get weapon():Weapon{
        return _weapon;
    }

    protected var _armor:Armor;
    public function set armor(value:Armor):void{
        _armor = value;
    }
    public function get armor():Armor{
        return _armor;
    }
    
    // Constructor
    public function Hunter(weapon:Weapon = null, armor:Armor = null){
        _weapon = weapon;
        _armor = armor;
    }
    
    public function toString():String{
        return "The Hunter wears: \n" + _weapon.toString() + "\n" + _armor.toString() + "\n";
    }   
}

// ======================Factory
// Abstract Class
class Factory{
    protected var _hunter:Hunter;
    
    // Constructor
    public function Factory(hunter:Hunter){
        _hunter = hunter;
    }
    
    public function setAll():void{
        this.setWeapon();
        this.setArmor();
    }
    
    protected function setWeapon():void{
        //Must be overridden in a subclass.
    }
    
    protected function setArmor():void{
        //Must be overridden in a subclass.
    }
}

class AttackerFactory extends Factory{
     // Constructor
     public function AttackerFactory(hunter:Hunter){
         super(hunter);
     }
     
     override protected function setWeapon():void{
         _hunter.weapon = new AttackerWeapon();
     }
     
     override protected function setArmor():void{
         _hunter.armor = new AttackerArmor();
     }
}

class GunnerFactory extends Factory{
     // Constructor
     public function GunnerFactory(hunter:Hunter){
         super(hunter);
     }
     
     override protected function setWeapon():void{
         _hunter.weapon = new GunnerWeapon();
     }
     
     override protected function setArmor():void{
         _hunter.armor = new GunnerArmor();
     }
}


// =================Product
// Abstract Class
class Weapon{
    
    // Constructor 
    public function Weapon(){}
    
    public function toString():String {
        return Object(this).constructor;
    }   
}

class AttackerWeapon extends Weapon{
    
    // Constructor
    public function AttackerWeapon (){
        super();
    }
    
    override public function toString():String{
        return super.toString() + ": weapon for attackers";
    }
}

class GunnerWeapon extends Weapon{
    
    // Constructor
    public function GunnerWeapon (){
        super();
    }
    
    override public function toString():String{
        return super.toString() + ": weapon for gunners";
    }
}

// Abstract Class
class Armor{
    
    // Constructor 
    public function Armor(){}
    
    public function toString():String {
        return Object(this).constructor;
    }   
}

class AttackerArmor extends Armor{
    // Constructor
    public function AttackerArmor(){
        super();
    }
    
    override public function toString():String{
        return super.toString() + ": armor for attackers";
    }
    
}

class GunnerArmor extends Armor{
    // Constructor
    public function GunnerArmor(){
        super();
    }
    
    override public function toString():String{
        return super.toString() + ": armor for gunners";
    }
    
}