/**
 * Copyright n0wri ( http://wonderfl.net/user/n0wri )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/i7BI
 */

package
{
	import flash.system.Security;
	import flash.external.ExternalInterface;
	import flash.display.StageAlign;
	import flash.events.Event;
	import flash.text.TextField;
	import flash.display.Sprite;

	public class URLUtil extends Sprite
	{
		public function URLUtil()
		{
			addEventListener(Event.ADDED_TO_STAGE, onInit);

		}

		private function onInit(event:Event):void
		{
			stage.align = StageAlign.TOP_LEFT;

			Security.allowDomain("*");
			URLUtils.init(loaderInfo);
			//
			var text:String="";
			text += "◆getURL\n";
			 text += URLUtils.getURL();
			 text += "\n\n";
			 text += "◆getSWFURL\n";
			 text += URLUtils.getSWFURL();
			 text += "\n\n";
			 text += "◆getURLDomain\n";
			 text += URLUtils.getURLDomain();
			 text += "\n\n";
			 text += "getSWFDomain\n";
			 text +=  URLUtils.getSWFDomain();
			 text += "\n\n";
			 text += "getFlashVarsObj\n";
			 text += URLUtils.getFlashVarsObj();
			 text += "\n\n";
			 text += '◆getURLQuery\n';
			 text += URLUtils.getURLQuery();
			 text += "\n\n";
			 text += '◆getURLQueryObj\n';
			 text += URLUtils.getURLQueryObj();
			 text += "\n\n";
			 text += '◆getSWFQuery\n';
			 text += URLUtils.getSWFQuery();
			 text += "\n\n";
			 text += '◆getURLHash\n';
			 text += URLUtils.getURLHash();
			addText(text);

		}

		private function addText(text:String, x:int=0, y:int=0):void
		{
			var textField:TextField=new TextField();
			textField.text = text;
			textField.width = stage.stageWidth;
			textField.height = stage.stageHeight;
			textField.multiline = true;
			textField.wordWrap = true;
			textField.x = x;
			textField.y = y;
			this.addChild(textField);
		}
	}
}
import flash.external.ExternalInterface;
import flash.net.LocalConnection;
import flash.display.LoaderInfo;

/***
 * URLUtils.init()でLoaderInfoを渡してから使います。
 * init()しなくてもLoaderInfo経由ではないメソッドであればそのまま使えます。
 * 
 */
class URLUtils
{
	// ---------------------------------------------------------------------------------------------------------------------------------------------
	// Public Properties
	// ---------------------------------------------------------------------------------------------------------------------------------------------


	// ---------------------------------------------------------------------------------------------------------------------------------------------
	// Internal Properties
	// ---------------------------------------------------------------------------------------------------------------------------------------------
	private static var _loaderInfo:LoaderInfo;
	private static const QUERY_STRING_PARSER:RegExp=/(?:^|&|;)([^&=;]*)=?([^&;]*)/g;

	// supports both ampersand and semicolon-delimted query string key/value pairs


	// ---------------------------------------------------------------------------------------------------------------------------------------------
	// Public Methods
	// ---------------------------------------------------------------------------------------------------------------------------------------------
	public static function init(loader_info:LoaderInfo):void
	{
		_loaderInfo = loader_info;
	}

	public static function getURL():String
	{
		return getJSStr("window.location.href");
	}

	public static function getSWFURL():String
	{
		if(_loaderInfo)
		{
			return _loaderInfo.url;
		}
		;

		try
		{
			throw new Error("URLUtil is not initialized yet. call URLUtil.init() first.");
		}
		catch(error:Error)
		{
			trace(error);
		}
		;
		return "";
	}

	public static function getURLDomain():String
	{
		return getJSStr("window.location.hostName");
	}

	public static function getSWFDomain():String
	{
		return new LocalConnection().domain;
	}

	public static function getFlashVarsObj():Object
	{
		if(_loaderInfo)
		{
			return _loaderInfo.parameters.flashvars;
		}
		;

		try
		{
			throw new Error("URLUtil is not initialized yet. call URLUtil.init() first.");
		}
		catch(error:Error)
		{
			trace(error);
		}
		;
		return null;
	}

	public static function getURLQuery():String
	{
		return getJSStr("window.location.search");
	}

	public static function getURLQueryObj():Object
	{
		var obj:Object={};
		if(!getURLQuery())
		{
			return null;
		}
		;
		getURLQuery().substr(1).replace(QUERY_STRING_PARSER, function($0:String, $1:String, $2:String, $3:String, $4:String):void
		{
			if($1)
			{
				obj[$1] = $2;
			}
			;
		});
		return obj;
	}

	public static function getSWFQuery():String
	{
		if(_loaderInfo)
		{
			return _loaderInfo.parameters.getquery;
		}
		;

		try
		{
			throw new Error("URLUtil is not initialized yet. call URLUtil.init() first.");
		}
		catch(error:Error)
		{
			trace(error);
		}
		;
		return "";
	}

	public static function getURLHash():String
	{
		return getJSStr("window.location.hash");
	}

	// getter setter
	static public function get loaderInfo():LoaderInfo
	{
		return _loaderInfo;
	}

	// ---------------------------------------------------------------------------------------------------------------------------------------------
	// Internal Methods
	// ---------------------------------------------------------------------------------------------------------------------------------------------


	// util
	private static function getJSStr(str:String):String
	{
		try
		{

			if(ExternalInterface.available)
			{
				return ExternalInterface.call("function(){ return " + str + "; }");
			}
			else
			{
				try
				{
					throw new Error("ExternalInterface is unavailable. then return empty String");
				}
				catch(error:Error)
				{
					return error + "";
				}
				;
			}
			;
		}
		catch(error:Error)
		{
			return error + "";
		}
		return "";
	}

}