/**
 * Copyright JZE ( http://wonderfl.net/user/JZE )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/i6OA
 */

package {
    import flash.filters.BlurFilter;
    import net.hires.debug.Stats;//
    import flash.geom.ColorTransform;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.Point;
    import flash.events.Event;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.KeyboardEvent;
    [SWF(width=500,height=500,backgroundColor=0,frameRate=50)]
    public class particlesmain extends Sprite {
        private var ps:Vector.<particle>;
        private var i:uint;
        private var curp:Point;
        private var c:BitmapData;
        private var bmp:Bitmap;
        private var btrans:ColorTransform;
        private var pxs:Vector.<uint>;
        private var down:Boolean;
        private var keys:Vector.<Boolean>;
        private var plen:uint;
        private var bfilt:BlurFilter;
        public function particlesmain() {
            keys = new Vector.<Boolean>(4, true);
            btrans = new ColorTransform(0.9, 0.9, 0.9, 1);
            bfilt = new BlurFilter(1.5, 1.5, 1);
            plen = 1000;
            c = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0);
            bmp = new Bitmap(c);
            addChild(bmp);
            addChild(new Stats());//
            ps = new Vector.<particle>(plen, true);
            for(i = 0; i < plen; i++) {
                ps[i] = new particle(Math.round(Math.random()*stage.stageWidth), Math.round(Math.random()*stage.stageHeight));
            }
            addEventListener(Event.ENTER_FRAME, cycle);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mdo);
            stage.addEventListener(MouseEvent.MOUSE_UP, mup);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, kdo);
            stage.addEventListener(KeyboardEvent.KEY_UP, kup);
        }
        private function mdo(e:MouseEvent):void {
            down = true;
        }
        private function mup(e:MouseEvent):void {
            down = false;
        }
        private function kdo(e:KeyboardEvent):void {
            e.keyCode < 41 && e.keyCode > 36 ? keys[e.keyCode-37] = true:0;
        }
        private function kup(e:KeyboardEvent):void {
            e.keyCode < 41 && e.keyCode > 36 ? keys[e.keyCode-37] = false:0;
        }
        private function cycle(e:Event):void {
            pxs = c.getVector(c.rect);
            i = plen;
            while(--i > -1) {
                curp = ps[i].move(stage.stageWidth, stage.stageHeight, new Point(mouseX, mouseY), down, keys);
                curp.y*stage.stageWidth+curp.x <= pxs.length-1 && curp.x >= 0 && curp.y >= 0 ? pxs[curp.y*stage.stageWidth+curp.x] |= ((curp.x-ps[i].x)*(curp.x-ps[i].x)+(curp.y-ps[i].y)*(curp.y-ps[i].y))/200*0xFFFFFF:0;
            }
            c.setVector(c.rect, pxs);
            c.colorTransform(c.rect, btrans);
            c.applyFilter(c, c.rect, new Point(0, 0), bfilt);
        }
    }
}
import flash.geom.Point;
class particle extends Point {
    private var xv:Number;
    private var yv:Number;
    private var prevx:int;
    private var prevy:int;
    private var angle:int;
    private var i:uint;
    public function particle(_x:int, _y:int):void {
        super(_x, _y);
        xv = yv = 0;
    }
    public function move(w:int, h:int, m:Point, d:Boolean, k:Vector.<Boolean>):Point {
        xv *= 0.99;
        yv *= 0.99;
        prevx = x;
        prevy = y;
        if(d) {
            angle = Math.atan2(m.y-y, m.x-x);
            xv += Math.cos(angle);
            yv += Math.sin(angle);
        }
        for(i = 0; i < 4; i++) {
            if(k[i]) {
                switch(i) {
                    case 0:xv--;break;
                    case 1:yv--;break;
                    case 2:xv++;break;
                    case 3:yv++;break;
                }
            }
        }
        x += xv+Math.random()*4-2;
        y += yv+Math.random()*4-2;
        if(x > w) {
            xv = ~xv+1;
            x = w-1;
        }
        else if(x < 0) {
            xv = ~xv+1;
            x = 1;
        }
        if(y > h) {
            yv = ~yv+1;
            y = h-1;
        }
        else if(y < 0) {
            yv = ~yv+1;
            y = 1;
        }
        xv > 7 ? xv = 7:0;
        yv > 7 ? yv = 7:0;
        return new Point(prevx, prevy);
    }
}