/**
 * Copyright fishKing ( http://wonderfl.net/user/fishKing )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/i67a
 */

// forked from hiro_rec's flash on 2009-6-14
package
{
	import __AS3__.vec.Vector;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.AsyncErrorEvent;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.NetStatusEvent;
	import flash.events.SecurityErrorEvent;
	import flash.media.Video;
	import flash.net.NetConnection;
	import flash.net.NetStream;
	import flash.system.Security;
	
	
	[SWF (width="640", height="480", backgroundColor='#000000', frameRate=30)]
	
	public class GridMovie01 extends Sprite
	{
		private static const VIDEO_URL:String = "http://start-rec.net/circleside/data/flash-sample/sample071029/logica-sample071029.flv";
		
		private var colMax:int = 1;
		private var rowMax:int = 1;
		
		private var video:Video;
		private var connection:NetConnection;
		private var stream:NetStream;
		
		private var imageWidth:int, imageHeight:int;
		private var imageList:Vector.<MovieClip> = new Vector.<MovieClip>();
		private var imageBuffer:Vector.<BitmapData>;
		private var bufferIndex:int = -1;
		private var container:Sprite;
		
		private var count:int = 0;

		
		public function GridMovie01()
		{
			Security.loadPolicyFile("http://start-rec.net/crossdomain.xml"); 
			
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			imageWidth = stage.stageWidth / colMax;
			imageHeight = stage.stageHeight / rowMax;
			
			initContainer();
			initVideo();
			initBitmap();
			
			addEventListener(Event.ENTER_FRAME, updateBuffer);
			
			stage.addEventListener(MouseEvent.CLICK, rest);
		}
		
		private function initContainer():void
		{
			container = new Sprite();
			addChild(container);
		}
		
		private function initVideo():void
		{
			connection = new NetConnection();
			connection.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler);
			connection.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityErrorHandler);
			connection.connect(null);
		}
		
		private function initBitmap():void
		{
			imageWidth = stage.stageWidth / colMax;
			imageHeight = stage.stageHeight / rowMax;
			
			imageBuffer = new Vector.<BitmapData>();
			
			var imageScaleX:Number = imageWidth / stage.stageWidth;
			var imageScaleY:Number = imageHeight / stage.stageHeight;
			
			var count:int = 0;
			
			for (var i:int = 0; i < colMax; i++)
			{
				for (var j:int = 0; j < rowMax; j++)
				{
					var bmd:BitmapData = new BitmapData(imageWidth, imageHeight, true, 0x00000000);
					var bmp:Bitmap = new Bitmap(bmd, "auto", true);
					var mc:MovieClip = new MovieClip();
					
					mc.index = count;
					mc.child = bmp;
					
					mc.x = imageWidth * i;
					mc.y = imageHeight * j;
					
					mc.addEventListener(Event.ENTER_FRAME, render);
					mc.addChild(bmp);
					
					container.addChild(mc);
					
					imageList.push(mc);
					
					imageBuffer.push(bmd); 
					
					count++;
				}
			}
			
		}
		
		private function rest(event:MouseEvent):void
		{
			bufferIndex = -1;
			
			colMax *= 2;
			rowMax *= 2;
			
			count++;
			
			if (count >= 5)
			{
				colMax = 1;
				rowMax = 1;
				count = 0;
			}
			
			imageWidth = stage.stageWidth / colMax;
			imageHeight = stage.stageHeight / rowMax;
			
			initVideo();
			
			for each (var mc:MovieClip in imageList)
			{
				mc.removeEventListener(Event.ENTER_FRAME, render);
				if (mc.child) Bitmap(mc.child).bitmapData.dispose();
				mc.child = null;
				container.addChild(mc);
			}
			
			for each (var bmd:BitmapData in imageBuffer)
			{
				bmd.dispose();
			}
			
			initBitmap();
				
		}
		
		private function updateBuffer(event:Event):void
		{
			if (bufferIndex < 0)
				bufferIndex = imageBuffer.length - 1;
			
			if (bufferIndex >= imageBuffer.length)
				bufferIndex = 0;
			
			var bmd:BitmapData = imageBuffer[bufferIndex];
			bmd.draw(video);
			
			bufferIndex++;
		}
		
		
		private function render(event:Event):void
		{
			var mc:MovieClip = event.target as MovieClip;
			var bmp:Bitmap = mc.child;
			
			if (mc.index >= imageBuffer.length)
				mc.index = 0;
			
			if (mc.index < 0)
				mc.index = imageBuffer.length - 1;
			
			var bmd:BitmapData = imageBuffer[mc.index];
			bmp.bitmapData = bmd;
			bmp.smoothing = true;
			
			mc.index++;
		}
		
		
		private function netStatusHandler(event:NetStatusEvent):void
		{
			switch (event.info.code)
			{
				case "NetConnection.Connect.Success":
					connectStream();
				break;
				case "NetStream.Buffer.Flush":
					//stream.play(VIDEO_URL);
				case "NetStream.Play.Stop":
					stream.play(VIDEO_URL);
				break;
				case "NetStream.Play.StreamNotFound":
					trace("Unable to locate video: " + VIDEO_URL);
				break;
			}
        }
        
        private function securityErrorHandler(event:SecurityErrorEvent):void
        {
            trace(this + event);
        }
        
        private function asyncErrorHandler(event:AsyncErrorEvent):void
        {
             trace(this + event);
        }
        
        public function onMetaData(param:Object):void
        {
			
		}
		
		public function onXMPData(param:Object):void
		{
			
		}
		
        private function connectStream():void
        {
        	if (stream)
        	{
        		stream.removeEventListener(NetStatusEvent.NET_STATUS, netStatusHandler);
				stream.removeEventListener(AsyncErrorEvent.ASYNC_ERROR, asyncErrorHandler);
        		stream.close();
        	}
        	
        	if (video)
        	{
        		video.clear();
        	}
        	
			stream = new NetStream(connection);
			stream.client = this;
			stream.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler);
			stream.addEventListener(AsyncErrorEvent.ASYNC_ERROR, asyncErrorHandler);
			
			video = new Video(imageWidth, imageHeight);
			video.smoothing = true;
			video.attachNetStream(stream);
			stream.play(VIDEO_URL);
			//addChild(video);
        }

	}
}
