/**
 * Copyright iong ( http://wonderfl.net/user/iong )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/i620
 */

/**
* dragでまわる
* 思ったより軽いのね
*/
package
{
    import flash.display.Sprite;

    [SWF(backgroundColor="#ffffff", frameRate="30")]
    public class FlashTest extends Sprite
    {
        import flash.display.Graphics;
        import flash.filters.BlurFilter;

        import flash.events.Event;
        import flash.events.MouseEvent;

        import flash.display.StageScaleMode;
        import flash.display.StageQuality;
        
        private var rectR:Sprite = new Sprite();
        private var flBlur:BlurFilter = new BlurFilter();
        
        private var isDrag:Boolean = false;
        private var nAddX:Number = 0;
        private var nPrvX:Number = 0;
        private var nAddY:Number = 0;
        private var nPrvY:Number = 0;
        private var nC:Number    = 0.95;
        
        public function FlashTest():void
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.quality   = StageQuality.LOW;

            init();
            
            addEventListener(Event.ENTER_FRAME, act);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onD);
            stage.addEventListener(MouseEvent.MOUSE_UP, onDU);
        }
        
        private function init():void
        {
            rectR.cacheAsBitmap= true;

            var nLDX:uint = 150;
            var nLDY:uint = 150;
            for(var i:int=0; i<3; i++){
                for(var k:int=0; k<3; k++){
                    var rectL:Sprite = new Sprite();
                    var nZ:int  = -300;
                    var nD:uint = 30;
                    
                    while(nZ<=600){
                        rectL.addChild(addPiece(100,50,nZ));
                        nZ += nD;
                    }
                    rectL.x = -(nLDX) + nLDX*i;
                    rectL.y = -(nLDY) + nLDY*k;
                    rectR.addChild(rectL);
                }
            }

            addChild(rectR);
            rectR.x = stage.stageWidth/2;
            rectR.y = stage.stageHeight/2;
        }
        
        private function addPiece(_W:uint, _H:uint, _Z:int):Sprite
        {
            var r:Sprite = new Sprite();
            with(r.graphics)
            {
                beginFill(0x336699,0.2);
                moveTo(-(_W/2),-(_H/2));
                lineTo(_W/2,-(_H/2));
                lineTo(_W/2,_H/2);
                lineTo(-(_W/2),_H/2);
                endFill();
            }
            r.z = _Z;
            return r;
        }


        private function onD(e:MouseEvent):void
        {
            isDrag = true;
        }
        private function onDU(e:MouseEvent):void
        {
            isDrag = false;
        }

        private function act(e:Event):void
        {
            if(isDrag){
                var mX:Number = stage.mouseX;
                var mY:Number = stage.mouseY;
                nAddX = mX-nPrvX;
                nAddY = mY-nPrvY;
                nPrvX = mX;
                nPrvY = mY;
            }
            /* rotate */
            rectR.rotationY -= nAddX;
            rectR.rotationX -= nAddY;
            nAddX *= nC;
            nAddY *= nC;

            /* add effect */
/*
            flBlur.blurX = Math.abs(nAddX/2);
            flBlur.blurY = Math.abs(nAddY/2);
            rectR.filters= [flBlur];
*/

            var addSC:Number = Math.max(nAddX, nAddY) /100;
            rectR.scaleX = rectR.scaleY = 1+addSC;
        }
    }
}