/**
 * Copyright Fumio ( http://wonderfl.net/user/Fumio )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/i4WPs
 */

// forked from Fumio's Getting the max value with Math.abs() vs custom methods
package {
	import flash.display.Sprite;
	import flash.utils.getTimer;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	[SWF(width = "240",height = "180")]
	public class GettingMaxValue extends Sprite {
		private const AMOUNT:uint = 1000000;
		private const ARGUMENTS:uint = 4;
		private var myVector:Vector.<Number> = new Vector.<Number>(AMOUNT);
		private var my_txt:TextField = new TextField();
		private var label_txt:TextField = new TextField();
		private var my_fmt:TextFormat = new TextFormat();
		public function GettingMaxValue() {
			// Creating a TextField for display
			createTextField();
			createNumbers();
			// Starting Test
			testMathMultiple();
			testMethodMultiple();
			testMathMultiple2();
			testMethodMultiple2();
			testMathTwo();
			testConditional();
			testMethodTwo();
		}
		private function testConditional():void {
			var _vector:Vector.<Number>  = myVector;
			var nAmount:uint = _vector.length - 1;
			var started:int = getTimer();
			for (var i:uint = 0; i < nAmount; i++) {
				var n0:Number = _vector[i];
				var n1:Number = _vector[uint(i + 1)];
				var nMax:Number = (n0 > n1) ? n0: n1;
			}
			xTrace("(n0 > n1) ? n0: n1", getTimer() - started);
		}
		private function testMathMultiple():void {
			var _vector:Vector.<Number>  = myVector;
			var nAmount:uint = _vector.length - ARGUMENTS + 1;
			var started:int = getTimer();
			for (var i:uint = 0; i < nAmount; i++) {
				var n0:Number = _vector[i];
				var n1:Number = _vector[uint(i + 1)];
				var n2:Number = _vector[uint(i + 2)];
				var n3:Number = _vector[uint(i + 3)];
				var nMax:Number = Math.max(n0, n1, n2, n3);
			}
			xTrace("Math.max(<4 arguments>)", getTimer() - started);
		}
		private function testMathMultiple2():void {
			var _vector:Vector.<Number>  = myVector;
			var nAmount:uint = _vector.length - ARGUMENTS + 1;
			var started:int = getTimer();
			for (var i:uint = 0; i < nAmount; i++) {
				var n0:Number = _vector[i];
				var n1:Number = _vector[uint(i + 1)];
				var n2:Number = _vector[uint(i + 2)];
				var n3:Number = _vector[uint(i + 3)];
				var nMax:Number = max4(n0, n1, n2, n3);
			}
			xTrace("Math.max(<4 args> /w apply())", getTimer() - started);
		}
		private function testMathTwo():void {
			var _vector:Vector.<Number>  = myVector;
			var nAmount:uint = _vector.length - 1;
			var started:int = getTimer();
			for (var i:uint = 0; i < nAmount; i++) {
				var n0:Number = _vector[i];
				var n1:Number = _vector[uint(i + 1)];
				var nMax:Number = Math.max(n0, n1);
			}
			xTrace("Math.max(<2 arguments>)", getTimer() - started);
		}
		private function testMethodMultiple():void {
			var _vector:Vector.<Number>  = myVector;
			var nAmount:uint = _vector.length - ARGUMENTS + 1;
			var started:int = getTimer();
			for (var i:uint = 0; i < nAmount; i++) {
				var n0:Number = _vector[i];
				var n1:Number = _vector[uint(i + 1)];
				var n2:Number = _vector[uint(i + 2)];
				var n3:Number = _vector[uint(i + 3)];
				var nMax:Number = max(n0, n1, n2, n3);
			}
			xTrace("Method max(<4 arguments>)", getTimer() - started);
		}
		private function testMethodMultiple2():void {
			var _vector:Vector.<Number>  = myVector;
			var nAmount:uint = _vector.length - ARGUMENTS + 1;
			var started:int = getTimer();
			for (var i:uint = 0; i < nAmount; i++) {
				var n0:Number = _vector[i];
				var n1:Number = _vector[uint(i + 1)];
				var n2:Number = _vector[uint(i + 2)];
				var n3:Number = _vector[uint(i + 3)];
				var nMax:Number = max2(n0, n1, n2, n3);
			}
			xTrace("Method max(<4 args> /w if)", getTimer() - started);
		}
		private function testMethodTwo():void {
			var _vector:Vector.<Number>  = myVector;
			var nAmount:uint = _vector.length - 1;
			var started:int = getTimer();
			for (var i:uint = 0; i < nAmount; i++) {
				var n0:Number = _vector[i];
				var n1:Number = _vector[uint(i + 1)];
				var nMax:Number = max3(n0, n1);
			}
			xTrace("Method (/w ?:)", getTimer() - started);
		}
		private static function max(...values):Number {
			var nLength:uint = values.length;
			var nMax:Number = values[0];
			for (var i:uint = 1; i < nLength; i++) {
				var myValue:Number = values[i]
				nMax = (myValue > nMax) ? myValue : nMax;
			}
			return nMax;
		}
		private static function max2(...values):Number {
			var nLength:uint = values.length;
			var nMax:Number = values[0];
			for (var i:uint = 1; i < nLength; i++) {
				var myValue:Number = values[i]
				if (myValue > nMax) {
					nMax = myValue;
				}
			}
			return nMax;
		}
		private static function max4(...values):Number {
			var nMax:Number = Math.max.apply(null, values);
			return nMax;
		}
		private static function max3(n0:Number, n1:Number):Number {
			var nMax:Number = (n0 > n1) ? n0: n1;
			return nMax;
		}
		private function createNumbers():void {
			var nAmount:uint = AMOUNT;
			var nRange:Number = 10;
			var nMin:Number = -5;
			for (var i:uint = 0; i < nAmount; i++) {
				myVector[i] = Math.random() * nRange + nMin;
			}
		}
		private function createTextField():void {
			addChild(my_txt);
			addChild(label_txt);
			my_fmt.align = TextFormatAlign.RIGHT;
			my_txt.x +=  80;
			my_txt.defaultTextFormat = my_fmt;
			my_txt.autoSize = TextFieldAutoSize.RIGHT;
			label_txt.autoSize = TextFieldAutoSize.LEFT;
		}
		private function xTrace(_str:String, n:int):void {
			my_txt.appendText(String(n) + "\n");
			label_txt.appendText(_str + ":" + "\n");
		}
	}
}