/**
 * Copyright paq ( http://wonderfl.net/user/paq )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/i4U6
 */

/* @OKASUKE
*  2010/03/25 stardustを試してみた。
*  うーん、使い方がまちがってるかな・・・
*
* 　舞え、千本桜　JAPANESE SAKURA HANAMI
*/

/*　@paq
*  2010/03/25 Forkしてみた。
*  うーん、見栄えが悪くなってるかな・・・
*
* 　舞え、千本桜　JAPANESE SAKURA HANAMI
*/

package  
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.display.Stage;
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.filters.ColorMatrixFilter;
	import flash.filters.GlowFilter;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	
	import idv.cjcat.stardust.common.clocks.SteadyClock;
	import idv.cjcat.stardust.common.emitters.Emitter;
	import idv.cjcat.stardust.twoD.renderers.DisplayObjectRenderer;
	
	import net.hires.debug.Stats;
	
	[SWF(width=465, height=465, backgroundColor = 0x000000, frameRate = 60)]
	public class Mae_SenponSakura extends Sprite
	{
		private static const ZERO_POINT:Point = new Point(0, 0);
		
		private var bmpd2:BitmapData=new BitmapData(465, 465,  true, 0x000000);
		private var bmp2:Bitmap=new Bitmap(bmpd2);
		
		private var container:BitmapData = new BitmapData(465, 465, true, 0x00000000);
		
		private var emitter:Emitter = new SakuraEmitter(new SteadyClock(12));
		private var blur:BlurFilter = new BlurFilter(1.5, 1.5, 1);
		private var color:ColorMatrixFilter = new ColorMatrixFilter([
			1, 0, 0, 0, 4,
			0, 0.4, 0, 0, 1,
			0, 0, 1, 0, 1,
			0, 0, 0, 0.5, 0
		]);
		
		public function  Mae_SenponSakura():void  
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);			
		}
		private function init(e:Event = null) :void
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			stage.quality = StageQuality.LOW;
			
			var background:Sprite = new Sprite();
			var g:Graphics = background.graphics;	
			g.beginFill(0x000000);
			g.drawRect(0, 0, 465, 465);	
			var renderer:FillRectRenderer = new FillRectRenderer(container, new Rectangle(0, 0, 2, 4), 0xFFFFFFFF);
			renderer.addEmitter(emitter);
			
			addChild(background);
			addChild(bmp2);
			addChild(new Stats());
			
			addEventListener(Event.ENTER_FRAME, loop);		
		}
		
		private function loop(e:Event):void 
		{
			emitter.step();
			bmpd2.applyFilter(bmpd2, bmpd2.rect, ZERO_POINT, color);
			bmpd2.draw(container);
		}
		
		
	}	
}

import flash.display.BitmapData;
import flash.display.Sprite;
import flash.geom.Point;
import flash.geom.Rectangle;

import frocessing.color.ColorHSV;

import idv.cjcat.stardust.common.actions.Age;
import idv.cjcat.stardust.common.actions.AlphaCurve;
import idv.cjcat.stardust.common.actions.CompositeAction;
import idv.cjcat.stardust.common.actions.DeathLife;
import idv.cjcat.stardust.common.clocks.Clock;
import idv.cjcat.stardust.common.events.EmitterEvent;
import idv.cjcat.stardust.common.initializers.Life;
import idv.cjcat.stardust.common.initializers.Mask;
import idv.cjcat.stardust.common.initializers.SwitchInitializer;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.common.particles.ParticleIterator;
import idv.cjcat.stardust.common.renderers.Renderer;
import idv.cjcat.stardust.twoD.actions.Damping;
import idv.cjcat.stardust.twoD.actions.Gravity;
import idv.cjcat.stardust.twoD.actions.Move;
import idv.cjcat.stardust.twoD.emitters.Emitter2D;
import idv.cjcat.stardust.twoD.fields.UniformField;
import idv.cjcat.stardust.twoD.initializers.DisplayObjectClass;
import idv.cjcat.stardust.twoD.initializers.Position;
import idv.cjcat.stardust.twoD.initializers.Velocity;
import idv.cjcat.stardust.twoD.particles.Particle2D;
import idv.cjcat.stardust.twoD.zones.LazySectorZone;
import idv.cjcat.stardust.twoD.zones.Line;

class SakuraEmitter extends Emitter2D
{	
	public function SakuraEmitter(clock:Clock)
	{
		super(clock);
		
		var	switchInit:SwitchInitializer = new SwitchInitializer([new Mask(1), new Mask(2)], [1, 1]);
		addInitializer(switchInit);
		addInitializer(new Life(new UniformRandom(50, 50)));
		addInitializer(new Velocity(new LazySectorZone(5, 5)));
		addInitializer(new Position(new Line(240, 0, 240, 465)));
		
		var gravityL:Gravity = new Gravity();
		gravityL.mask = 1;
		gravityL.addField(new UniformField(-0.4, 0));
		
		var gravityR:Gravity = new Gravity();
		gravityR.mask = 2;
		gravityR.addField(new UniformField(0.4, 0));
		
		var commonAction:CompositeAction = new CompositeAction();		
		commonAction.mask = 1 | 2;		
		commonAction.addAction(new Move());	
		commonAction.addAction(new DeathLife());
		commonAction.addAction(new Age());
		commonAction.addAction(new AlphaCurve(25, 40));
		commonAction.addAction(new Damping(0.1));
		
		addAction(gravityL);
		addAction(gravityR);
		addAction(commonAction);
	}
}

class FillRectRenderer extends Renderer
{
	public var targetBitmapData:BitmapData;
	public var sourceRect:Rectangle;	
	public var color:uint;
	private var rect:Rectangle;
	
	public function FillRectRenderer(targetBitmapData:BitmapData = null, sourceRect:Rectangle = null, color:uint = 0xFFFFFFFF)
	{
		this.targetBitmapData = targetBitmapData;
		this.sourceRect = sourceRect;
		this.color = color;
		rect = new Rectangle(); 
	}
	
	override protected function render(e:EmitterEvent):void
	{
		if (!targetBitmapData) return;
		
		targetBitmapData.lock();
		targetBitmapData.fillRect(targetBitmapData.rect, 0x00000000);
		var particle:Particle2D;
		var iter:ParticleIterator = e.particles.getIterator();
		while (particle = iter.particle as Particle2D)
		{
			rect.x = particle.x;
			rect.y = particle.y;
			rect.width = sourceRect.width;
			rect.height = sourceRect.height;
			var a:uint = ( color >> 24 ) & 0xFF;
			a *= particle.alpha;
			targetBitmapData.fillRect(rect, (a << 24) | (color & 0xFF0000) | (color & 0xFF00) | (color & 0xFF));
			iter.next();
		}
		targetBitmapData.unlock();
	}
}