/**
 * Copyright fukt ( http://wonderfl.net/user/fukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/i3hB
 */

// forked from HaraMakoto's チョロチョロ走る車 forked from: 方向一定しつつ衝突判定
package
{
	import __AS3__.vec.Vector;
	
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.geom.Matrix;
	import flash.net.URLRequest;
	import flash.system.Security;
	import flash.utils.Timer;
	
	import jp.progression.commands.Func;
	import jp.progression.commands.lists.SerialList;
	
	import net.hires.debug.Stats;
	
	[SWF(width="465", height="465", backgroundColor="#000000", frameRate=60)]
	public class HitTest4 extends Sprite
	{
		private var elemList:Array = new Array();
		private var elemNum:int = 20;
		private var colManager:EasyColosionManager = new EasyColosionManager();
		private var RoadList:Array = new Array();
		
		private var carList:Array = new Array();
//		private var ImgDomain:String = "assets/";
        private var ImgDomain:String = "http://swimmingbird.heteml.jp/wonderfl/assets/car/"
		private var ROT_STEPS:int = 15;
		public var Front:Vector.<BitmapData> = new Vector.<BitmapData>(ROT_STEPS, true);
		public var Back:Vector.<BitmapData> = new Vector.<BitmapData>(ROT_STEPS, true);
		public var Right:Vector.<BitmapData> = new Vector.<BitmapData>(ROT_STEPS, true);
		public var Left:Vector.<BitmapData> = new Vector.<BitmapData>(ROT_STEPS, true);
		
		public function HitTest4()
		{
			super();
			Security.loadPolicyFile("http://swimmingbird.heteml.jp/crossdomain.xml");
			//addChild(new Stats());
			
			loadCharacters(carList,init);
			//init();
			
		}
		
		private function loadCharacters(ImgArr:Array,compFunc:Function):void {
        	var i:int;
        	var carNum:int = 45;
        	var s:SerialList = new SerialList();
        	for(i=1; i<carNum+1; i++) {
        		var loader:Loader = new Loader();
        		var sp:Sprite = new Sprite();
        		sp.addChild(loader);
        		ImgArr.push(sp);
	       		s.addCommand(
        			new Func(loader.load,[new URLRequest(ImgDomain+"car"+i+".png")],loader.contentLoaderInfo,Event.COMPLETE)
        		);
        	}
        	s.addCommand(new Func(constructCars));
        	s.addCommand(new Func(compFunc));
        	s.execute();
        }
        
        private function constructCars():void {
        	var matrix:Matrix = new Matrix();
        	matrix.scale(-1,1);
        	matrix.translate(50,0);
            var i:int = ROT_STEPS;
            while (i--)
            {
                Front[i] = new BitmapData(50, 50, true, 0x0);
                Front[i].draw(carList[i+15]);
                Back[i] = new BitmapData(50, 50, true, 0x0);
                Back[i].draw(carList[i+30]);
                Right[i] = new BitmapData(50, 50, true, 0x0);
                Right[i].draw(carList[i]);
                Left[i] = new BitmapData(50, 50, true, 0x0);
                Left[i].draw(carList[i],matrix);
            }
        }
        
		private function init():void {
			//道路一覧
			RoadList = [
				new RoadUnit(80,445,"y",-1),new RoadUnit(140,20,"y",1),
				new RoadUnit(200,445,"y",-1),new RoadUnit(240,20,"y",1),
				new RoadUnit(340,445,"y",-1),new RoadUnit(400,20,"y",1),
				new RoadUnit(445,90,"x",-1),new RoadUnit(20,140,"x",1),
				new RoadUnit(445,180,"x",-1),new RoadUnit(20,210,"x",1),
				new RoadUnit(445,280,"x",-1),new RoadUnit(20,340,"x",1)
			]
			var i:int;
			for(i=0; i<elemNum; i++) {
				var elem:Elemet = new Elemet(this);
				addChild(elem);
				colManager.addElement(elem); //衝突マネージャ
				elemList.push(elem);
				var ru:RoadUnit = RoadList[int(RoadList.length*Math.random())];
				elem.px = ru.x;
				elem.py = ru.y;
				if(ru.vecType=="x") {
					if(ru.posinega==1) {
						elem.px += 100*Math.random();
					} else {
						elem.px -= 100*Math.random();
					}
				} else {
					elem.py += 100*Math.random();					
				}
				elem.init((ru.vecType=="x"),(ru.vecType=="y"),0.01*ru.posinega, 0.01*ru.posinega,ru.x, ru.y);
			}
//			var too:TooSenBoo = new TooSenBoo();
//			addChild(too);
//			colManager.addElement(too);
//			elemList.push(too);
//			elemNum++;
			
			this.graphics.clear();
			for(i=0; i<RoadList.length; i++) {
				var rr:RoadUnit = RoadList[i];
				this.graphics.lineStyle(1,0x333333);
				this.graphics.moveTo(rr.x,rr.y);
				var goalNum:Number = 465;
				if(rr.posinega==-1) goalNum = 0;
				if(rr.vecType=="x") {
					this.graphics.lineTo(goalNum, rr.y);
				} else {
					this.graphics.lineTo(rr.x, goalNum);					
				}
			}
			addEventListener(Event.ENTER_FRAME, handleEnterFrame);
		}
		
		
		
		private function handleEnterFrame(event:Event):void {
			for (var t:int = 0; t < 6; t++) {
				var i:int;
				for(i=0; i<elemNum; i++) {
					elemList[i].update();
				}
				colManager.checkColision();
			}
			for(i=0; i<elemNum; i++) {
				elemList[i].render();
			}
		}
		
	}
}
	import flash.events.EventDispatcher;
	import flash.display.Sprite;
	import flash.utils.Timer;
	import flash.events.TimerEvent;
	import flash.geom.Point;
	import caurina.transitions.Tweener;
	import caurina.transitions.Equations;
	import flash.display.BitmapData;
	import flash.display.Bitmap;
	

class EasyColosionManager extends EventDispatcher {
	private var elemList:Array = new Array();
	private var elemlen:int = 0;
	private var spring:Number = 0.2;
	private var bounce:Number = -0.5;
	private var gravity:Number = 0.1;
	public function EasyColosionManager() {
		
	}
	
	public function addElement(elem:Elemet):void {
		elemList.push(elem);
		elemlen = elemList.length;
	}
	
	public function checkColision():void {
		var i:int;
		for(i=0; i<elemlen-1; i++) {
			var elem0:Elemet = elemList[i];
			for(var j:int=i+1; j<elemlen; j++) {
				var elem1:Elemet = elemList[j];
				var dx:Number = elem1.x - elem0.x;
				var dy:Number = elem1.y - elem0.y;  
				var dist:Number = culcDistBetElems(elem0, elem1);
				var minDist:Number = elem0.radious + elem1.radious;
				elem0.hitTest(elem1);
			}
		}
		
	}
	
	//２者間の距離を返す
	private function culcDistBetElems(mc1:Sprite, mc2:Sprite):Number {
		var pt1:Point = new Point(mc1.x, mc2.x);
		var pt2:Point = new Point(mc2.x, mc2.y);
		var dist:Number = Point.distance(pt1, pt2);
		return dist;
	}
	
}

class Elemet extends Sprite {
	public var px:Number = 0;
	public var py:Number = 0;
	public var vx:Number = 0;
	public var vy:Number = 0;
	public var maxX:Number = 465;
	public var maxY:Number = 465;
	public var started:Boolean = false;
	public var radious:Number = 25;
	private var spring:Number = 0.1;
	private var bounce:Number = -0.5;
	
	private var cx:Number = 0;
	private var cy:Number = 0;
	private var priority:int = 0;
	
	private var isXAddition:Boolean = false;
	private var isYAddition:Boolean = true;
	private var additionalVx:Number = 0.1;
	private var additionalVy:Number = 0.01;
	private var fixX:Number = 200;
	private var fixY:Number = 200;
	
	private var startPt:Point = new Point(0,0);
	private var startVx:Number, startVy:Number;
	
	private var bmp:Bitmap = new Bitmap();
	private var myparent:HitTest4;
	private var counter:int = 0;
	
	private var timer:Timer = new Timer(1000);
	public function Elemet(pare:HitTest4) {
		myparent = pare;
		radious = 18;
		makeBody();
	}
	
	private function makeBody():void {
		this.graphics.beginFill(0,0);
		this.graphics.drawCircle(0,0,radious);
		this.graphics.endFill();
		addChild(bmp);
		bmp.x = bmp.y = -25;
	}
	
	public function attacked():void {
		Tweener.addTween(this, {alpha:0, time:0.2, transition:Equations.easeOutInBounce});
		Tweener.addTween(this, {alpha:1, time:0.2, delay:0.2, transition:Equations.easeOutInBounce});
	}
	
	public function contact(contactX:Number, contactY:Number, _priority:int, force:Number):void {
		var tx:Number = contactX - px;
		var ty:Number = contactY - py;
		
		var angle:Number = Math.atan2(ty, tx);
		var length:Number = Math.sqrt(tx*tx+ty*ty);
		
		vx -= (1-length/radious)*0.5*Math.cos(angle);
		vy -= (1-length/radious)*0.5*Math.sin(angle);
		
		if(this.priority < _priority) {
			this.priority = _priority;
			cx = tx;
			cy = ty;
		}
	}
	public function hitTest(elm:Elemet):void {
		var dx:Number = elm.px - px;
		var dy:Number = elm.py - py;
		var distanceSquared:Number = dx*dx+dy*dy;
		var contactDistance:Number = radious + elm.radious;
		if(distanceSquared < contactDistance*contactDistance) {
			var tx:Number = linearTransform(radious, 0, contactDistance, px, elm.px);
			var ty:Number = linearTransform(radious, 0, contactDistance, py, elm.py);
			contact(tx, ty, 2, 0.5);
			elm.contact(tx, ty, 2, 0.5);
		}
	}
	private function linearTransform(n:Number, s0:Number, s1:Number, d0:Number, d1:Number):Number {
		return ( d0+(n-s0)*(d1-d0) / (s1-s0) );
	}
	
	
	public function update():void {
		cx = 0;
		cy = 0;
		priority = 0;
	
		px += vx;
		py += vy;
		
		if(px-radious<0) {
			setStartPosition();
		}
		if(px+radious>465) {
			setStartPosition();
		}
		if(py-radious<0) {
			setStartPosition();
		}
		
		//端までいったら戻る
		if(isContactWall())
			setStartPosition();
			
		mainAdditionalVec();
		vy *= 0.9796;
		vx *= 0.9796;
	}
	public function init(xAnable:Boolean=true, yAnable:Boolean=false, _vx:Number=0.001, _vy:Number=0.001, _x:Number=200, _y:Number=200):void {
		startPt.x = _x; startPt.y = _y;
		startVx = _vx; startVy = _vy;
		changeAction(xAnable,yAnable,_vx,_vy,_x,_y);
	}
	private function setStartPosition():void {
		px = startPt.x;
		py = startPt.y;
		vx = startVx;
		vy = startVy;
	}
	public function changeAction(xAnable:Boolean=true, yAnable:Boolean=false, _vx:Number=0.001, _vy:Number=0.001, _x:Number=200, _y:Number=200):void {
		isXAddition = xAnable;
		isYAddition = yAnable;
		additionalVx = _vx;
		additionalVy = _vy;
		fixX = _x;
		fixY = _y;
	}
	private function isContactWall():Boolean {
		var truth:Boolean = false;
		if(isXAddition){
			if(px-radious>maxX)
				truth = true;
		} else if(isYAddition) {
			if(py-radious>maxY)
				truth = true;
		}
		return truth;
	}
	private function mainAdditionalVec():void {
		if(isXAddition) {
			vx+=additionalVx;
			py = fixY;
		}
		if(isYAddition) {
			vy+=additionalVy;
			px = fixX;
		}
		
		
	}
	
	public function render():void {
		if(isYAddition) {
			if(vy>0) {
				bmp.bitmapData = myparent.Front[counter%15];
			} else {
				bmp.bitmapData = myparent.Back[counter%15];
			}
		} else {
			if(vx>0) {
				bmp.bitmapData = myparent.Right[counter%15];
			} else {
				bmp.bitmapData = myparent.Left[counter%15];
			}
		}
		this.x = px;
		this.y = py;
		counter++;
	}
}

class TooSenBoo extends Elemet {
	public function TooSenBoo(pare:HitTest4) {
		super(pare);
	}
	public override function update():void {
		px = 400;
		py = 200;
	}
}

class RoadUnit {
	public var x:Number;
	public var y:Number;
	public var vecType:String = "x";
	public var posinega:int = 1;
	public function RoadUnit(_x:Number=0,_y:Number=0, _vec:String="x", _pn:int=1 ) {
		x = _x;
		y = _y;
		vecType = _vec;
		posinega = _pn;
	} 
}