/**
 * Copyright nenjiru ( http://wonderfl.net/user/nenjiru )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/i3aR
 */

/**
 * 画像をRGB分解してテレビっぽく表示
 */
package 
{
    import flash.display.Bitmap;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Vector3D;
    import flash.net.FileFilter;
    import flash.net.FileReference;
    
    [SWF(width = "1000", height = "600", backgroundColor = 0xFFFFFF, frameRate = "60")]
    
    public class RGBResolution extends Sprite 
    {
        private const ZOOM:uint = 8;
        private var _canvas:Sprite;
        
        public function RGBResolution() 
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            _init();
        }
        
        private function _init():void
        {
            var file:FileReference = new FileReference();
            file.addEventListener(Event.COMPLETE, _onComplete);
            file.addEventListener(Event.SELECT, function (event:Event):void 
            {
                file.load();
            });
            
            var button:Button = new Button("choose image file", 130, 24);
            button.x = (stage.stageWidth - button.width) / 2;
            button.y = (stage.stageHeight - button.height) / 2;
            button.addEventListener(MouseEvent.CLICK, function browse(event:Event):void 
            {
                file.browse([new FileFilter("Images", "*.jpg;*.jpeg;*.gif;*.png")]);
            });
            addChild(button);
            
            _canvas = new Sprite();
            _canvas.addEventListener(MouseEvent.MOUSE_DOWN, _zoomIn);
            _canvas.addEventListener(MouseEvent.MOUSE_UP, _zoomOut);
            addChild(_canvas);
        }
        
        /**
         * 画像選択
         */
        private function _onComplete(event:Event):void 
        {
            var loader:Loader = new Loader();
            loader.loadBytes((event.currentTarget as FileReference).data);
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, _loaded);
        }
        
        /**
         * 画像変換
         */
        private function _loaded(event:Event):void 
        {
            var source:Bitmap = event.target.content as Bitmap;
            var convert:RGBPixelSeparation = new RGBPixelSeparation(source.bitmapData);
            
            _canvas.graphics.beginBitmapFill(convert);
            _canvas.graphics.drawRect(-10, -100, 900, 900);
            _canvas.graphics.endFill();
            _canvas.z = 0;
            _canvas.transform.matrix3D.prependRotation( -15, Vector3D.Y_AXIS);
            _canvas.transform.matrix3D.prependRotation( 5, Vector3D.X_AXIS);
        }
        
        /**
         * ズームイン
         */
        private function _zoomIn(event:MouseEvent):void 
        {
            _canvas.x = _canvas.y = 0;
            _canvas.scaleX = _canvas.scaleY = ZOOM;
            _canvas.x -= event.localX * (ZOOM - 1);
            _canvas.y -= event.localY * (ZOOM - 1);
        }
        
        /**
         * ズームアウト
         */
        private function _zoomOut(event:MouseEvent):void 
        {
            _canvas.x = _canvas.y = 0;
            _canvas.scaleX = _canvas.scaleY = 1;
        }
    }
}

import flash.display.BitmapData;
import flash.display.BitmapDataChannel;
import flash.display.SimpleButton;
import flash.display.Sprite;
import flash.geom.Point;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;

/**
 * ボタン生成
 */
class Button extends SimpleButton
{

    public function Button(label:String, width:Number, height:Number)
    {
        upState = _button(0xCCCCCC, label, width, height);
        overState = _button(0xEEEEEE, label, width, height);
        downState = _button(0xCCCCCC, label, width, height);
        hitTestState = upState;
    }
    
    private function _button(bgColor:uint, text:String, width:Number, height:Number):Sprite
    {
        var label:TextField = new TextField();
        label.defaultTextFormat = new TextFormat("_sans", 12, 0x0);
        label.selectable = false;
        label.width = width;
        label.autoSize = TextFieldAutoSize.CENTER;
        label.text = text;
        label.y = (height - label.height) / 2;
        
        var sprite:Sprite = new Sprite();
        sprite.graphics.beginFill(bgColor);
        sprite.graphics.drawRoundRect(0, 0, width, height, 6);
        sprite.graphics.endFill();
        sprite.addChild(label);
        
        return sprite;
    }
}

/**
 * 色分解して描画
 */
class RGBPixelSeparation extends BitmapData
{
    private var _source:BitmapData;
    private var _mask:BitmapData;
    private var _red:BitmapData;
    private var _green:BitmapData;
    private var _blue:BitmapData;
    
    /**
     * RGBを分解
     */
    public function RGBPixelSeparation(source:BitmapData) 
    {
        var width:Number = source.width;
        var height:Number = source.height;
        
        super(width, height);
        
        _source = source;
        _mask = _dotmask(width, height);
        
        _red = new BitmapData(width, height, true, 0xFF000000);
        _green = new BitmapData(width, height, true, 0xFF000000);
        _blue = new BitmapData(width, height, true, 0xFF000000);
        
        _draw();
    }
    
    /**
     * カラーごとのチャンネルを描画
     */
    private function _draw():void 
    {
        _red.copyChannel(_source, _source.rect, new Point(), BitmapDataChannel.RED, BitmapDataChannel.RED);
        _red.copyChannel(_mask, _mask.rect, new Point(), BitmapDataChannel.ALPHA, BitmapDataChannel.ALPHA);
        draw(_red);
        
        _green.copyChannel(_source, _source.rect, new Point(1, 0), BitmapDataChannel.GREEN, BitmapDataChannel.GREEN);
        _green.copyChannel(_mask, _mask.rect, new Point(1, 0), BitmapDataChannel.ALPHA, BitmapDataChannel.ALPHA);
        draw(_green);
        
        _blue.copyChannel(_source, _source.rect, new Point(2, 0), BitmapDataChannel.BLUE, BitmapDataChannel.BLUE);
        _blue.copyChannel(_mask, _mask.rect, new Point(2, 0), BitmapDataChannel.ALPHA, BitmapDataChannel.ALPHA);
        draw(_blue);
    }
    
    /**
     * マスクを作成
     */
    private function _dotmask(width:Number, height:Number):BitmapData 
    {
        var color:uint = 0xFFFFFFFF;
        var xn:Number = width / 3;
        var yn:Number = height;
        var mask:BitmapData = new BitmapData(width, height, true, 0x00000000);
        
        mask.lock();
        
        for (var x:int = 0; x < xn; x++) {
            for (var y:int = 0; y < yn; y++) {
                if (y % 3 == 2) color = 0x80FFFFFF;
                else color = 0xFFFFFFFF;
                mask.setPixel32(x * 3, y, color);
            }
        }
        
        mask.unlock();
        
        return mask;
    }
}