/**
 * Copyright omari ( http://wonderfl.net/user/omari )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/i2RT
 */

// forked from Kay's Line class for easy drawing, vol.1
/*
 * Line.start(x,y,radian)
 * Line.straight(len[,toAngle])
 * Line.curve(radius,angle[,toAngle])
 * Line.draw([lineStyle value])
 */
package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // Circle
            var circle:Line = new Line(graphics);
            circle.start(120,10);
            circle.corner(60,360);
            graphics.beginFill(0xffcc66);
            circle.draw(10);
            graphics.endFill();
            
            // Free
            var free:Line = new Line(graphics);
            free.start(0,90);
            free.straight(180);
            free.corner(20,125);
            free.straight(10);
            free.corner(35,55);
            free.straight(80);
            free.corner(20,-180,180);
            free.straight(70,180);    // ????
            free.corner(20,180);
            free.straight(70);
            free.corner(60,90);
            free.straight(90);
            free.corner(30,90);
            free.straight(340);
            free.corner(25,270);
            free.straight(50);
            free.draw(15,0x999999,1,true,'normal','none');
            
            // ExpandRect
            var expandRect:Line = new Line(graphics);
            expandRect.start(300,250,-10);
            for (var i:int = 0; i < 4; i++) {
                expandRect.corner(300,20);
                expandRect.corner(40,70);
            }
            expandRect.draw(15,0xff6600);
            
            // Spiral
            var spiral:Line = new Line(graphics);
            spiral.start(300,200,180);
            for (i = 0; i < 60; i++) {
                spiral.corner(2+2*i,120);
            }
            spiral.straight(250);
            spiral.draw(3,0x006600);

            // Spark
            var spark:Line = new Line(graphics);
            spark.start(100,313);
            for (i = 0; i < 24; i++) {
                spark.straight(100,165);
            }
            graphics.beginFill(0x999900,0.75);
            spark.draw(NaN);
            graphics.endFill();
        }
    }
}
//package jp.seeda.graphics{
    import flash.display.Graphics;
    import flash.geom.Point;
    import flash.geom.Matrix;
    /*public*/ class Line {

        protected var target:Graphics;
        private var nX:Number;
        private var nY:Number;
        private var nAngle:Number;
        private var nRadian:Number;
        private var points:Vector.<Number>=new Vector.<Number>  ;
        private var commands:Vector.<int>=new Vector.<int>  ;

        public function Line(gTarget:Graphics):void {
            target = gTarget;
        }

        public function draw(thickness:Number=0,
                             color:uint=0,alpha:Number=1,
                             pixelHinting:Boolean=false,
                             scaleMode:String = "normal",
                             caps:String=null,
                             joints:String=null,
                             miterLimit:Number=3):void {
            target.lineStyle(thickness, color, alpha, pixelHinting, scaleMode, caps, joints, miterLimit);
            target.drawPath(commands, points);
        }

        public function start(x:Number=0, y:Number=0, angle:Number=0):void {
            nX=x;
            nY=y;
            nAngle = angle;
            nRadian=angle2radian(nAngle);
            points.push(nX,nY);
            commands.push(1);
        }

        public function straight(length:Number=0, angle:Number=NaN):void {
            if (!isNaN(angle)) nAngle += angle;
            nRadian = angle2radian(nAngle);
            nX +=length*Math.cos(nRadian);
            nY +=length*Math.sin(nRadian);
            points.push(nX,nY);
            commands.push(2);
        }
        
        /*
         * 現在角（nRadian,nAngle）から半径（radius）／角度（angle）で円弧を描くPointを取得
         */
        public function corner(radius:Number=100, toAngle:Number=45, fromAngle:Number=NaN):void {
            if (!isNaN(fromAngle)) nAngle += fromAngle;
            var nFromRadian:Number = angle2radian(nAngle);

            // 相対到達角
            var nToRadian:Number = angle2radian(toAngle);
            nToRadian = getRangeValue(nToRadian, Math.PI*2);
            
            var cp:Array = getArcPoints(radius, nToRadian);
            var matrix:Matrix = new Matrix();
            matrix.translate(-radius,0);
            matrix.rotate(nFromRadian-Math.PI/2);
            matrix.translate(nX, nY);
            var max:int = cp.length-1;
            for (var i:int = 1; i < max; i+=2) {
                var control:Point = matrix.transformPoint(cp[i]);
                var anchor:Point  = matrix.transformPoint(cp[i+1]);
                points.push(control.x, control.y, anchor.x, anchor.y);
                nX = anchor.x;
                nY = anchor.y;
                commands.push(3);
            }
            nAngle += toAngle;
            nRadian = angle2radian(nAngle);
        }

        // コントロール／アンカーポイントをおプロジェクトとして取得
        // Point(0,0), radian:0から取得しておき後にmatrixで移動
        public static function getArcPoints(nRadius:Number, toRadian:Number):Array {
            var points:Array = new Array();
            var vals:Object = getArcValues(nRadius, toRadian);
            for (var i:int = 0; i <= vals.divideNum; i++) {
                // Anchor
                points.push(new Point(nRadius*Math.cos(vals.dividedRadian*i),
                                      nRadius*Math.sin(vals.dividedRadian*i)));
                // Control
                points.push(new Point(vals.distance*Math.cos(vals.dividedRadian*(i+0.5)),
                                      vals.distance*Math.sin(vals.dividedRadian*(i+0.5))));
            }
            return points;
        }
        
        /*
         * 円弧を描くのに必要な材料を配列として返す
         * @return divideNum: 分割数
         * @return dividedRadian: 分割された角度
         * @return distance: 中心点からコントロールポイントまでの距離
         */
        public static function getArcValues(nRadius:Number, nRadian:Number):Object {
            // 分割数を得る（45°未満：1）
            var divideNum:int = 1;
            while (Math.abs(nRadian)/divideNum > Math.PI/4) divideNum++;
            // 分割された角度
            var dividedRadian:Number = nRadian/divideNum;
            // コントロールポイントまでの距離を得る
            var distance:Number = getControlRadius(nRadius,Math.abs(dividedRadian));
            return {divideNum:divideNum, dividedRadian:dividedRadian, distance:distance};
        }
        
        // 角度からコントロールポイントの半径を取得
        public static function getControlRadius(nRadius:Number, nRadian:Number):Number {
            var rHalf:Number = nRadian/2;
            var nHeight:Number = nRadius * Math.atan(rHalf);
            var radius:Number = Math.sqrt(Math.pow(nHeight,2)+Math.pow(nRadius,2));
            return radius;
        }

        // 数値を+-limitの範囲に収束
        public function getRangeValue(num:Number, limit:Number):Number {
            while(num >  limit) num -= limit*2;
            while(num < -limit) num += limit*2;
            return num;
        }
        
        // angleをradianに変換
        private function angle2radian(angle:Number=0):Number {
            var radian:Number= angle * (Math.PI / 180);
            return radian;
        }
    }
//}