/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/i2Kp
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	
	public class Main extends MovieClip
	{
		public function Main()
		{
			view=new BitmapData(stage.stageWidth,stage.stageHeight,false,0);
			addChild(new Bitmap(view));
			ctrans=new ColorTransform(.65,.65,.8);
			
			addEventListener(Event.ENTER_FRAME,enterFrameHandler);
		}
		
		private var view:BitmapData;
		private var filter:BlurFilter;
		private var ctrans:ColorTransform;
		
		private var head:Part=null;
		private var tail:Part=null;
		private function enterFrameHandler(e:Event):void
		{
			var p:Part=new Part();
			if(Math.random()<.5)
			{
				p.x=0;
				p.y=Math.random()*view.height/2+view.height/4;
				p.tx=view.width;
				p.ty=view.height*.5;
			}
			else
			{
				p.x=Math.random()*view.width/2+view.width/4;
				p.y=0;
				p.tx=view.width*.5;
				p.ty=view.height;
			}
			if(head==null)
			{
				head=tail=p;
			}
			else
			{
				tail=tail.next=p;
			}
			
			view.lock();
			view.colorTransform(view.rect,ctrans);
			
			var prev:Part=null;
			p=head;
			while(p!=null)
			{
				var near:Part=p;
				var neardist:Number=Number.MAX_VALUE;
				var dist:Number;
				var i:Part=head;
				while(i!=null)
				{
					if(p!=i)
					{
						dist=(i.x-p.x)*(i.x-p.x)+(i.y-p.y)*(i.y-p.y);
						if(dist<neardist)
						{
							near=i;
							neardist=dist;
						}
					}
					i=i.next;
				}
				
				var vx:Number=0;
				var vy:Number=0;
				if(neardist<100)
				{
					neardist=Math.sqrt(neardist);
					vx+=(p.x-near.x)/neardist;
					vy+=(p.y-near.y)/neardist;
				}
				dist=Math.sqrt((p.tx-p.x)*(p.tx-p.x)+(p.ty-p.y)*(p.ty-p.y));
				vx+=(p.tx-p.x)/dist;
				vy+=(p.ty-p.y)/dist;
				
				p.x+=vx;
				p.y+=vy;
				
				if(p.x>=view.width||p.y>=view.height)
				{
					if(prev==null)head=p.next;
					else prev.next=p.next;
				}
				else
				{
					view.setPixel(p.x,p.y,0xFFFFFF);
					prev=p;
				}
				p=p.next;
			}
			view.unlock();
		}
	}
}

class Part
{
	public function Part(){}
	public var x:Number=0;
	public var y:Number=0;
	public var tx:Number=0;
	public var ty:Number=0;
	public var next:Part=null;
}