/**
 * Copyright ChevyRay ( http://wonderfl.net/user/ChevyRay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/i1NP
 */

package
{
    import flash.display.Shape;
    import flash.events.Event;
    import flash.display.Sprite;
    import flash.utils.getTimer;
    
    public class SineWave extends Sprite
    {
        public var totalTime:Number = 0;
        public var box:Shape = new Shape();
        
        public function SineWave()
        {
            addEventListener(Event.ENTER_FRAME, update);
   
            //Draw & position the shape
            box.x = 100;
            box.y = 100;
            box.graphics.beginFill(0xFF0000);
            box.graphics.drawRect(-25, -25, 50, 50);
            addChild(box);
        }
        
        public function update(e:Event):void
        {
            //Get the total time in seconds
            totalTime = getTimer() / 1000;
            
            //Rock the box back & forth between -20 and 20 degrees
            box.rotation = wave(1, -20, 20);
        }
        
        public function wave(time:Number, from:Number, to:Number, offsetPercent:Number = 0):Number
        {
            var range:Number = (to - from) / 2;
            return from + range + Math.sin(((totalTime + time * offsetPercent) / time) * (Math.PI * 2)) * range;
        }
    }
}