/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/i1DL
 */

package
{
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.system.Security;
    import frocessing.color.ColorHSV;
    import com.bit101.components.InputText;
    
    public class Main extends Sprite
    {
        private const IMAGE_SIZE:int = 400;
        private const SIZE:int = 1;
        private    var WIDTH:int;
        private var HEIGHT:int;
        
        private var bd:BitmapData;
        private var flag:Boolean;
        private var ty:int;
        private var tx:int;
        private var pixel:ColorHSV = new ColorHSV();
        private var urlText:InputText;
        private var widthText:InputText;
        private var heightText:InputText;
        private var bitmap:Bitmap;
        
        public function Main()
        {
            graphics.beginFill(0xF0F0F0);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            
            new Label(this, 10, 405, "IMAGE URL");
            new Label(this, 10, 425, "WIDTH");
            new Label(this, 10, 445, "HEIGHT");
            urlText = new InputText(this, 70, 405, "http://assets.wonderfl.net/images/related_images/a/a3/a30c/a30c2fd54b03e53bae1679bd5d8deb74239c77ce");
            urlText.width = 300;
            widthText = new InputText(this, 70, 425, "25");
            heightText = new InputText(this, 70, 445, "12");
            widthText.maxChars = heightText.maxChars = 3;
            widthText.restrict = heightText.restrict = "0-9";
            new PushButton(this, urlText.x + urlText.width - 100, 425, "OK", initialize);
            
            bitmap = new Bitmap();
            addChild(bitmap);
            
            initialize();
        }
        
        private function initialize(event:Event = null):void
        {
            removeEventListener(Event.ENTER_FRAME, onEnterFrame);
            flag = false;
            tx = ty = 0;
            WIDTH = int(widthText.text);
            HEIGHT = int(heightText.text);
            
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener
            (
                Event.INIT,
                function (event:Event):void
                {
                    var loader2:Loader = new Loader();
                    loader2.contentLoaderInfo.addEventListener(Event.INIT, initHandler);
                    loader2.loadBytes(event.currentTarget.bytes);
                }
            );
            loader.load(new URLRequest(urlText.text), new LoaderContext(true));
        }
 
        private function initHandler(event:Event):void
        {
            var loader:Loader = event.currentTarget.loader;
            var scale:Number = (loader.width > loader.height) ? IMAGE_SIZE / loader.width : IMAGE_SIZE / loader.height;
            var matrix:Matrix = new Matrix();
            matrix.scale(scale, scale);
 
            bd = new BitmapData(loader.width * scale, loader.height * scale);
            bd.draw(loader, matrix);
            bitmap.bitmapData = bd;
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(event:Event):void 
        {
            conversion();
            
            tx += WIDTH;
            if (tx >= bd.width)
            {
                tx = 0;
                flag = !flag;
                if (flag) tx -= WIDTH / 2;
                
                ty += HEIGHT;
                if (ty >= bd.height)
                {
                    removeEventListener(Event.ENTER_FRAME, onEnterFrame);
                    return;
                }
            }
        }
        
        private function conversion():void
        {
            var count:int = 0;
            var r:int = 0;
            var g:int = 0;
            var b:int = 0;
                    
            for (var yy:int = ty; yy < ty + HEIGHT; yy++)
            {
                for (var xx:int = tx; xx < tx + WIDTH; xx++)
                {
                    if (yy < 0 || bd.height <= yy) continue;
                    if (xx < 0 || bd.width  <= xx) continue;
                    count++;
                    
                    pixel.value = bd.getPixel(xx, yy);
                    r += pixel.r;
                    g += pixel.g;
                    b += pixel.b;
                }
            }
                    
            pixel.r = r / count;
            pixel.g = g / count;
            pixel.b = b / count;
                    
            var color:int = pixel.value;
            var value:Number = pixel.v;
            pixel.v += 0.15;
            var highlight:int = pixel.value;
            pixel.v = value - 0.15;
            var shadow:int = pixel.value;
                    
            for (yy = ty; yy < ty + HEIGHT; yy++)
            {
                for (xx = tx; xx < tx + WIDTH; xx++)
                {
                    if (yy < 0 || bd.height <= yy) continue;
                    if (xx < 0 || bd.width  <= xx) continue;
                    
                    var cx:int = xx - tx;
                    var cy:int = yy - ty;
                    if ((cx < WIDTH - SIZE && cy < SIZE) || (cx < SIZE && cy < HEIGHT - SIZE)) bd.setPixel(xx, yy, highlight);
                    else if ((WIDTH - SIZE <= cx && cy < HEIGHT) || (0 <= cx && HEIGHT - SIZE <= cy)) bd.setPixel(xx, yy, shadow);
                    else bd.setPixel(xx, yy, color);
                }
            }
        }
    }
}