/**
 * Copyright lizhi ( http://wonderfl.net/user/lizhi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/i11q
 */

package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.net.FileReference;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import sliz.miniui.Button;
    import sliz.miniui.Input;
    import sliz.miniui.Silder;
    /**
     * ...
     * @author sliz http://game-develop.net/
     */
    public class Test4 extends Sprite
    {
        private var bmd:BitmapData;
        private var image:Bitmap;
        private var bmd2:BitmapData;
        private var pbmd:BitmapData;
        
        private var light:Point = new Point;
        private var r:Silder;
        private var g:Silder;
        private var b:Silder;
        private var file:FileReference;
        private var loader:Loader;
        private var input:Input;
        public function Test4() 
        {
            var tf:TextField = new TextField();
            tf.autoSize = TextFieldAutoSize.LEFT;
            var tfm:TextFormat = new TextFormat("Lingoes Unicode", 80,null,false);
            tf.defaultTextFormat = tfm;
            tf.text = "wonderfl";
            tf.filters = [new BlurFilter(2, 2, 3)];
            
            bmd = new BitmapData(tf.width, tf.height, false, 0xffffff);
            bmd.draw(tf);
            pbmd = new BitmapData(bmd.width, bmd.height);
            pbmd.perlinNoise(100, 100, 3, 1, true, true);
            image = new Bitmap(bmd);
            addChild(image);
            image.x = stage.stageWidth / 2 - bmd.width / 2;
            image.y = stage.stageHeight / 2 - bmd.height / 2-70;
            
            r = new Silder(0, 0, this, "r");
            g = new Silder(0, 20, this, "g");
            b = new Silder(0, 40, this, "b");
            r.value = 0.6;
            g.value = 0.7;
            b.value = 0.5;
            
            bmd2 = bmd.clone();
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMM);
            onMM();
            file = new FileReference();
            new Button("browse", 0, 60, this, onClick);
            file.addEventListener(Event.SELECT, onSelect);
            input = new Input("", "", this, null, 0, 80);
            new Button("resetText", 0, 100, this, resetFont);
        }
        
        private function resetFont(e:Event):void
        {
            var tf:TextField = new TextField();
            tf.autoSize = TextFieldAutoSize.LEFT;
            var tfm:TextFormat = new TextFormat("宋体", 80,null,true);
            tf.defaultTextFormat = tfm;
            tf.text = input.text;
            tf.filters = [new BlurFilter(2, 2, 3)];
            
            bmd = new BitmapData(tf.width, tf.height, false, 0xffffff);
            bmd.draw(tf);
            
            pbmd = new BitmapData(bmd.width, bmd.height);
            pbmd.perlinNoise(100, 100, 3, 1, true, true);
            bmd2 = bmd.clone();
            image.bitmapData = bmd;
            image.x = stage.stageWidth / 2 - bmd.width / 2;
            image.y = stage.stageHeight / 2 - bmd.height / 2-70;
        }
        
        private function onClick(e:MouseEvent):void 
        {
            file.browse();
        }
        
        private function onSelect(e:Event):void 
        {
            file.load();
            file.addEventListener(Event.COMPLETE, onLoad);
        }
        
        private function onLoad(e:Event):void 
        {
            loader = new Loader();
            loader.loadBytes(file.data);
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComp);
        }
        
        private function onComp(e:Event):void 
        {
            bmd = (loader.contentLoaderInfo.content as Bitmap).bitmapData;
            image.bitmapData = bmd;
            //bmd.applyFilter(bmd, bmd.rect, new Point, new BlurFilter(2, 2, 3));
            
            pbmd = new BitmapData(bmd.width, bmd.height);
            pbmd.perlinNoise(100, 100, 3, 1, true, true);
            bmd2 = bmd.clone();
            image.x = stage.stageWidth / 2 - bmd.width / 2;
            image.y = stage.stageHeight / 2 - bmd.height / 2-70;
        }
        
        private function onMM(e:MouseEvent=null):void 
        {
            bmd.lock();
            var r:Number = this.r.value;
            var g:Number = this.g.value;
            var b:Number = this.b.value;
            for (var x:int = 0; x < bmd2.width;x++ ) {
                for (var y:int = 0; y < bmd2.height; y++ ) {
                    var c:uint = pbmd.getPixel(x, y);
                    r = (c << 8 >>> 24)/256;
                    g = (c << 16 >>> 24)/256;
                    b = (c << 24 >>> 24)/256;
                    light.x = image.x + x - mouseX;
                    light.y = image.y + y - mouseY;
                    //light.normalize(1);
                    var left:int = bmd2.getPixel(x, y - 1) & 0xff;
                    var right:int = bmd2.getPixel(x, y + 1) & 0xff;
                    var top:int = bmd2.getPixel(x - 1, y) & 0xff;
                    var bottom:int = bmd2.getPixel(x + 1, y) & 0xff;
                    var v1:int = -(right-left)  * light.y;
                    var v2:int = -(bottom - top)  * light.x;
                    light.x = v1;
                    light.y = v2;
                    light.normalize(1);
                    var v:int = light.x * 64 + light.y * 64 + 128; //(v1/4  + v2/4 +0xff) & 0xff;
                    bmd.setPixel(x, y, v*r<<16|v*g<<8|v*b);
                }
            }
            bmd.unlock();
        }
        
    }

}