/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/i08l
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    /**
     *　CountUp
     * ステージをクリックするたびにカウンターに加算されます。
     * @author umhr
     */
    public class WonderflMain extends Sprite 
    {
        
        public function WonderflMain():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            addChild(new Canvas());
            
        }
        
    }
    
}


import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
/**
 * ...
 * @author umhr
 */
class Canvas extends Sprite 
 {
     private var _counter:Counter = new Counter(6);
    public function Canvas() 
    {
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init);
    }
    
    private function init(e:Event = null):void 
    {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        // entry point
        
        stage.addEventListener(MouseEvent.CLICK, onClick);
        
        _counter.x = (stage.stageWidth - _counter.width) * 0.5;
        _counter.y = 50;
        addChild(_counter);
        
    }
    
    private function onClick(e:MouseEvent):void 
    {
        _counter.addCount(int(1000 * Math.random()));
    }
    
}

    
    import com.greensock.easing.Sine;
    import com.greensock.TweenLite;
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFormat;
    /**
     * ...
     * @author umhr
     */
    class Counter extends Sprite 
     {
        private var _count:Object = { score:0, current:0 };
        private var _textFeild:TextField = new TextField();
        private var _fixedLength:int;
        private var _digitNum:int;
        private var _isFixed:Boolean;
        private var _subCount:int = 0;
        public function Counter(fixedLength:int = 0) 
        {
            _isFixed = (fixedLength == 0);
            this.fixedLength = fixedLength;
            init();
        }
        private function init():void {
            _textFeild.defaultTextFormat = new TextFormat("_typewriter", 48, 0xFF0000);
            _textFeild.selectable = false;
            _textFeild.autoSize = "right";
            
            addCount(0);
            _textFeild.x = 0;
            
            addChild(_textFeild);
        }
        
        public function addCount(num:int):void {
            
            var time:Number = Math.min(1, num / 30);
            _count.score += num;
            TweenLite.to(_count, time, { current:_count.score, onUpdate:onUpdate } );
            
            if (_isFixed) {
                fixedLength = String(_count.score).length;
            }
            
            var subCounter:TextField = new TextField();
            subCounter.defaultTextFormat = new TextFormat("_typewriter", 48, 0xFF0000);
            subCounter.selectable = false;
            subCounter.autoSize = "right";
            subCounter.text = String(num);
            subCounter.x = _textFeild.x + _textFeild.width - subCounter.width;
            subCounter.y = 42 + _subCount * 28;
            addChild(subCounter);
            if (_subCount > 0) {
                time = 1;
            }
            TweenLite.to(subCounter, time, { y:0, alpha:0,onComplete:onComplete, onCompleteParams:[subCounter],ease:Sine.easeIn} );
            _subCount ++;
        }
        private function onComplete(subCounter:TextField):void {
            _subCount --;
            removeChild(subCounter);
        }
        
        private function onUpdate():void {
            _textFeild.text = String(_digitNum + Math.floor(_count.current)).substr(1);
        }
        
        public function get fixedLength():int 
        {
            return _fixedLength;
        }
        
        public function set fixedLength(value:int):void 
        {
            _digitNum = Math.pow(10, value);
            _fixedLength = value;
        }
        
        
    }
    