/**
 * Copyright yinaak ( http://wonderfl.net/user/yinaak )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/i021
 */

// forked from ProjectNya's 外部画像の読み込み + 輪郭抽出
////////////////////////////////////////////////////////////////////////////////
// 外部画像の読み込み + 輪郭抽出
//
// [AS3.0] BitmapDataUtilsクラスに挑戦！ (4)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1104
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Matrix;
    import flash.filters.ConvolutionFilter;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var loader:Loader;
        private static var basePath:String = "http://assets.wonderfl.net/images/related_images/";
        private static var filePath:String = "3/30/3017/3017fcecb780512f5c2b28596dbf9d0b43bd2f87";
        private static var tones:uint = 3;
        private static var grade:uint = 8;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, complete, false, 0, true);
            loader.load(new URLRequest(basePath + filePath), new LoaderContext(true));
        }
        private function complete(evt:Event):void {
            loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, complete);
            var content:Bitmap = Bitmap(loader.content);
            content.smoothing = true;
            var grayscale:BitmapData = BitmapDataUtils.grayscale(content.bitmapData);
            var bitmapData:BitmapData = BitmapDataUtils.posterize(grayscale, tones);
            var matrix:Array = [0, -1, 0, -1, grade, -1, 0, -1, 0];
            var convolution:ConvolutionFilter = new ConvolutionFilter(3, 3, matrix, 1, 255);
            var bitmap:Bitmap = new Bitmap(bitmapData);
            //bitmap.filters = [convolution];
            addChild(bitmap);
            bitmap.x = 72;
            bitmap.y = 112;
        }
        
    }

}


//////////////////////////////////////////////////
// BitmapDataUtilsクラス
//////////////////////////////////////////////////

import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.filters.ColorMatrixFilter;

class BitmapDataUtils {
    private static var point:Point = new Point();
    private static var rLuma:Number = 0.212671;
    private static var gLuma:Number = 0.71516;
    private static var bLuma:Number = 0.072169;
    public static const THRESHOLD_LOW:String = "<=";
    public static const THRESHOLD_HIGH:String = ">=";

    public function BitmapDataUtils() {
    }

    public static function grayscale(bd:BitmapData):BitmapData {
        var bitmapData:BitmapData = new BitmapData(bd.width, bd.height, false);
        var colorMatrixFilter:ColorMatrixFilter = new ColorMatrixFilter([rLuma, gLuma, bLuma, 0, 0, rLuma, gLuma, bLuma, 0, 0, rLuma, gLuma, bLuma, 0, 0, 0, 0, 0, 1, 0]);
        var rect:Rectangle = new Rectangle(0, 0, bd.width, bd.height);
        bitmapData.applyFilter(bd, rect, point, colorMatrixFilter);
        return bitmapData;
    }
    public static function binarize(bd:BitmapData, operation:String, threshold:uint):BitmapData {
        var bitmapData:BitmapData = new BitmapData(bd.width, bd.height, true, 0xFFFFFFFF);
        var rect:Rectangle = new Rectangle(0, 0, bd.width, bd.height);
        bitmapData.threshold(bd, rect, point, operation, threshold, 0xFF000000, 255, false);
        return bitmapData;
    }
    public static function posterize(bd:BitmapData, tones:uint):BitmapData {
        if (tones < 2) return bd;
        var bitmapData:BitmapData = new BitmapData(bd.width, bd.height, false);
        var rect:Rectangle = new Rectangle(0, 0, bd.width, bd.height);
        var rPalette:Array = new Array();
        var gPalette:Array = new Array();
        var bPalette:Array = new Array();
        var min:uint = 0;
        var max:uint = 255;
        for (var t:uint = 1; t <= tones; t++) {
        max = Math.floor(256*t/tones);
        var color:uint = Math.floor(255*(t-1)/(tones-1));
        for (var n:uint = min; n < max; n++) {
            rPalette[n] = color << 16;
            gPalette[n] = color << 8;
            bPalette[n] = color;
        }
        min = max;
        }
        bitmapData.paletteMap(bd, rect, point, rPalette, gPalette, bPalette);
        return bitmapData;
    }

}
