/**
 * Copyright hacker_ciaxk5up ( http://wonderfl.net/user/hacker_ciaxk5up )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hzI7
 */

// forked from sandropaula's forked from: forked from: forked from: Emotion Fractal in AS3
// forked from eternity_hiro's forked from: forked from: Emotion Fractal in AS3
// forked from 5ivestar's forked from: Emotion Fractal in AS3
// forked from 5ivestar's Emotion Fractal in AS3
// Emotion Fractal in AS3
// refer to http://levitated.net/daily/levEmotionFractal.html
// Proxy を使いはてなから人気キーワードの RSS を取得

package {
	import flash.display.Sprite;
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.system.Security;
	import caurina.transitions.Tweener;
	import caurina.transitions.properties.TextShortcuts;
        import com.flashdynamix.motion.*;
        import fl.motion.easing.*;


	[SWF(backgroundColor="0x0", frameRate=30)] 

	public class HotwordFractal extends Sprite {

		private var queue:Array;
		private var words:Array;

		public function HotwordFractal() {
			stage.align = "TL";
			stage.scaleMode = "noScale";

			Security.loadPolicyFile("http://5ivestar.org/proxy/crossdomain.xml");
			var loader:URLLoader = new URLLoader();
			loader.addEventListener(Event.COMPLETE, loadingComplete);
			loader.load(new URLRequest("http://5ivestar.org/proxy/http://d.hatena.ne.jp/hotkeyword?mode=rss"));
		}

		public function loadingComplete(e:Event):void {
			var rss:XML = new XML(e.target.data);
			var ns:Namespace = new Namespace(rss.namespace(""));
			words = [];
			for each (var item:Object in rss.ns::item) {
				words.push(item.ns::title.toString());
			}

			init(null);
			TextShortcuts.init();
			addEventListener(MouseEvent.MOUSE_DOWN, init);

		}

		public function init(e:MouseEvent):void {
			Tweener.removeAllTweens();
			while (numChildren) removeChildAt(0);
			queue = [new Rectangle(0, 0, stage.stageWidth, stage.stageHeight)];
			addEventListener(Event.ENTER_FRAME, fill);
		}

		public function fill(e:Event):void {
			var i:int = 0;
			while (queue.length > 0 && i < 3) {
				var rect:Rectangle = queue.pop();
				if (rect.width > 2 && rect.height > 2) {
					fillRegion(rect);
					i++;
				}
			}
			if (!queue.length) removeEventListener(Event.ENTER_FRAME, fill);
		}

		public function fillRegion(region:Rectangle):void {
			var tf:TextField = new TextField();
			var fmt:TextFormat = new TextFormat();
			fmt.font = '_明朝';
                        fmt.color = 0xeeeeee;
			fmt.size = 24;
			fmt.letterSpacing = -0.4;
			fmt.rightMargin = 0.4;
			tf.defaultTextFormat = fmt;
			tf.text = choice(words);
			tf.autoSize = "left";
			tf.selectable = false;

			var bitmap:BitmapData = new BitmapData(tf.width, tf.height, true);
			bitmap.draw(tf);
			var bound:Rectangle = bitmap.getColorBoundsRect(0xFFFFFFFF, 0xFFFFFFFF, false);
			bitmap.dispose();

			var s:Number = region.width / bound.width * (Math.random() * 0.4 + 0.5);
			if (bound.height * s > region.height) s = region.height / bound.height;
			tf.scaleX = s;
			tf.scaleY = s;
			bound.x *= s;
			bound.y *= s;
			bound.width  *= s;
			bound.height *= s;

			switch (choice([1,2,3,4])) {
				case 1:
					tf.x = region.x - bound.x;
					tf.y = region.y - bound.y;
					queue.push(
						new Rectangle(region.x + bound.width, region.y, region.width - bound.width, bound.height),
						new Rectangle(region.x, region.y + bound.height, region.width, region.height - bound.height)
					);
					break;
				case 2:
					tf.x = region.x - bound.x;
					tf.y = region.bottom - bound.bottom;
					queue.push(
						new Rectangle(region.x + bound.width, region.bottom - bound.height, region.width - bound.width, bound.height),
						new Rectangle(region.x, region.y, region.width, region.height - bound.height)
					);
					break;
				case 3:
					tf.x = region.right - bound.right;
					tf.y = region.y - bound.y;
					queue.push(
						new Rectangle(region.x, region.y, region.width - bound.width, bound.height),
						new Rectangle(region.x, region.y + bound.height, region.width, region.height - bound.height)
					);
					break;
				case 4:
					tf.x = region.right - bound.right;
					tf.y = region.bottom - bound.bottom;
					queue.push(
						new Rectangle(region.x, region.bottom - bound.height, region.width - bound.width, bound.height),
						new Rectangle(region.x, region.y, region.width, region.height - bound.height)
					);
					break;
			}

			addChild(tf);
			//Tweener.addTween(tf, {_text_color: 0xFFFFFF * Math.random(), time: 2, transition: "liner"});
                        var tween:TweensyGroup = new TweensyGroup();
                        tween.colorTo(tf, 0x000000, 3);
		}

		private function choice(ary:Array):* {
			return ary[Math.floor(ary.length * Math.random())];
		}

	}
}
